/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.parameter;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.indicator.AddressIndicator;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.Parameter;

public class SccpAddress
implements Parameter,
XMLSerializable {
    public static final String GLOBAL_TITLE = "gt";
    public static final String POINT_CODE = "pc";
    public static final String SUBSYSTEM_NUMBER = "ssn";
    private GlobalTitle gt;
    private int pc = 0;
    private int ssn = -1;
    private AddressIndicator ai;
    private boolean translated;
    protected static final XMLFormat<SccpAddress> XML = new XMLFormat<SccpAddress>(SccpAddress.class){

        public void write(SccpAddress ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(SccpAddress.POINT_CODE, ai.pc);
            xml.setAttribute(SccpAddress.SUBSYSTEM_NUMBER, ai.ssn);
            xml.add((Object)ai.ai, "ai");
            xml.add((Object)ai.gt, SccpAddress.GLOBAL_TITLE);
        }

        public void read(XMLFormat.InputElement xml, SccpAddress ai) throws XMLStreamException {
            ai.pc = xml.getAttribute(SccpAddress.POINT_CODE).toInt();
            ai.ssn = xml.getAttribute(SccpAddress.SUBSYSTEM_NUMBER).toInt();
            ai.ai = (AddressIndicator)xml.get("ai");
            ai.gt = (GlobalTitle)xml.get(SccpAddress.GLOBAL_TITLE);
        }
    };

    public SccpAddress() {
    }

    public SccpAddress(RoutingIndicator ri, int dpc, GlobalTitle gt, int ssn) {
        this.gt = gt;
        this.pc = dpc;
        this.ssn = ssn;
        this.ai = new AddressIndicator(dpc > 0, ssn > 0, ri, gt == null ? GlobalTitleIndicator.NO_GLOBAL_TITLE_INCLUDED : gt.getIndicator());
    }

    public boolean isTranslated() {
        return this.translated;
    }

    public void setTranslated(boolean translated) {
        this.translated = translated;
    }

    public AddressIndicator getAddressIndicator() {
        return this.ai;
    }

    public int getSignalingPointCode() {
        return this.pc;
    }

    public int getSubsystemNumber() {
        return this.ssn;
    }

    public GlobalTitle getGlobalTitle() {
        return this.gt;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SccpAddress)) {
            return false;
        }
        SccpAddress address = (SccpAddress)other;
        boolean res = false;
        if (address.gt != null) {
            res = this.gt != null && address.gt.equals(this.gt);
            return res;
        }
        return address.ssn == this.ssn && address.pc == this.pc;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.gt != null ? this.gt.hashCode() : 0);
        hash = 37 * hash + this.pc;
        hash = 37 * hash + this.ssn;
        return hash;
    }

    public String toString() {
        return "pc=" + this.pc + ",ssn=" + this.ssn + ",gt=" + this.gt;
    }
}

