/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.indicator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EncodingScheme {
    UNKNOWN(0),
    BCD_ODD(1),
    BCD_EVEN(2);

    private int value;

    private EncodingScheme(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static EncodingScheme valueOf(int v) {
        switch (v) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return BCD_ODD;
            }
            case 2: {
                return BCD_EVEN;
            }
        }
        return null;
    }

    public String decodeDigits(InputStream in) throws IOException {
        String digits = "";
        while (in.available() > 0) {
            int b = in.read() & 0xFF;
            digits = digits + Integer.toHexString(b & 0xF) + Integer.toHexString((b & 0xF0) >> 4);
        }
        if (this.value == 1) {
            digits = digits.substring(0, digits.length() - 1);
        }
        return digits;
    }

    public void encodeDigits(String digits, OutputStream out) throws IOException {
        boolean odd = digits.length() % 2 != 0;
        byte b = 0;
        int count = odd ? digits.length() - 1 : digits.length();
        for (int i = 0; i < count - 1; i += 2) {
            String ds1 = digits.substring(i, i + 1);
            String ds2 = digits.substring(i + 1, i + 2);
            int d1 = Integer.parseInt(ds1, 16);
            int d2 = Integer.parseInt(ds2, 16);
            b = (byte)(d2 << 4 | d1);
            out.write(b);
        }
        if (odd) {
            String ds1 = digits.substring(count, count + 1);
            int d = Integer.parseInt(ds1);
            b = (byte)(d & 0xF);
            out.write(b);
        }
    }
}

