/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.sgw;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.m3ua.impl.sg.SgpImpl;
import org.mobicents.protocols.ss7.m3ua.message.transfer.PayloadData;
import org.mobicents.protocols.stream.api.SelectorKey;
import org.mobicents.protocols.stream.api.StreamSelector;
import org.mobicents.ss7.linkset.oam.Layer4;
import org.mobicents.ss7.linkset.oam.Linkset;
import org.mobicents.ss7.linkset.oam.LinksetManager;
import org.mobicents.ss7.linkset.oam.LinksetSelector;
import org.mobicents.ss7.linkset.oam.LinksetStream;

public class NodalInterworkingFunction
implements Layer4 {
    private static Logger logger = Logger.getLogger(NodalInterworkingFunction.class);
    private LinksetSelector linkSetSelector = new LinksetSelector();
    private LinksetStream linksetStream = null;
    private LinksetManager linksetManager = null;
    private SgpImpl sgpImpl = null;
    private boolean started = false;
    private int OP_READ_WRITE = 3;
    private byte[] rxBuffer;
    private ConcurrentLinkedQueue<byte[]> mtpqueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<PayloadData> m3uaqueue = new ConcurrentLinkedQueue();

    public LinksetManager getLinksetManager() {
        return this.linksetManager;
    }

    public void setLinksetManager(LinksetManager linksetManager) {
        this.linksetManager = linksetManager;
    }

    public SgpImpl getSgpImpl() {
        return this.sgpImpl;
    }

    public void setSgpImpl(SgpImpl sgpImpl) {
        this.sgpImpl = sgpImpl;
    }

    public void add(Linkset linkset) {
        try {
            this.linksetStream = linkset.getLinksetStream();
            this.linksetStream.register((StreamSelector)this.linkSetSelector);
        }
        catch (IOException ex) {
            logger.error((Object)String.format("Registration for %s LinksetStream failed", linkset.getName()), (Throwable)ex);
        }
    }

    public void remove(Linkset arg0) {
    }

    public void start() throws Exception {
        this.linksetManager.setLayer4((Layer4)this);
        FastMap map = this.linksetManager.getLinksets();
        FastMap.Entry e = map.head();
        FastMap.Entry end = map.tail();
        while ((e = e.getNext()) != end) {
            Linkset value = (Linkset)e.getValue();
            this.add(value);
        }
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
    }

    protected void perform() throws IOException {
        if (!this.started) {
            return;
        }
        FastList selected = this.linkSetSelector.selectNow(this.OP_READ_WRITE, 1);
        FastList.Node n = selected.head();
        FastList.Node end = selected.tail();
        while ((n = n.getNext()) != end) {
            PayloadData txBuffer;
            SelectorKey key = (SelectorKey)n.getValue();
            ((LinksetStream)key.getStream()).read(this.rxBuffer);
            if (this.rxBuffer != null) {
                this.mtpqueue.offer(this.rxBuffer);
            }
            if (this.m3uaqueue.isEmpty() || (txBuffer = this.m3uaqueue.poll()) == null) continue;
            this.linksetStream.write(txBuffer.getData().getMsu());
        }
        this.sgpImpl.perform();
        PayloadData payload = null;
        while ((payload = this.sgpImpl.poll()) != null) {
            this.m3uaqueue.add(payload);
        }
        byte[] msu = null;
        while ((msu = this.mtpqueue.poll()) != null) {
            this.sgpImpl.send(msu);
        }
    }
}

