/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.sgw;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javolution.util.FastCollection;
import javolution.util.FastSet;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.m3ua.impl.oam.M3UAShellExecutor;
import org.mobicents.ss7.linkset.oam.LinksetExecutor;
import org.mobicents.ss7.management.console.Subject;
import org.mobicents.ss7.management.transceiver.ChannelProvider;
import org.mobicents.ss7.management.transceiver.ChannelSelectionKey;
import org.mobicents.ss7.management.transceiver.ChannelSelector;
import org.mobicents.ss7.management.transceiver.Message;
import org.mobicents.ss7.management.transceiver.MessageFactory;
import org.mobicents.ss7.management.transceiver.ShellChannel;
import org.mobicents.ss7.management.transceiver.ShellServerChannel;

public class ShellExecutor {
    Logger logger = Logger.getLogger(ShellExecutor.class);
    private ChannelProvider provider;
    private ShellServerChannel serverChannel;
    private ShellChannel channel;
    private ChannelSelector selector;
    private ChannelSelectionKey skey;
    private MessageFactory messageFactory = null;
    private String rxMessage = "";
    private String txMessage = "";
    private LinksetExecutor linksetExecutor = null;
    private M3UAShellExecutor m3UAShellExecutor = null;
    private volatile boolean started = false;
    private String address;
    private int port;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public LinksetExecutor getLinksetExecutor() {
        return this.linksetExecutor;
    }

    public void setLinksetExecutor(LinksetExecutor linksetExecutor) {
        this.linksetExecutor = linksetExecutor;
    }

    public M3UAShellExecutor getM3UAShellExecutor() {
        return this.m3UAShellExecutor;
    }

    public void setM3UAShellExecutor(M3UAShellExecutor shellExecutor) {
        this.m3UAShellExecutor = shellExecutor;
    }

    public void start() throws IOException {
        this.provider = ChannelProvider.provider();
        this.serverChannel = this.provider.openServerChannel();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.address, this.port);
        this.serverChannel.bind((SocketAddress)inetSocketAddress);
        this.selector = this.provider.openSelector();
        this.skey = this.serverChannel.register(this.selector, 16);
        this.messageFactory = ChannelProvider.provider().getMessageFactory();
        this.logger.info((Object)String.format("ShellExecutor listening at %s", inetSocketAddress));
        this.started = true;
    }

    public void stop() {
        this.started = false;
        try {
            this.skey.cancel();
            if (this.channel != null) {
                this.channel.close();
            }
            this.serverChannel.close();
            this.selector.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void perform() {
        if (this.started) {
            try {
                FastSet keys = this.selector.selectNow();
                FastCollection.Record record = keys.head();
                FastCollection.Record end = keys.tail();
                while ((record = record.getNext()) != end) {
                    ChannelSelectionKey key = (ChannelSelectionKey)keys.valueOf(record);
                    if (key.isAcceptable()) {
                        this.accept();
                        continue;
                    }
                    if (key.isReadable()) {
                        ShellChannel chan = (ShellChannel)key.channel();
                        Message msg = chan.receive();
                        if (msg != null) {
                            System.out.println("Receive " + msg);
                            this.rxMessage = msg.toString();
                            if (this.rxMessage.compareTo("disconnect") == 0) {
                                this.txMessage = "Bye";
                                chan.send(this.messageFactory.createMessage(this.txMessage));
                            } else {
                                String[] options = this.rxMessage.split(" ");
                                Subject subject = Subject.getSubject((String)options[0]);
                                if (subject == null) {
                                    chan.send(this.messageFactory.createMessage("Invalid Subject"));
                                } else {
                                    options[0] = null;
                                    switch (subject) {
                                        case LINKSET: {
                                            this.txMessage = this.linksetExecutor.execute(options);
                                            chan.send(this.messageFactory.createMessage(this.txMessage));
                                            break;
                                        }
                                        case M3UA: {
                                            this.txMessage = this.m3UAShellExecutor.execute(options);
                                            chan.send(this.messageFactory.createMessage(this.txMessage));
                                        }
                                    }
                                }
                            }
                        }
                        this.rxMessage = "";
                        continue;
                    }
                    if (!key.isWritable() || this.txMessage.length() <= 0) continue;
                    if (this.txMessage.compareTo("Bye") == 0) {
                        this.closeChannel();
                    }
                    this.txMessage = "";
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"Error while operating on ChannelSelectionKey", (Throwable)e);
            }
        }
    }

    private void accept() throws IOException {
        this.channel = this.serverChannel.accept();
        this.skey.cancel();
        this.skey = this.channel.register(this.selector, 5);
        System.out.println("Client connected");
    }

    private void closeChannel() throws IOException {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"Error closing channel", (Throwable)e);
            }
        }
        this.skey.cancel();
        this.skey = this.serverChannel.register(this.selector, 16);
    }
}

