/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.TCAPProviderImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPException;
import org.mobicents.protocols.ss7.tcap.api.TCAPSendException;
import org.mobicents.protocols.ss7.tcap.api.tc.component.OperationState;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.TRPseudoState;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUniRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUserAbortRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TerminationType;
import org.mobicents.protocols.ss7.tcap.asn.AbortSource;
import org.mobicents.protocols.ss7.tcap.asn.AbortSourceType;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.DialogAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogAPDUType;
import org.mobicents.protocols.ss7.tcap.asn.DialogAbortAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogPortion;
import org.mobicents.protocols.ss7.tcap.asn.DialogRequestAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogResponseAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogServiceUserType;
import org.mobicents.protocols.ss7.tcap.asn.DialogUniAPDU;
import org.mobicents.protocols.ss7.tcap.asn.InvokeImpl;
import org.mobicents.protocols.ss7.tcap.asn.Result;
import org.mobicents.protocols.ss7.tcap.asn.ResultSourceDiagnostic;
import org.mobicents.protocols.ss7.tcap.asn.ResultType;
import org.mobicents.protocols.ss7.tcap.asn.TCAbortMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCBeginMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCContinueMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCEndMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCUniMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.UserInformation;
import org.mobicents.protocols.ss7.tcap.asn.comp.Component;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCAbortMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCBeginMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCContinueMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCEndMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCUniMessage;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.DialogPrimitiveFactoryImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCBeginIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCContinueIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCEndIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCPAbortIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCUniIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCUserAbortIndicationImpl;

public class DialogImpl
implements Dialog {
    private static final int _REMOVE_TIMEOUT = 30000;
    private static final Logger logger = Logger.getLogger(DialogImpl.class);
    private ApplicationContextName lastACN;
    private UserInformation lastUI;
    private Long localTransactionId;
    private Long remoteTransactionId;
    private SccpAddress localAddress;
    private SccpAddress remoteAddress;
    private TRPseudoState state = TRPseudoState.Idle;
    private boolean structured = true;
    private static final boolean _INVOKEID_TAKEN = true;
    private static final boolean _INVOKEID_FREE = false;
    private static final int _INVOKE_TABLE_SHIFT = 128;
    private boolean[] invokeIDTable = new boolean[255];
    private int freeCount = this.invokeIDTable.length;
    private InvokeImpl[] operationsSent = new InvokeImpl[this.invokeIDTable.length];
    private ScheduledExecutorService executor;
    private List<Component> scheduledComponentList = new ArrayList<Component>();
    private TCAPProviderImpl provider;

    private static final int getIndexFromInvokeId(Long l) {
        int tmp = l.intValue();
        return tmp + 128;
    }

    private static final Long getInvokeIdFromIndex(int index) {
        int tmp = index - 128;
        return new Long(tmp);
    }

    DialogImpl(SccpAddress localAddress, SccpAddress remoteAddress, Long origTransactionId, boolean structured, ScheduledExecutorService executor, TCAPProviderImpl provider) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.localTransactionId = origTransactionId;
        this.executor = executor;
        this.provider = provider;
        this.structured = origTransactionId > 0L;
        this.structured = structured;
    }

    public void release() {
        this.setState(TRPseudoState.Expunged);
    }

    public Long getDialogId() {
        return this.localTransactionId;
    }

    public synchronized Long getNewInvokeId() {
        if (this.freeCount == 0) {
            return null;
        }
        Long r = null;
        for (int index = 129; index < this.invokeIDTable.length; ++index) {
            if (this.invokeIDTable[index]) continue;
            --this.freeCount;
            this.invokeIDTable[index] = true;
            r = DialogImpl.getInvokeIdFromIndex(index);
            break;
        }
        return r;
    }

    public boolean cancelInvocation(Long invokeId) throws TCAPException {
        int index = DialogImpl.getIndexFromInvokeId(invokeId);
        if (index < 0 || index >= this.operationsSent.length) {
            throw new TCAPException("Wrong invoke id passed.");
        }
        for (index = 0; index < this.scheduledComponentList.size(); ++index) {
            Component cr = this.scheduledComponentList.get(index);
            if (cr.getType() != ComponentType.Invoke || !cr.getInvokeId().equals(invokeId)) continue;
            this.scheduledComponentList.remove(index);
            return true;
        }
        return false;
    }

    private synchronized void freeInvokeId(Long l) {
        int index = DialogImpl.getIndexFromInvokeId(l);
        --this.freeCount;
        this.invokeIDTable[index] = false;
    }

    public SccpAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SccpAddress getLocalAddress() {
        return this.localAddress;
    }

    public boolean isEstabilished() {
        return this.state == TRPseudoState.Active;
    }

    public boolean isStructured() {
        return this.structured;
    }

    public ApplicationContextName getApplicationContextName() {
        return this.lastACN;
    }

    public UserInformation getUserInformation() {
        return this.lastUI;
    }

    public void send(TCBeginRequest event) throws TCAPSendException {
        block7: {
            if (this.state != TRPseudoState.Idle) {
                throw new TCAPSendException("Can not send Begin in this state: " + this.state);
            }
            if (!this.isStructured()) {
                throw new TCAPSendException("Unstructured dialogs do not use Begin");
            }
            TCBeginMessageImpl tcbm = (TCBeginMessageImpl)TcapFactory.createTCBeginMessage();
            if (event.getApplicationContextName() != null) {
                DialogPortion dp = TcapFactory.createDialogPortion();
                dp.setUnidirectional(false);
                DialogRequestAPDU apdu = TcapFactory.createDialogAPDURequest();
                dp.setDialogAPDU((DialogAPDU)apdu);
                apdu.setApplicationContextName(event.getApplicationContextName());
                if (event.getUserInformation() != null) {
                    apdu.setUserInformation(event.getUserInformation());
                }
                tcbm.setDialogPortion(dp);
            }
            tcbm.setOriginatingTransactionId(this.localTransactionId);
            if (this.scheduledComponentList.size() > 0) {
                Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
                this.prepareComponents(componentsToSend);
                tcbm.setComponent(componentsToSend);
            }
            AsnOutputStream aos = new AsnOutputStream();
            try {
                tcbm.encode(aos);
                this.provider.send(aos.toByteArray(), event.getQOS() == null ? (byte)0 : event.getQOS(), this.remoteAddress, this.localAddress);
                this.setState(TRPseudoState.InitialSent);
                this.scheduledComponentList.clear();
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block7;
                logger.error((Object)"Failed to send message: ", (Throwable)e);
            }
        }
    }

    public void send(TCContinueRequest event) throws TCAPSendException {
        if (!this.isStructured()) {
            throw new TCAPSendException("Unstructured dialogs do not use Continue");
        }
        if (this.state == TRPseudoState.InitialReceived) {
            TCContinueMessageImpl tcbm = (TCContinueMessageImpl)TcapFactory.createTCContinueMessage();
            if (event.getApplicationContextName() != null) {
                DialogPortion dp = TcapFactory.createDialogPortion();
                dp.setUnidirectional(false);
                DialogResponseAPDU apdu = TcapFactory.createDialogAPDUResponse();
                dp.setDialogAPDU((DialogAPDU)apdu);
                apdu.setApplicationContextName(event.getApplicationContextName());
                if (event.getUserInformation() != null) {
                    apdu.setUserInformation(event.getUserInformation());
                }
                Result res = TcapFactory.createResult();
                res.setResultType(ResultType.Accepted);
                ResultSourceDiagnostic rsd = TcapFactory.createResultSourceDiagnostic();
                rsd.setDialogServiceUserType(DialogServiceUserType.Null);
                apdu.setResultSourceDiagnostic(rsd);
                apdu.setResult(res);
                tcbm.setDialogPortion(dp);
            }
            tcbm.setOriginatingTransactionId(this.localTransactionId);
            tcbm.setDestinationTransactionId(this.remoteTransactionId);
            if (this.scheduledComponentList.size() > 0) {
                Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
                this.prepareComponents(componentsToSend);
                tcbm.setComponent(componentsToSend);
            }
            if (event.getOriginatingAddress() != null && !event.getOriginatingAddress().equals((Object)this.localAddress)) {
                this.localAddress = event.getOriginatingAddress();
            }
            AsnOutputStream aos = new AsnOutputStream();
            try {
                tcbm.encode(aos);
                this.provider.send(aos.toByteArray(), event.getQOS() == null ? (byte)0 : event.getQOS(), this.remoteAddress, this.localAddress);
                this.setState(TRPseudoState.Active);
                this.scheduledComponentList.clear();
            }
            catch (Exception e) {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)"Failed to send message: ", (Throwable)e);
                }
            }
        } else if (this.state == TRPseudoState.Active) {
            TCContinueMessageImpl tcbm = (TCContinueMessageImpl)TcapFactory.createTCContinueMessage();
            tcbm.setOriginatingTransactionId(this.localTransactionId);
            tcbm.setDestinationTransactionId(this.remoteTransactionId);
            if (this.scheduledComponentList.size() > 0) {
                Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
                this.prepareComponents(componentsToSend);
                tcbm.setComponent(componentsToSend);
            }
            AsnOutputStream aos = new AsnOutputStream();
            try {
                tcbm.encode(aos);
                this.provider.send(aos.toByteArray(), event.getQOS() == null ? (byte)0 : event.getQOS(), this.remoteAddress, this.localAddress);
                this.scheduledComponentList.clear();
            }
            catch (Exception e) {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)"Failed to send message: ", (Throwable)e);
                }
            }
        } else {
            throw new TCAPSendException("Wrong state: " + this.state);
        }
    }

    public void send(TCEndRequest event) throws TCAPSendException {
        block11: {
            if (!this.isStructured()) {
                throw new TCAPSendException("Unstructured dialogs do not use End");
            }
            if (this.state != TRPseudoState.Active) {
                throw new TCAPSendException("State is not: " + TRPseudoState.Active + ", it is: " + this.state);
            }
            TCEndMessageImpl tcbm = (TCEndMessageImpl)TcapFactory.createTCEndMessage();
            tcbm.setDestinationTransactionId(this.remoteTransactionId);
            if (event.getTerminationType() == TerminationType.Basic) {
                if (this.scheduledComponentList.size() > 0) {
                    Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
                    this.prepareComponents(componentsToSend);
                    tcbm.setComponent(componentsToSend);
                }
            } else if (event.getTerminationType() == TerminationType.PreArranged) {
                this.scheduledComponentList.clear();
            } else {
                throw new TCAPSendException("Termination TYPE must be present");
            }
            if (event.getApplicationContextName() != null) {
                DialogPortion dp = TcapFactory.createDialogPortion();
                dp.setUnidirectional(false);
                DialogResponseAPDU apdu = TcapFactory.createDialogAPDUResponse();
                dp.setDialogAPDU((DialogAPDU)apdu);
                apdu.setApplicationContextName(event.getApplicationContextName());
                if (event.getUserInformation() != null) {
                    apdu.setUserInformation(event.getUserInformation());
                }
                Result res = TcapFactory.createResult();
                res.setResultType(ResultType.Accepted);
                ResultSourceDiagnostic rsd = TcapFactory.createResultSourceDiagnostic();
                rsd.setDialogServiceUserType(DialogServiceUserType.Null);
                apdu.setResultSourceDiagnostic(rsd);
                apdu.setResult(res);
                tcbm.setDialogPortion(dp);
            }
            AsnOutputStream aos = new AsnOutputStream();
            try {
                tcbm.encode(aos);
                this.provider.send(aos.toByteArray(), event.getQOS() == null ? (byte)0 : event.getQOS(), this.remoteAddress, this.localAddress);
                this.setState(TRPseudoState.Expunged);
                this.scheduledComponentList.clear();
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block11;
                logger.error((Object)"Failed to send message: ", (Throwable)e);
            }
        }
    }

    public void send(TCUniRequest event) throws TCAPSendException {
        block6: {
            if (this.isStructured()) {
                throw new TCAPSendException("Structured dialogs do not use Uni");
            }
            TCUniMessageImpl msg = (TCUniMessageImpl)TcapFactory.createTCUniMessage();
            if (event.getApplicationContextName() != null) {
                DialogPortion dp = TcapFactory.createDialogPortion();
                DialogUniAPDU apdu = TcapFactory.createDialogAPDUUni();
                apdu.setApplicationContextName(event.getApplicationContextName());
                if (event.getUserInformation() != null) {
                    apdu.setUserInformation(event.getUserInformation());
                }
                dp.setUnidirectional(true);
                dp.setDialogAPDU((DialogAPDU)apdu);
                msg.setDialogPortion(dp);
            }
            if (this.scheduledComponentList.size() > 0) {
                Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
                this.prepareComponents(componentsToSend);
                msg.setComponent(componentsToSend);
            }
            AsnOutputStream aos = new AsnOutputStream();
            try {
                msg.encode(aos);
                this.provider.send(aos.toByteArray(), event.getQOS() == null ? (byte)0 : event.getQOS(), this.remoteAddress, this.localAddress);
                this.setState(TRPseudoState.Expunged);
                this.scheduledComponentList.clear();
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block6;
                logger.error((Object)"Failed to send message: ", (Throwable)e);
            }
        }
    }

    public void send(TCUserAbortRequest event) throws TCAPSendException {
        block5: {
            if (!this.isStructured()) {
                throw new TCAPSendException("Unstructured dialog can not be aborted!");
            }
            if (this.state == TRPseudoState.InitialReceived || this.state == TRPseudoState.InitialSent || this.state == TRPseudoState.Active) {
                if (event.getUserInformation() == null) {
                    throw new IllegalArgumentException("User information MUST be present.");
                }
                DialogPortion dp = TcapFactory.createDialogPortion();
                dp.setUnidirectional(false);
                DialogAbortAPDU dapdu = TcapFactory.createDialogAPDUAbort();
                AbortSource as = TcapFactory.createAbortSource();
                as.setAbortSourceType(AbortSourceType.User);
                dapdu.setAbortSource(as);
                dapdu.setUserInformation(event.getUserInformation());
                dp.setDialogAPDU((DialogAPDU)dapdu);
                TCAbortMessageImpl msg = (TCAbortMessageImpl)TcapFactory.createTCAbortMessage();
                msg.setDestinationTransactionId(this.remoteTransactionId);
                msg.setDialogPortion(dp);
                AsnOutputStream aos = new AsnOutputStream();
                try {
                    msg.encode(aos);
                    this.provider.send(aos.toByteArray(), event.getQOS() == null ? (byte)0 : event.getQOS(), this.remoteAddress, this.localAddress);
                    this.setState(TRPseudoState.Expunged);
                    this.scheduledComponentList.clear();
                }
                catch (Exception e) {
                    if (!logger.isEnabledFor((Priority)Level.ERROR)) break block5;
                    logger.error((Object)"Failed to send message: ", (Throwable)e);
                }
            }
        }
    }

    public void sendComponent(Component componentRequest) throws TCAPSendException {
        if (componentRequest.getType() == ComponentType.Invoke) {
            InvokeImpl invoke = (InvokeImpl)componentRequest;
            int invokeIndex = DialogImpl.getIndexFromInvokeId(invoke.getInvokeId());
            if (this.operationsSent[invokeIndex] != null) {
                throw new TCAPSendException("There is already operation with such invoke id!");
            }
            invoke.setState(OperationState.Pending);
            invoke.setDialog(this);
        }
        this.scheduledComponentList.add(componentRequest);
    }

    private void prepareComponents(Component[] res) {
        int index = 0;
        while (this.scheduledComponentList.size() > index) {
            Component cr = this.scheduledComponentList.get(index);
            if (cr.getType() == ComponentType.Invoke) {
                InvokeImpl in = (InvokeImpl)cr;
                this.operationsSent[DialogImpl.getIndexFromInvokeId((Long)in.getInvokeId())] = in;
                in.setState(OperationState.Sent);
            }
            res[index++] = cr;
        }
    }

    Long getLocalTransactionId() {
        return this.localTransactionId;
    }

    void setLocalTransactionId(Long localTransactionId) {
        this.localTransactionId = localTransactionId;
    }

    Long getRemoteTransactionId() {
        return this.remoteTransactionId;
    }

    void setRemoteTransactionId(Long remoteTransactionId) {
        this.remoteTransactionId = remoteTransactionId;
    }

    void setLocalAddress(SccpAddress localAddress) {
        this.localAddress = localAddress;
    }

    void setRemoteAddress(SccpAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    void processUni(TCUniMessage msg, SccpAddress localAddress, SccpAddress remoteAddress) throws TCAPException {
        if (this.state != TRPseudoState.Idle) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)("Received Uni primitive, but state is not: " + TRPseudoState.Idle + ". Dialog: " + this));
            }
            throw new TCAPException("Received Uni primitive, but state is not: " + TRPseudoState.Idle + ". Dialog: " + this);
        }
        this.setRemoteAddress(remoteAddress);
        this.setLocalAddress(localAddress);
        TCUniIndicationImpl tcUniIndication = (TCUniIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createUniIndication(this);
        tcUniIndication.setDestinationAddress(localAddress);
        tcUniIndication.setOriginatingAddress(remoteAddress);
        Component[] comps = msg.getComponent();
        tcUniIndication.setComponents(comps);
        if (msg.getDialogPortion() != null) {
            DialogPortion dp = msg.getDialogPortion();
            DialogUniAPDU apdu = (DialogUniAPDU)dp.getDialogAPDU();
            this.lastACN = apdu.getApplicationContextName();
            this.lastUI = apdu.getUserInformation();
            tcUniIndication.setApplicationContextName(this.lastACN);
            tcUniIndication.setUserInformation(this.lastUI);
        }
        this.provider.deliver(this, tcUniIndication);
        this.release();
    }

    void processBegin(TCBeginMessage msg, SccpAddress localAddress, SccpAddress remoteAddress) throws TCAPException {
        if (this.state != TRPseudoState.Idle) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)("Received Begin primitive, but state is not: " + TRPseudoState.Idle + ". Dialog: " + this));
            }
            throw new TCAPException("Received Begin primitive, but state is not: " + TRPseudoState.Idle + ". Dialog: " + this);
        }
        this.setRemoteAddress(remoteAddress);
        this.setLocalAddress(localAddress);
        this.setRemoteTransactionId(msg.getOriginatingTransactionId());
        TCBeginIndicationImpl tcBeginIndication = (TCBeginIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createBeginIndication(this);
        tcBeginIndication.setDestinationAddress(localAddress);
        tcBeginIndication.setOriginatingAddress(remoteAddress);
        DialogPortion dialogPortion = msg.getDialogPortion();
        if (dialogPortion != null) {
            DialogAPDU apdu = dialogPortion.getDialogAPDU();
            if (apdu.getType() != DialogAPDUType.Request) {
                throw new TCAPException("Received non-Request APDU: " + apdu.getType() + ". Dialog: " + this);
            }
            DialogRequestAPDU requestAPDU = (DialogRequestAPDU)apdu;
            this.lastACN = requestAPDU.getApplicationContextName();
            this.lastUI = requestAPDU.getUserInformation();
            tcBeginIndication.setApplicationContextName(this.lastACN);
            tcBeginIndication.setUserInformation(this.lastUI);
        }
        tcBeginIndication.setComponents(msg.getComponent());
        this.setState(TRPseudoState.InitialReceived);
        this.provider.deliver(this, tcBeginIndication);
    }

    void processContinue(TCContinueMessage msg, SccpAddress localAddress, SccpAddress remoteAddress) throws TCAPException {
        if (this.state == TRPseudoState.InitialSent) {
            TCContinueIndicationImpl tcContinueIndication = (TCContinueIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createContinueIndication(this);
            this.setRemoteAddress(remoteAddress);
            this.setRemoteTransactionId(msg.getOriginatingTransactionId());
            tcContinueIndication.setOriginatingAddress(remoteAddress);
            DialogPortion dialogPortion = msg.getDialogPortion();
            if (dialogPortion != null) {
                DialogAPDU apdu = dialogPortion.getDialogAPDU();
                if (apdu.getType() != DialogAPDUType.Response) {
                    throw new TCAPException("Received non-Response APDU: " + apdu.getType() + ". Dialog: " + this);
                }
                DialogResponseAPDU responseAPDU = (DialogResponseAPDU)apdu;
                if (!responseAPDU.getApplicationContextName().equals(this.lastACN)) {
                    this.lastACN = responseAPDU.getApplicationContextName();
                }
                if (responseAPDU.getUserInformation() != null) {
                    this.lastUI = responseAPDU.getUserInformation();
                }
                tcContinueIndication.setApplicationContextName(responseAPDU.getApplicationContextName());
                tcContinueIndication.setUserInformation(responseAPDU.getUserInformation());
            }
            tcContinueIndication.setOriginatingAddress(remoteAddress);
            tcContinueIndication.setComponents(this.processOperationsState(msg.getComponent()));
            this.setState(TRPseudoState.Active);
            this.provider.deliver(this, tcContinueIndication);
        } else if (this.state == TRPseudoState.Active) {
            TCContinueIndicationImpl tcContinueIndication = (TCContinueIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createContinueIndication(this);
            tcContinueIndication.setOriginatingAddress(remoteAddress);
            tcContinueIndication.setComponents(this.processOperationsState(msg.getComponent()));
            this.provider.deliver(this, tcContinueIndication);
        } else {
            throw new TCAPException("Received Continue primitive, but state is not proper: " + this.state + ", Dialog: " + this);
        }
    }

    void processEnd(TCEndMessage msg, SccpAddress localAddress, SccpAddress remoteAddress) throws TCAPException {
        TCEndIndicationImpl tcEndIndication = (TCEndIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createEndIndication(this);
        DialogPortion dialogPortion = msg.getDialogPortion();
        if (dialogPortion != null) {
            DialogAPDU apdu = dialogPortion.getDialogAPDU();
            if (apdu.getType() != DialogAPDUType.Response) {
                throw new TCAPException("Received non-Response APDU: " + apdu.getType() + ". Dialog: " + this);
            }
            DialogResponseAPDU responseAPDU = (DialogResponseAPDU)apdu;
            if (!responseAPDU.getApplicationContextName().equals(this.lastACN)) {
                this.lastACN = responseAPDU.getApplicationContextName();
            }
            if (responseAPDU.getUserInformation() != null) {
                this.lastUI = responseAPDU.getUserInformation();
            }
            tcEndIndication.setApplicationContextName(responseAPDU.getApplicationContextName());
            tcEndIndication.setUserInformation(responseAPDU.getUserInformation());
        }
        tcEndIndication.setComponents(this.processOperationsState(msg.getComponent()));
        this.setState(TRPseudoState.Expunged);
        this.provider.deliver(this, tcEndIndication);
    }

    void processAbort(TCAbortMessage msg, SccpAddress localAddress2, SccpAddress remoteAddress2) {
        if (msg.getPAbortCause() != null) {
            TCPAbortIndicationImpl tcAbortIndication = (TCPAbortIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createPAbortIndication(this);
            tcAbortIndication.setPAbortCause(msg.getPAbortCause());
            this.setState(TRPseudoState.Expunged);
            this.provider.deliver(this, tcAbortIndication);
        } else {
            TCUserAbortIndicationImpl tcAbortIndication = (TCUserAbortIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createUAbortIndication(this);
            if (msg.getDialogPortion() != null && msg.getDialogPortion().getDialogAPDU() != null && msg.getDialogPortion().getDialogAPDU().getType() == DialogAPDUType.Abort) {
                DialogAbortAPDU daapdu = (DialogAbortAPDU)msg.getDialogPortion().getDialogAPDU();
                tcAbortIndication.setUserInformation(daapdu.getUserInformation());
                tcAbortIndication.setAbortSource(daapdu.getAbortSource());
            }
            this.setState(TRPseudoState.Expunged);
            this.provider.deliver(this, tcAbortIndication);
        }
    }

    private Component[] processOperationsState(Component[] components) {
        if (components == null) {
            return null;
        }
        ArrayList<Component> resultingIndications = new ArrayList<Component>();
        block4: for (Component ci : components) {
            int index = DialogImpl.getIndexFromInvokeId(ci.getInvokeId());
            InvokeImpl invoke = this.operationsSent[index];
            switch (ci.getType()) {
                case ReturnResultLast: {
                    if (invoke == null) continue block4;
                    invoke.onReturnResultLast();
                    if (!invoke.isSuccessReported()) continue block4;
                    resultingIndications.add(ci);
                    continue block4;
                }
                case ReturnError: {
                    if (invoke == null) continue block4;
                    invoke.onError();
                    if (!invoke.isErrorReported()) continue block4;
                    resultingIndications.add(ci);
                    continue block4;
                }
                default: {
                    resultingIndications.add(ci);
                }
            }
        }
        components = new Component[resultingIndications.size()];
        components = resultingIndications.toArray(components);
        return components;
    }

    private synchronized void setState(TRPseudoState newState) {
        if (this.state == TRPseudoState.Expunged) {
            return;
        }
        this.state = newState;
        if (newState == TRPseudoState.Expunged) {
            RemovalTimerTask rtt = new RemovalTimerTask();
            rtt.d = this;
            this.executor.schedule(rtt, 30000L, TimeUnit.MILLISECONDS);
        }
    }

    public void operationEnded(InvokeImpl tcInvokeRequestImpl) {
        int index = DialogImpl.getIndexFromInvokeId(tcInvokeRequestImpl.getInvokeId());
        this.freeInvokeId(tcInvokeRequestImpl.getInvokeId());
        this.operationsSent[index] = null;
    }

    public void operationTimedOut(InvokeImpl invoke) {
        int index = DialogImpl.getIndexFromInvokeId(invoke.getInvokeId());
        this.freeInvokeId(invoke.getInvokeId());
        this.operationsSent[index] = null;
        this.provider.operationTimedOut(invoke);
    }

    public void resetTimer(Long invokeId) throws TCAPException {
        int index = DialogImpl.getIndexFromInvokeId(invokeId);
        InvokeImpl invoke = this.operationsSent[index];
        if (invoke == null) {
            throw new TCAPException("No operation with this ID");
        }
        invoke.startTimer();
    }

    public TRPseudoState getState() {
        return this.state;
    }

    public String toString() {
        return super.toString() + ": Local[" + this.localTransactionId + "] Remote[" + this.remoteTransactionId + "], LocalAddress[" + this.localAddress + "] RemoteAddress[" + this.remoteAddress + "]";
    }

    private class RemovalTimerTask
    implements Runnable {
        DialogImpl d;

        private RemovalTimerTask() {
        }

        public void run() {
            DialogImpl.this.provider.release(this.d);
        }
    }
}

