/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.sccp.SccpListener;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.message.MessageFactory;
import org.mobicents.protocols.ss7.sccp.message.SccpMessage;
import org.mobicents.protocols.ss7.sccp.message.UnitData;
import org.mobicents.protocols.ss7.sccp.message.XUnitData;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.ProtocolClass;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.DialogImpl;
import org.mobicents.protocols.ss7.tcap.TCAPStackImpl;
import org.mobicents.protocols.ss7.tcap.api.ComponentPrimitiveFactory;
import org.mobicents.protocols.ss7.tcap.api.DialogPrimitiveFactory;
import org.mobicents.protocols.ss7.tcap.api.TCAPException;
import org.mobicents.protocols.ss7.tcap.api.TCAPProvider;
import org.mobicents.protocols.ss7.tcap.api.TCListener;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCPAbortIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUniIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUserAbortIndication;
import org.mobicents.protocols.ss7.tcap.asn.InvokeImpl;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCAbortMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCBeginMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCContinueMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCEndMessage;
import org.mobicents.protocols.ss7.tcap.tc.component.ComponentPrimitiveFactoryImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.DialogPrimitiveFactoryImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCBeginIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCContinueIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCEndIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCPAbortIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCUniIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCUserAbortIndicationImpl;

public class TCAPProviderImpl
implements TCAPProvider,
SccpListener {
    private static final Logger logger = Logger.getLogger(TCAPProviderImpl.class);
    private List<TCListener> tcListeners = new ArrayList<TCListener>();
    private ScheduledExecutorService _EXECUTOR;
    private static final long _4_OCTETS_LONG_FILL = 0xFFFFFFFFL;
    private ComponentPrimitiveFactory componentPrimitiveFactory;
    private DialogPrimitiveFactory dialogPrimitiveFactory;
    private SccpProvider sccpProvider;
    private MessageFactory messageFactory;
    private ParameterFactory parameterFactory;
    private TCAPStackImpl stack;
    private Map<Long, DialogImpl> dialogs = new HashMap<Long, DialogImpl>();
    private SccpAddress address;

    TCAPProviderImpl(SccpProvider sccpProvider, TCAPStackImpl stack, SccpAddress address) {
        this.sccpProvider = sccpProvider;
        this.address = address;
        this.messageFactory = sccpProvider.getMessageFactory();
        this.parameterFactory = sccpProvider.getParameterFactory();
        this.stack = stack;
        this.componentPrimitiveFactory = new ComponentPrimitiveFactoryImpl(this);
        this.dialogPrimitiveFactory = new DialogPrimitiveFactoryImpl(this.componentPrimitiveFactory);
    }

    public void addTCListener(TCListener lst) {
        if (!this.tcListeners.contains(lst)) {
            this.tcListeners.add(lst);
        }
    }

    public void removeTCListener(TCListener lst) {
        this.tcListeners.remove(lst);
    }

    private Long getAvailableTxId() throws TCAPException {
        for (long l = 0L; l <= 0xFFFFFFFFL; ++l) {
            Long ll = new Long(l);
            if (this.dialogs.containsKey(ll)) continue;
            return ll;
        }
        throw new TCAPException("Not enough resources!");
    }

    private Long getAvailableUniTxId() throws TCAPException {
        for (long l = -1L; l >= Long.MIN_VALUE; --l) {
            Long ll = new Long(l);
            if (this.dialogs.containsKey(ll)) continue;
            return ll;
        }
        throw new TCAPException("Not enough resources!");
    }

    public ComponentPrimitiveFactory getComponentPrimitiveFactory() {
        return this.componentPrimitiveFactory;
    }

    public DialogPrimitiveFactory getDialogPrimitiveFactory() {
        return this.dialogPrimitiveFactory;
    }

    public Dialog getNewDialog(SccpAddress localAddress, SccpAddress remoteAddress) throws TCAPException {
        Long id = this.getAvailableTxId();
        return this._getDialog(localAddress, remoteAddress, id, true);
    }

    private Dialog _getDialog(SccpAddress localAddress, SccpAddress remoteAddress, Long id, boolean structured) {
        if (localAddress == null) {
            throw new NullPointerException("LocalAddress must not be null");
        }
        if (remoteAddress == null) {
            throw new NullPointerException("RemoteAddress must not be null");
        }
        DialogImpl di = new DialogImpl(localAddress, remoteAddress, id, structured, this._EXECUTOR, this);
        this.dialogs.put(di.getDialogId(), di);
        return di;
    }

    public Dialog getNewUnstructuredDialog(SccpAddress localAddress, SccpAddress remoteAddress) throws TCAPException {
        Long id = this.getAvailableUniTxId();
        return this._getDialog(localAddress, remoteAddress, id, false);
    }

    public void onMessage(SccpMessage message) {
        try {
            byte[] data = null;
            SccpAddress localAddress = null;
            SccpAddress remoteAddress = null;
            if (message.getType() == 9) {
                data = ((UnitData)message).getData();
                localAddress = ((UnitData)message).getCalledPartyAddress();
                remoteAddress = ((UnitData)message).getCallingPartyAddress();
            } else if (message.getType() == 17) {
                data = ((XUnitData)message).getData();
                localAddress = ((XUnitData)message).getCalledPartyAddress();
                remoteAddress = ((XUnitData)message).getCallingPartyAddress();
            }
            AsnInputStream ais = new AsnInputStream((InputStream)new ByteArrayInputStream(data));
            int tag = ais.readTag();
            switch (tag) {
                case 5: {
                    TCContinueMessage tcm = TcapFactory.createTCContinueMessage(ais);
                    Long dialogId = tcm.getDestinationTransactionId();
                    DialogImpl di = this.dialogs.get(dialogId);
                    if (di == null) {
                        logger.error((Object)("No dialog/transaction for id: " + dialogId));
                        break;
                    }
                    di.processContinue(tcm, localAddress, remoteAddress);
                    break;
                }
                case 2: {
                    TCBeginMessage tcb = TcapFactory.createTCBeginMessage(ais);
                    DialogImpl di = (DialogImpl)this.getNewDialog(localAddress, remoteAddress);
                    di.processBegin(tcb, localAddress, remoteAddress);
                    break;
                }
                case 4: {
                    TCEndMessage teb = TcapFactory.createTCEndMessage(ais);
                    Long dialogId = teb.getDestinationTransactionId();
                    DialogImpl di = this.dialogs.get(dialogId);
                    if (di == null) {
                        logger.error((Object)("No dialog/transaction for id: " + dialogId));
                        break;
                    }
                    di.processEnd(teb, localAddress, remoteAddress);
                    break;
                }
                case 7: {
                    TCAbortMessage tub = TcapFactory.createTCAbortMessage(ais);
                    Long dialogId = tub.getDestinationTransactionId();
                    DialogImpl di = this.dialogs.get(dialogId);
                    if (di == null) {
                        logger.error((Object)("No dialog/transaction for id: " + dialogId));
                        break;
                    }
                    di.processAbort(tub, localAddress, remoteAddress);
                    break;
                }
                case 1: {
                    TCAbortMessage tcuabort = TcapFactory.createTCAbortMessage(ais);
                    Long dialogId = tcuabort.getDestinationTransactionId();
                    DialogImpl di = this.dialogs.get(dialogId);
                    if (di == null) {
                        logger.error((Object)("No dialog/transaction for id: " + dialogId));
                        break;
                    }
                    di.processAbort(tcuabort, localAddress, remoteAddress);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void send(byte[] data, Byte desiredQos, SccpAddress destinationAddress, SccpAddress originatingAddress) throws IOException {
        ProtocolClass pClass = this.parameterFactory.createProtocolClass(0, 0);
        UnitData msg = this.messageFactory.createUnitData(pClass, destinationAddress, originatingAddress);
        msg.setData(data);
        this.sccpProvider.send((SccpMessage)msg);
    }

    public void deliver(DialogImpl dialogImpl, TCBeginIndicationImpl msg) {
        block3: {
            try {
                for (int index = 0; index < this.tcListeners.size(); ++index) {
                    TCListener lst = this.tcListeners.get(index);
                    lst.onTCBegin((TCBeginIndication)msg);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block3;
                logger.error((Object)"Received exception while delivering data to transport layer.", (Throwable)e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCContinueIndicationImpl tcContinueIndication) {
        block3: {
            try {
                for (int index = 0; index < this.tcListeners.size(); ++index) {
                    TCListener lst = this.tcListeners.get(index);
                    lst.onTCContinue((TCContinueIndication)tcContinueIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block3;
                logger.error((Object)"Received exception while delivering data to transport layer.", (Throwable)e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCEndIndicationImpl tcEndIndication) {
        block3: {
            try {
                for (int index = 0; index < this.tcListeners.size(); ++index) {
                    TCListener lst = this.tcListeners.get(index);
                    lst.onTCEnd((TCEndIndication)tcEndIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block3;
                logger.error((Object)"Received exception while delivering data to transport layer.", (Throwable)e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCPAbortIndicationImpl tcAbortIndication) {
        block3: {
            try {
                for (int index = 0; index < this.tcListeners.size(); ++index) {
                    TCListener lst = this.tcListeners.get(index);
                    lst.onTCPAbort((TCPAbortIndication)tcAbortIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block3;
                logger.error((Object)"Received exception while delivering data to transport layer.", (Throwable)e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCUserAbortIndicationImpl tcAbortIndication) {
        block3: {
            try {
                for (int index = 0; index < this.tcListeners.size(); ++index) {
                    TCListener lst = this.tcListeners.get(index);
                    lst.onTCUserAbort((TCUserAbortIndication)tcAbortIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block3;
                logger.error((Object)"Received exception while delivering data to transport layer.", (Throwable)e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCUniIndicationImpl tcUniIndication) {
        block3: {
            try {
                for (int index = 0; index < this.tcListeners.size(); ++index) {
                    TCListener lst = this.tcListeners.get(index);
                    lst.onTCUni((TCUniIndication)tcUniIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block3;
                logger.error((Object)"Received exception while delivering data to transport layer.", (Throwable)e);
            }
        }
    }

    public void release(DialogImpl d) {
        block3: {
            this.dialogs.remove(d.getDialogId());
            try {
                for (int index = 0; index < this.tcListeners.size(); ++index) {
                    TCListener lst = this.tcListeners.get(index);
                    lst.dialogReleased((Dialog)d);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block3;
                logger.error((Object)"Received exception while delivering dialog release.", (Throwable)e);
            }
        }
    }

    public Future createOperationTimer(Runnable operationTimerTask, long invokeTimeout) {
        return this._EXECUTOR.schedule(operationTimerTask, invokeTimeout, TimeUnit.MILLISECONDS);
    }

    public void operationTimedOut(InvokeImpl tcInvokeRequestImpl) {
        block3: {
            try {
                for (int index = 0; index < this.tcListeners.size(); ++index) {
                    TCListener lst = this.tcListeners.get(index);
                    lst.onInvokeTimeout((Invoke)tcInvokeRequestImpl);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block3;
                logger.error((Object)"Received exception while delivering Begin.", (Throwable)e);
            }
        }
    }

    public void linkDown() {
    }

    public void linkUp() {
    }

    void start() {
        logger.info((Object)"Starting TCAP Provider");
        this._EXECUTOR = Executors.newSingleThreadScheduledExecutor();
        this.sccpProvider.registerSccpListener(this.address, (SccpListener)this);
        logger.info((Object)("Registered SCCP listener with address " + this.address));
    }

    void stop() {
        this._EXECUTOR.shutdown();
        this.sccpProvider.deregisterSccpListener(this.address);
    }
}

