/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap;

import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.TCAPProviderImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPProvider;
import org.mobicents.protocols.ss7.tcap.api.TCAPStack;

public class TCAPStackImpl
implements TCAPStack {
    private TCAPProviderImpl tcapProvider;
    private SccpProvider sccpProvider;
    private SccpAddress address;
    private State state = State.IDLE;
    private static final Logger logger = Logger.getLogger(TCAPStackImpl.class);

    public TCAPStackImpl() {
    }

    public TCAPStackImpl(SccpProvider sccpProvider, SccpAddress address) {
        this.sccpProvider = sccpProvider;
        this.tcapProvider = new TCAPProviderImpl(sccpProvider, this, address);
        this.state = State.CONFIGURED;
    }

    public void start() throws IllegalStateException {
        logger.info((Object)("Starting ..." + this.tcapProvider));
        this.tcapProvider.start();
    }

    public void stop() {
        this.tcapProvider.stop();
        this.state = State.CONFIGURED;
    }

    public TCAPProvider getProvider() {
        return this.tcapProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        IDLE,
        CONFIGURED,
        RUNNING;

    }
}

