/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;

public class ApplicationContextNameImpl
implements ApplicationContextName {
    private long[] oid;

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int len = ais.readLength();
            int tag = ais.readTag();
            if (tag != 6) {
                throw new ParseException("Expected OID tag, found: " + tag);
            }
            this.oid = ais.readObjectIdentifier();
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.oid == null) {
            throw new ParseException("No OID value set!");
        }
        try {
            AsnOutputStream localAOS = new AsnOutputStream();
            localAOS.writeObjectIdentifier(this.oid);
            byte[] oidEncoded = localAOS.toByteArray();
            aos.writeTag(2, false, 1);
            aos.writeLength(oidEncoded.length);
            aos.write(oidEncoded);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public long[] getOid() {
        return this.oid;
    }

    public void setOid(long[] oid) {
        this.oid = oid;
    }
}

