/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.AbortSource;
import org.mobicents.protocols.ss7.tcap.asn.DialogAPDUType;
import org.mobicents.protocols.ss7.tcap.asn.DialogAbortAPDU;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.UserInformation;

public class DialogAbortAPDUImpl
implements DialogAbortAPDU {
    private AbortSource abortSource;
    private UserInformation userInformation;

    public AbortSource getAbortSource() {
        return this.abortSource;
    }

    public void setAbortSource(AbortSource abortSource) {
        this.abortSource = abortSource;
    }

    public UserInformation getUserInformation() {
        return this.userInformation;
    }

    public void setUserInformation(UserInformation userInformation) {
        this.userInformation = userInformation;
    }

    public DialogAPDUType getType() {
        return DialogAPDUType.Abort;
    }

    public boolean isUniDirectional() {
        return false;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int len = ais.readLength();
            if (len == 128) {
                throw new ParseException("Undefined len not supported!");
            }
            byte[] dataChunk = new byte[len];
            if (len != ais.read(dataChunk)) {
                throw new ParseException("Not enough data read.");
            }
            AsnInputStream localAis = new AsnInputStream((InputStream)new ByteArrayInputStream(dataChunk));
            int tag = localAis.readTag();
            if (tag != 0) {
                throw new ParseException("Expected Abort Source tag, found: " + tag);
            }
            this.abortSource = TcapFactory.createAbortSource(localAis);
            if (localAis.available() > 0) {
                tag = localAis.readTag();
                if (tag != 30) {
                    throw new ParseException("Expected UserInformation tag, found: " + tag);
                }
                this.userInformation = TcapFactory.createUserInformation(localAis);
            }
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.abortSource == null) {
            throw new ParseException("No Abort Source Name!");
        }
        try {
            AsnOutputStream localAos = new AsnOutputStream();
            localAos.reset();
            byte[] byteData = null;
            if (this.userInformation != null) {
                this.userInformation.encode(localAos);
                byteData = localAos.toByteArray();
                localAos.reset();
            }
            this.abortSource.encode(localAos);
            if (byteData != null) {
                localAos.write(byteData);
            }
            byteData = localAos.toByteArray();
            aos.writeTag(1, false, 4);
            aos.writeLength(byteData.length);
            aos.write(byteData);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

