/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.BitSet;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.asn.External;
import org.mobicents.protocols.ss7.tcap.asn.DialogAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogPortion;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;

public class DialogPortionImpl
extends External
implements DialogPortion {
    private static final long[] _DIALG_UNI = new long[]{0L, 0L, 17L, 773L, 1L, 2L, 1L};
    private static final long[] _DIALG_STRUCTURED = new long[]{0L, 0L, 17L, 773L, 1L, 1L, 1L};
    private DialogAPDU dialogAPDU;
    private boolean uniDirectional;

    public DialogPortionImpl() {
        this.setOid(true);
        this.setAsn(true);
    }

    public boolean isUnidirectional() {
        return this.uniDirectional;
    }

    public void setUnidirectional(boolean flag) {
        this.oidValue = flag ? _DIALG_UNI : _DIALG_STRUCTURED;
        this.uniDirectional = flag;
    }

    public DialogAPDU getDialogAPDU() {
        return this.dialogAPDU;
    }

    public void setDialogAPDU(DialogAPDU dialogAPDU) {
        this.dialogAPDU = dialogAPDU;
    }

    public BitSet getEncodeBitStringType() {
        throw new UnsupportedOperationException();
    }

    public byte[] getEncodeType() throws AsnException {
        if (this.dialogAPDU == null) {
            throw new AsnException("No APDU!");
        }
        AsnOutputStream aos = new AsnOutputStream();
        this.dialogAPDU.encode(aos);
        return aos.toByteArray();
    }

    public void setEncodeBitStringType(BitSet data) {
        throw new UnsupportedOperationException();
    }

    public void setEncodeType(byte[] data) {
        throw new UnsupportedOperationException();
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        AsnOutputStream localAsn = new AsnOutputStream();
        try {
            super.encode(localAsn);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
        aos.writeTag(1, false, 11);
        byte[] externalData = localAsn.toByteArray();
        try {
            aos.writeLength(externalData.length);
            aos.write(externalData);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int len = ais.readLength();
            int tag = ais.readTag();
            if (tag != 8) {
                throw new AsnException("Wrong value of tag, expected EXTERNAL, found: " + tag);
            }
            super.decode(ais);
            if (!this.isAsn() || !this.isOid()) {
                throw new ParseException("Wrong encode(" + this.isOid() + ")/encoding(" + this.isAsn() + ") types");
            }
            this.uniDirectional = Arrays.equals(_DIALG_UNI, this.getOidValue());
            byte[] dialogPdu = super.getEncodeType();
            AsnInputStream loaclAsnIS = new AsnInputStream((InputStream)new ByteArrayInputStream(dialogPdu));
            tag = loaclAsnIS.readTag();
            this.dialogAPDU = TcapFactory.createDialogAPDU(loaclAsnIS, tag, this.isUnidirectional());
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException((Throwable)e);
        }
    }
}

