/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.DialogAPDUType;
import org.mobicents.protocols.ss7.tcap.asn.DialogResponseAPDU;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.ProtocolVersion;
import org.mobicents.protocols.ss7.tcap.asn.Result;
import org.mobicents.protocols.ss7.tcap.asn.ResultSourceDiagnostic;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.UserInformation;

public class DialogResponseAPDUImpl
implements DialogResponseAPDU {
    private ApplicationContextName acn;
    private Result result;
    private ResultSourceDiagnostic diagnostic;
    private UserInformation ui;

    public ApplicationContextName getApplicationContextName() {
        return this.acn;
    }

    public int getProtocolVersion() {
        return 1;
    }

    public UserInformation getUserInformation() {
        return this.ui;
    }

    public void setApplicationContextName(ApplicationContextName acn) {
        this.acn = acn;
    }

    public void setUserInformation(UserInformation ui) {
        this.ui = ui;
    }

    public Result getResult() {
        return this.result;
    }

    public ResultSourceDiagnostic getResultSourceDiagnostic() {
        return this.diagnostic;
    }

    public void setResult(Result acn) {
        this.result = acn;
    }

    public void setResultSourceDiagnostic(ResultSourceDiagnostic acn) {
        this.diagnostic = acn;
    }

    public DialogAPDUType getType() {
        return DialogAPDUType.Response;
    }

    public boolean isUniDirectional() {
        return false;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int len = ais.readLength();
            if (len == 128) {
                throw new ParseException("Undefined len not supported!");
            }
            byte[] dataChunk = new byte[len];
            if (len != ais.read(dataChunk)) {
                throw new ParseException("Not enough data read.");
            }
            AsnInputStream localAis = new AsnInputStream((InputStream)new ByteArrayInputStream(dataChunk));
            int tag = localAis.readTag();
            if (tag == 0) {
                TcapFactory.createProtocolVersion(localAis);
                tag = localAis.readTag();
            }
            if (tag != 1) {
                throw new ParseException("Expected Application Context Name tag, found: " + tag);
            }
            this.acn = TcapFactory.createApplicationContextName(localAis);
            tag = localAis.readTag();
            if (tag != 2) {
                throw new ParseException("Expected Result tag, found: " + tag);
            }
            this.result = TcapFactory.createResult(localAis);
            tag = localAis.readTag();
            if (tag != 3) {
                throw new ParseException("Expected Result Source Diagnotstic tag, found: " + tag);
            }
            this.diagnostic = TcapFactory.createResultSourceDiagnostic(localAis);
            if (localAis.available() > 0) {
                tag = localAis.readTag();
                if (tag != 30) {
                    throw new ParseException("Expected UserInformation tag, found: " + tag);
                }
                this.ui = TcapFactory.createUserInformation(localAis);
            }
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.acn == null) {
            throw new ParseException("No Application Context Name!");
        }
        if (this.result == null) {
            throw new ParseException("No Result!");
        }
        if (this.diagnostic == null) {
            throw new ParseException("No Result Source Diagnostic!");
        }
        try {
            AsnOutputStream localAos = new AsnOutputStream();
            localAos.reset();
            byte[] byteData = null;
            if (this.ui != null) {
                this.ui.encode(localAos);
                byteData = localAos.toByteArray();
                localAos.reset();
                localAos.writeSequence(byteData);
                byteData = localAos.toByteArray();
            }
            ProtocolVersion pv = TcapFactory.createProtocolVersion();
            pv.encode(localAos);
            this.acn.encode(localAos);
            this.result.encode(localAos);
            this.diagnostic.encode(localAos);
            if (byteData != null) {
                localAos.write(byteData);
            }
            byteData = localAos.toByteArray();
            aos.writeTag(1, false, 1);
            aos.writeLength(byteData.length);
            aos.write(byteData);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

