/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.DialogAPDUType;
import org.mobicents.protocols.ss7.tcap.asn.DialogUniAPDU;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.ProtocolVersion;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.UserInformation;

public class DialogUniAPDUImpl
implements DialogUniAPDU {
    private ApplicationContextName acn;
    private UserInformation ui;

    public ApplicationContextName getApplicationContextName() {
        return this.acn;
    }

    public int getProtocolVersion() {
        return 1;
    }

    public UserInformation getUserInformation() {
        return this.ui;
    }

    public void setApplicationContextName(ApplicationContextName acn) {
        this.acn = acn;
    }

    public void setUserInformation(UserInformation ui) {
        this.ui = ui;
    }

    public DialogAPDUType getType() {
        return DialogAPDUType.Request;
    }

    public boolean isUniDirectional() {
        return false;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int len = ais.readLength();
            if (len == 128) {
                throw new ParseException("Undefined len not supported!");
            }
            byte[] dataChunk = new byte[len];
            if (len != ais.read(dataChunk)) {
                throw new ParseException("Not enough data read.");
            }
            AsnInputStream localAis = new AsnInputStream((InputStream)new ByteArrayInputStream(dataChunk));
            int tag = localAis.readTag();
            if (tag == 0) {
                TcapFactory.createProtocolVersion(localAis);
                tag = localAis.readTag();
            }
            if (tag != 1) {
                throw new ParseException("Expected Application Context Name tag, found: " + tag);
            }
            this.acn = TcapFactory.createApplicationContextName(localAis);
            if (localAis.available() > 0) {
                tag = localAis.readTag();
                if (tag != 30) {
                    throw new ParseException("Expected UserInformation tag, found: " + tag);
                }
                this.ui = TcapFactory.createUserInformation(localAis);
            }
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.acn == null) {
            throw new ParseException("No Application Context Name!");
        }
        try {
            AsnOutputStream localAos = new AsnOutputStream();
            localAos.reset();
            byte[] byteData = null;
            if (this.ui != null) {
                this.ui.encode(localAos);
                byteData = localAos.toByteArray();
                localAos.reset();
                localAos.writeSequence(byteData);
                byteData = localAos.toByteArray();
            }
            ProtocolVersion pv = TcapFactory.createProtocolVersion();
            pv.encode(localAos);
            this.acn.encode(localAos);
            if (byteData != null) {
                localAos.write(byteData);
            }
            byteData = localAos.toByteArray();
            aos.writeTag(1, false, 0);
            aos.writeLength(byteData.length);
            aos.write(byteData);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

