/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCodeType;

public class ErrorCodeImpl
implements ErrorCode {
    private ErrorCodeType errorType;
    private byte[] data;

    public byte[] getData() {
        return this.data;
    }

    public ErrorCodeType getErrorType() {
        return this.errorType;
    }

    public void setData(byte[] d) {
        this.data = d;
    }

    public void setErrorType(ErrorCodeType t) {
        this.errorType = t;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int len = ais.readLength();
            this.data = new byte[len];
            if (len != ais.read(this.data)) {
                throw new ParseException("Not enough data read.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.errorType == null) {
            throw new ParseException("No error type set!");
        }
        if (this.data == null) {
            throw new ParseException("No data set!");
        }
        try {
            if (this.errorType == ErrorCodeType.Local) {
                aos.writeTag(0, true, 2);
            } else {
                aos.writeTag(0, true, 6);
            }
            aos.writeLength(this.data.length);
            aos.write(this.data);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

