/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.DialogImpl;
import org.mobicents.protocols.ss7.tcap.TCAPProviderImpl;
import org.mobicents.protocols.ss7.tcap.api.tc.component.InvokeClass;
import org.mobicents.protocols.ss7.tcap.api.tc.component.OperationState;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class InvokeImpl
implements Invoke {
    private Long invokeId;
    private Long linkedId;
    private OperationCode operationCode;
    private Parameter parameter;
    private static final long _DEFAULT_TIMEOUT = 10000L;
    private InvokeClass invokeClass = InvokeClass.Class1;
    private long invokeTimeout = 10000L;
    private OperationState state = OperationState.Idle;
    private Future timerFuture;
    private OperationTimerTask operationTimerTask = new OperationTimerTask();
    private TCAPProviderImpl provider;
    private DialogImpl dialog;

    public Long getInvokeId() {
        return this.invokeId;
    }

    public Long getLinkedId() {
        return this.linkedId;
    }

    public OperationCode getOperationCode() {
        return this.operationCode;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setInvokeId(Long i) {
        if (i == null || i < -128L || i > 127L) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.invokeId = i;
    }

    public void setLinkedId(Long i) {
        if (i == null || i < -128L || i > 127L) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.linkedId = i;
    }

    public void setOperationCode(OperationCode i) {
        this.operationCode = i;
    }

    public void setParameter(Parameter p) {
        this.parameter = p;
    }

    public ComponentType getType() {
        return ComponentType.Invoke;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int len = ais.readLength();
            if (ais.available() < len) {
                throw new ParseException("Not enough data!");
            }
            byte[] data = new byte[len];
            if (data.length != ais.read(data)) {
                throw new ParseException("Not enought data read.");
            }
            AsnInputStream localAis = new AsnInputStream((InputStream)new ByteArrayInputStream(data));
            int tag = localAis.readTag();
            if (tag != 2) {
                throw new ParseException("Expected InvokeID tag, found: " + tag);
            }
            this.invokeId = localAis.readInteger();
            tag = localAis.readTag();
            if (tag == 0) {
                this.linkedId = localAis.readInteger();
                tag = localAis.readTag();
            }
            if (tag == 6 || tag == 2) {
                this.operationCode = TcapFactory.createOperationCode(tag, localAis);
                if (localAis.available() <= 0) {
                    return;
                }
            } else {
                throw new ParseException("Expected Local|Global Operation Code tag, found: " + tag);
            }
            tag = localAis.readTag();
            this.parameter = TcapFactory.createParameter(tag, localAis);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.invokeId == null) {
            throw new ParseException("Invoke ID not set!");
        }
        if (this.operationCode == null) {
            throw new ParseException("Operation Code not set!");
        }
        try {
            AsnOutputStream localAos = new AsnOutputStream();
            localAos.writeInteger(0, 2, this.invokeId.longValue());
            if (this.linkedId != null) {
                localAos.writeInteger(2, 0, this.linkedId.longValue());
            }
            this.operationCode.encode(localAos);
            if (this.parameter != null) {
                this.parameter.encode(localAos);
            }
            byte[] data = localAos.toByteArray();
            aos.writeTag(2, false, 1);
            aos.writeLength(data.length);
            aos.write(data);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public InvokeClass getInvokeClass() {
        return this.invokeClass;
    }

    public void setInvokeClass(InvokeClass invokeClass) {
        if (invokeClass != null) {
            this.invokeClass = invokeClass;
        }
    }

    public long getInvokeTimeout() {
        return this.invokeTimeout;
    }

    public void setInvokeTimeout(long invokeTimeout) {
        this.invokeTimeout = invokeTimeout;
    }

    public TCAPProviderImpl getProvider() {
        return this.provider;
    }

    public void setProvider(TCAPProviderImpl provider) {
        this.provider = provider;
    }

    public DialogImpl getDialog() {
        return this.dialog;
    }

    public void setDialog(DialogImpl dialog) {
        this.dialog = dialog;
    }

    public OperationState getState() {
        return this.state;
    }

    public synchronized void setState(OperationState state) {
        if (this.dialog == null) {
            return;
        }
        OperationState old = this.state;
        this.state = state;
        if (old != state) {
            switch (state) {
                case Sent: {
                    this.startTimer();
                    break;
                }
                case Idle: 
                case Reject_W: {
                    this.stopTimer();
                    this.dialog.operationEnded(this);
                }
            }
            if (state == OperationState.Sent || state == OperationState.Idle || state == OperationState.Reject_W) {
                // empty if block
            }
        }
    }

    public void onReturnResultLast() {
        this.setState(OperationState.Idle);
    }

    public void onError() {
        this.setState(OperationState.Idle);
    }

    public synchronized void startTimer() {
        this.stopTimer();
        this.timerFuture = this.provider.createOperationTimer(this.operationTimerTask, this.invokeTimeout);
    }

    public synchronized void stopTimer() {
        if (this.timerFuture != null) {
            this.timerFuture.cancel(false);
            this.timerFuture = null;
        }
    }

    public boolean isErrorReported() {
        return this.invokeClass == InvokeClass.Class1 || this.invokeClass == InvokeClass.Class2;
    }

    public boolean isSuccessReported() {
        return this.invokeClass == InvokeClass.Class1 || this.invokeClass == InvokeClass.Class3;
    }

    private class OperationTimerTask
    implements Runnable {
        InvokeImpl invoke;

        private OperationTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InvokeImpl invokeImpl = this.invoke;
            synchronized (invokeImpl) {
                InvokeImpl.this.timerFuture = null;
                InvokeImpl.this.setState(OperationState.Idle);
                this.invoke.dialog.operationTimedOut(this.invoke);
            }
        }
    }
}

