/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCodeType;

public class OperationCodeImpl
implements OperationCode {
    private Long operationCode;
    private OperationCodeType type;

    public Long getCode() {
        return this.operationCode;
    }

    public OperationCodeType getOperationType() {
        return this.type;
    }

    public void setCode(Long i) {
        this.operationCode = i;
    }

    public void setOperationType(OperationCodeType t) {
        this.type = t;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            this.operationCode = ais.readInteger();
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.type == null) {
            throw new ParseException("No indication Global|Local.");
        }
        if (this.operationCode == null) {
            throw new ParseException("Operation code not set.");
        }
        try {
            if (this.type == OperationCodeType.Global) {
                aos.writeInteger(0, 6, this.operationCode.longValue());
            } else {
                aos.writeInteger(0, 2, this.operationCode.longValue());
            }
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

