/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class ParameterImpl
implements Parameter {
    private byte[] data;
    private Parameter[] parameters;
    private boolean primitive = true;
    private int tag;
    private int tagClass;

    public byte[] getData() {
        return this.data;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public void setData(byte[] b) {
        this.data = b;
        if (this.data != null) {
            this.setParameters(null);
        }
    }

    public void setPrimitive(boolean b) {
        if (this.parameters != null && b) {
            throw new IllegalArgumentException("Can not set primitive flag since Parameter[] is present!");
        }
        this.primitive = b;
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public int getTagClass() {
        return this.tagClass;
    }

    public void setTagClass(int tagClass) {
        this.tagClass = tagClass;
    }

    public Parameter[] getParameters() {
        if (this.parameters == null && !this.isPrimitive()) {
            if (this.data == null) {
                return this.parameters;
            }
            ArrayList<Parameter> paramsList = new ArrayList<Parameter>();
            try {
                AsnInputStream ais = new AsnInputStream((InputStream)new ByteArrayInputStream(this.data));
                while (ais.available() > 0) {
                    int tag = ais.readTag();
                    Parameter _p = TcapFactory.createParameter(tag, ais);
                    paramsList.add(_p);
                }
                this.parameters = new Parameter[paramsList.size()];
                this.parameters = paramsList.toArray(this.parameters);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse raw data into constrcuted parameter", e);
            }
        }
        return this.parameters;
    }

    public void setParameters(Parameter[] paramss) {
        this.parameters = paramss;
        if (this.parameters != null) {
            this.setData(null);
            this.setPrimitive(false);
        }
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            this.primitive = ais.isTagPrimitive();
            this.tagClass = ais.getTagClass();
            int len = ais.readLength();
            if (len == 128) {
                throw new ParseException("Undefined length is not supported.");
            }
            this.data = new byte[len];
            int tlen = ais.read(this.data);
            if (tlen != len) {
                throw new ParseException("Not enough data read, expected: " + len + ", actaul: " + tlen);
            }
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.data == null && this.parameters == null) {
            throw new ParseException("Parameter data not set.");
        }
        aos.writeTag(this.tagClass, this.primitive, this.tag);
        if (this.data == null) {
            AsnOutputStream localAos = new AsnOutputStream();
            for (Parameter p : this.parameters) {
                p.encode(localAos);
            }
            this.data = localAos.toByteArray();
        }
        try {
            aos.writeLength(this.data.length);
            aos.write(this.data);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

