/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.comp.GeneralProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.InvokeProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.protocols.ss7.tcap.asn.comp.ProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnErrorProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultProblemType;

public class ProblemImpl
implements Problem {
    private ProblemType type;
    private GeneralProblemType generalProblemType;
    private InvokeProblemType invokeProblemType;
    private ReturnErrorProblemType returnErrorProblemType;
    private ReturnResultProblemType returnResultProblemType;

    public ProblemType getType() {
        return this.type;
    }

    public void setType(ProblemType type) {
        this.type = type;
    }

    public GeneralProblemType getGeneralProblemType() {
        return this.generalProblemType;
    }

    public void setGeneralProblemType(GeneralProblemType generalProblemType) {
        this.generalProblemType = generalProblemType;
        this.setType(ProblemType.General);
    }

    public InvokeProblemType getInvokeProblemType() {
        return this.invokeProblemType;
    }

    public void setInvokeProblemType(InvokeProblemType invokeProblemType) {
        this.setType(ProblemType.Invoke);
        this.invokeProblemType = invokeProblemType;
    }

    public ReturnErrorProblemType getReturnErrorProblemType() {
        return this.returnErrorProblemType;
    }

    public void setReturnErrorProblemType(ReturnErrorProblemType returnErrorProblemType) {
        this.returnErrorProblemType = returnErrorProblemType;
        this.setType(ProblemType.ReturnError);
    }

    public ReturnResultProblemType getReturnResultProblemType() {
        return this.returnResultProblemType;
    }

    public void setReturnResultProblemType(ReturnResultProblemType returnResultProblemType) {
        this.returnResultProblemType = returnResultProblemType;
        this.setType(ProblemType.ReturnResult);
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            long t = ais.readInteger();
            switch (this.type) {
                case General: {
                    this.generalProblemType = GeneralProblemType.getFromInt((long)t);
                    break;
                }
                case Invoke: {
                    this.invokeProblemType = InvokeProblemType.getFromInt((long)t);
                    break;
                }
                case ReturnError: {
                    this.returnErrorProblemType = ReturnErrorProblemType.getFromInt((long)t);
                    break;
                }
                case ReturnResult: {
                    this.returnResultProblemType = ReturnResultProblemType.getFromInt((long)t);
                    break;
                }
                default: {
                    throw new ParseException();
                }
            }
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        try {
            switch (this.type) {
                case General: {
                    if (this.generalProblemType == null) {
                        throw new ParseException("Problem Type is General, no specific type set");
                    }
                    aos.writeInteger(2, (int)this.type.getTypeTag(), this.generalProblemType.getType());
                    break;
                }
                case Invoke: {
                    if (this.invokeProblemType == null) {
                        throw new ParseException("Problem Type is Invoke, no specific type set");
                    }
                    aos.writeInteger(2, (int)this.type.getTypeTag(), this.invokeProblemType.getType());
                    break;
                }
                case ReturnError: {
                    if (this.returnErrorProblemType == null) {
                        throw new ParseException("Problem Type is ReturnError, no specific type set");
                    }
                    aos.writeInteger(2, (int)this.type.getTypeTag(), this.returnErrorProblemType.getType());
                    break;
                }
                case ReturnResult: {
                    if (this.returnResultProblemType == null) {
                        throw new ParseException("Problem Type is Result, no specific type set");
                    }
                    aos.writeInteger(2, (int)this.type.getTypeTag(), this.returnResultProblemType.getType());
                    break;
                }
                default: {
                    throw new ParseException();
                }
            }
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

