/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.protocols.ss7.tcap.asn.comp.ProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Reject;

public class RejectImpl
implements Reject {
    private Long invokeId;
    private Problem problem;

    public Long getInvokeId() {
        return this.invokeId;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setInvokeId(Long i) {
        if (i != null && (i < -128L || i > 127L)) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.invokeId = i;
    }

    public void setProblem(Problem p) {
        this.problem = p;
    }

    public ComponentType getType() {
        return ComponentType.Reject;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int len = ais.readLength();
            if (len == 128) {
                throw new ParseException("Undefined length is not supported.");
            }
            if (len > ais.available()) {
                throw new ParseException("Not enough data.");
            }
            int tag = ais.readTag();
            if (tag == 2) {
                this.invokeId = ais.readInteger();
                tag = ais.readTag();
            } else if (tag == 5) {
                ais.readLength();
                tag = ais.readTag();
            }
            ProblemType pt = ProblemType.getFromInt((long)tag);
            this.problem = TcapFactory.createProblem(pt, ais);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.problem == null) {
            throw new ParseException("Problem not set!");
        }
        try {
            AsnOutputStream localAos = new AsnOutputStream();
            if (this.invokeId == null) {
                localAos.writeTag(0, true, 5);
                localAos.writeLength(0);
            } else {
                localAos.writeInteger(0, 2, this.invokeId.longValue());
            }
            this.problem.encode(localAos);
            byte[] data = localAos.toByteArray();
            aos.writeTag(2, false, 4);
            aos.writeLength(data.length);
            aos.write(data);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

