/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.Result;
import org.mobicents.protocols.ss7.tcap.asn.ResultType;

public class ResultImpl
implements Result {
    private ResultType resultType;

    public ResultType getResultType() {
        return this.resultType;
    }

    public void setResultType(ResultType t) {
        this.resultType = t;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int len = ais.readLength();
            if (len > ais.available()) {
                throw new ParseException("Not enough data: " + ais.available());
            }
            int tag = ais.readTag();
            if (tag != 2) {
                throw new ParseException("Expected INTEGER tag, found: " + tag);
            }
            long t = ais.readInteger();
            this.resultType = ResultType.getFromInt((long)t);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.resultType == null) {
            throw new ParseException("No type set!");
        }
        try {
            AsnOutputStream localAos = new AsnOutputStream();
            localAos.writeInteger(this.resultType.getType());
            byte[] b = localAos.toByteArray();
            aos.writeTag(2, false, 2);
            aos.writeLength(b.length);
            aos.write(b);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

