/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.DialogServiceProviderType;
import org.mobicents.protocols.ss7.tcap.asn.DialogServiceUserType;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.ResultSourceDiagnostic;

public class ResultSourceDiagnosticImpl
implements ResultSourceDiagnostic {
    private DialogServiceProviderType providerType;
    private DialogServiceUserType userType;

    public DialogServiceProviderType getDialogServiceProviderType() {
        return this.providerType;
    }

    public DialogServiceUserType getDialogServiceUserType() {
        return this.userType;
    }

    public void setDialogServiceProviderType(DialogServiceProviderType t) {
        this.providerType = t;
        this.userType = null;
    }

    public void setDialogServiceUserType(DialogServiceUserType t) {
        this.userType = t;
        this.providerType = null;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int len = ais.readLength();
            if (len > ais.available()) {
                throw new ParseException("Not enough data.");
            }
            int tag = ais.readTag();
            if (tag == 1) {
                len = ais.readLength();
                if (len > ais.available()) {
                    throw new ParseException("Not enough data.");
                }
                tag = ais.readTag();
                if (tag != 2) {
                    throw new ParseException("Expected Integer tag, found: " + tag);
                }
                long t = ais.readInteger();
                this.userType = DialogServiceUserType.getFromInt((long)t);
                return;
            }
            if (tag == 2) {
                len = ais.readLength();
                if (len > ais.available()) {
                    throw new ParseException("Not enough data.");
                }
                tag = ais.readTag();
                if (tag != 2) {
                    throw new ParseException("Expected Integer tag, found: " + tag);
                }
                long t = ais.readInteger();
                this.providerType = DialogServiceProviderType.getFromInt((long)t);
                return;
            }
            throw new ParseException("Expected on of Diagnostic tags, found: " + tag);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.userType == null && this.providerType == null) {
            throw new ParseException("Value not set");
        }
        try {
            AsnOutputStream localAos = new AsnOutputStream();
            byte[] data = null;
            if (this.userType != null) {
                localAos.writeInteger(this.userType.getType());
                data = localAos.toByteArray();
                localAos.reset();
                localAos.writeTag(2, false, 1);
                localAos.writeLength(data.length);
                localAos.write(data);
                data = localAos.toByteArray();
                localAos.reset();
            } else {
                localAos.writeInteger(this.providerType.getType());
                data = localAos.toByteArray();
                localAos.reset();
                localAos.writeTag(2, false, 2);
                localAos.writeLength(data.length);
                localAos.write(data);
                data = localAos.toByteArray();
                localAos.reset();
            }
            aos.writeTag(2, false, 3);
            aos.writeLength(data.length);
            aos.write(data);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

