/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCodeType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnError;

public class ReturnErrorImpl
implements ReturnError {
    private Long invokeId;
    private ErrorCode errorCode;
    private Parameter[] parameters;

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Long getInvokeId() {
        return this.invokeId;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public void setErrorCode(ErrorCode ec) {
        this.errorCode = ec;
    }

    public void setInvokeId(Long i) {
        this.invokeId = i;
    }

    public void setParameters(Parameter[] p) {
        this.parameters = p;
    }

    public ComponentType getType() {
        return ComponentType.ReturnError;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int len = ais.readLength();
            if (ais.available() < len) {
                throw new ParseException("Not enough data!");
            }
            byte[] data = new byte[len];
            if (data.length != ais.read(data)) {
                throw new ParseException("Not enought data read.");
            }
            AsnInputStream localAis = new AsnInputStream((InputStream)new ByteArrayInputStream(data));
            int tag = localAis.readTag();
            if (tag != 2) {
                throw new ParseException("Expected InvokeID tag, found: " + tag);
            }
            this.invokeId = localAis.readInteger();
            tag = localAis.readTag();
            if (tag != 6 && tag != 2) {
                throw new ParseException("Expected Local|Globa error code, found: " + tag);
            }
            this.errorCode = TcapFactory.createErrorCode(tag == 6 ? ErrorCodeType.Global : ErrorCodeType.Local);
            this.errorCode.decode(localAis);
            if (localAis.available() == 0) {
                return;
            }
            tag = localAis.readTag();
            if (tag == 16) {
                int length = localAis.readLength();
                ArrayList<Parameter> paramsList = new ArrayList<Parameter>();
                while (localAis.available() > 0) {
                    tag = localAis.readTag();
                    Parameter p = TcapFactory.createParameter(tag, localAis);
                    paramsList.add(p);
                }
                this.parameters = new Parameter[paramsList.size()];
                this.parameters = paramsList.toArray(this.parameters);
                paramsList.clear();
            } else {
                this.parameters = new Parameter[]{TcapFactory.createParameter(tag, localAis)};
            }
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.invokeId == null) {
            throw new ParseException("Invoke ID not set!");
        }
        if (this.errorCode == null) {
            throw new ParseException("Operation Code not set!");
        }
        try {
            AsnOutputStream localAos = new AsnOutputStream();
            localAos.writeInteger(0, 2, this.invokeId.longValue());
            this.errorCode.encode(localAos);
            if (this.parameters != null) {
                if (this.parameters.length > 1) {
                    AsnOutputStream aosTemp = new AsnOutputStream();
                    for (Parameter p : this.parameters) {
                        p.encode(aosTemp);
                    }
                    byte[] paramData = aosTemp.toByteArray();
                    localAos.write(48);
                    localAos.write(paramData.length);
                    localAos.write(paramData);
                } else {
                    this.parameters[0].encode(localAos);
                }
            }
            byte[] data = localAos.toByteArray();
            aos.writeTag(2, false, 3);
            aos.writeLength(data.length);
            aos.write(data);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

