/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResult;

public class ReturnResultImpl
implements ReturnResult {
    private Long invokeId;
    private OperationCode operationCode;
    private Parameter parameter;

    public Long getInvokeId() {
        return this.invokeId;
    }

    public OperationCode getOperationCode() {
        return this.operationCode;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setInvokeId(Long i) {
        if (i == null || i < -128L || i > 127L) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.invokeId = i;
    }

    public void setOperationCode(OperationCode oc) {
        this.operationCode = oc;
    }

    public void setParameter(Parameter p) {
        this.parameter = p;
    }

    public ComponentType getType() {
        return ComponentType.ReturnResult;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream sequenceStream;
            int len = ais.readLength();
            if (len == 128) {
                throw new ParseException("Unspiecified length is not supported.");
            }
            byte[] data = new byte[len];
            if (len != ais.read(data)) {
                throw new ParseException("Not enough data read.");
            }
            AsnInputStream localAis = new AsnInputStream((InputStream)new ByteArrayInputStream(data));
            int tag = localAis.readTag();
            if (tag != 2) {
                throw new ParseException("Expected InvokeID tag, found: " + tag);
            }
            this.invokeId = localAis.readInteger();
            if (localAis.available() <= 0) {
                return;
            }
            tag = localAis.readTag();
            if (tag == 16) {
                len = localAis.readLength();
                if (len == 128) {
                    throw new ParseException("Unspiecified length is not supported.");
                }
                data = new byte[len];
                int tlen = localAis.read(data);
                if (len != tlen) {
                    throw new ParseException("Not enough data read. Expected: " + len + ", actaul: " + tlen);
                }
                sequenceStream = new AsnInputStream((InputStream)new ByteArrayInputStream(data));
                tag = sequenceStream.readTag();
                if (tag != 6 && tag != 2) {
                    throw new ParseException("Expected Global|Local operation code.");
                }
                this.operationCode = TcapFactory.createOperationCode(tag, sequenceStream);
                if (sequenceStream.available() <= 0) {
                    throw new ParseException("Not enought data to decode Parameter part of result!");
                }
            } else {
                throw new ParseException("Expected SEQUENCE tag for OperationCode and Parameter part, found: " + tag);
            }
            tag = sequenceStream.readTag();
            this.parameter = TcapFactory.createParameter(tag, sequenceStream);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.invokeId == null) {
            throw new ParseException("No Invoke ID set.");
        }
        try {
            AsnOutputStream localAos = new AsnOutputStream();
            byte[] data = null;
            if (this.operationCode != null && this.parameter != null) {
                this.operationCode.encode(localAos);
                this.parameter.encode(localAos);
                data = localAos.toByteArray();
                localAos.reset();
            }
            localAos.writeInteger(0, 2, this.invokeId.longValue());
            if (data != null) {
                localAos.writeTag(0, false, 16);
                localAos.writeLength(data.length);
                localAos.write(data);
            }
            data = localAos.toByteArray();
            aos.writeTag(2, false, 7);
            aos.writeLength(data.length);
            aos.write(data);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

