/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.DialogPortion;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.Utils;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCAbortMessage;

public class TCAbortMessageImpl
implements TCAbortMessage {
    private static final String _OCTET_STRING_ENCODE = "US-ASCII";
    private Long destTxId;
    private PAbortCauseType type;
    private DialogPortion dp;

    public Long getDestinationTransactionId() {
        return this.destTxId;
    }

    public DialogPortion getDialogPortion() {
        return this.dp;
    }

    public PAbortCauseType getPAbortCause() {
        return this.type;
    }

    public void setDestinationTransactionId(Long t) {
        this.destTxId = t;
    }

    public void setDialogPortion(DialogPortion dp) {
        this.dp = dp;
    }

    public void setPAbortCause(PAbortCauseType t) {
        this.type = t;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int len = ais.readLength();
            if (len > ais.available()) {
                throw new ParseException("Not enough data: " + ais.available());
            }
            if (len == 128) {
                throw new ParseException("Undefined len not supported");
            }
            byte[] data = new byte[len];
            if (len != ais.read(data)) {
                throw new ParseException("Not enough data read.");
            }
            AsnInputStream localAis = new AsnInputStream((InputStream)new ByteArrayInputStream(data));
            int tag = localAis.readTag();
            if (tag != 9) {
                throw new ParseException("Expected Destination Tx ID tag, found: " + tag);
            }
            this.destTxId = Utils.readTransactionId(localAis);
            if (localAis.available() <= 0) {
                return;
            }
            tag = localAis.readTag();
            if (tag == 10) {
                this.type = PAbortCauseType.getFromInt((long)localAis.readInteger());
                if (localAis.available() <= 0) {
                    return;
                }
                tag = localAis.readTag();
            }
            if (tag == 11) {
                this.dp = TcapFactory.createDialogPortion(localAis);
            }
            if (localAis.available() > 0) {
                throw new ParseException("To much data in stream.");
            }
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.destTxId == null) {
            throw new ParseException("No destination TxID");
        }
        try {
            AsnOutputStream localAos = new AsnOutputStream();
            Utils.writeTransactionId(localAos, this.destTxId, 1, 9);
            if (this.type != null) {
                localAos.writeTag(1, true, 10);
                localAos.writeInteger(1, 10, this.type.getType());
            }
            if (this.dp != null) {
                this.dp.encode(localAos);
            }
            byte[] data = localAos.toByteArray();
            aos.writeTag(1, false, 7);
            aos.writeLength(data.length);
            aos.write(data);
        }
        catch (UnsupportedEncodingException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

