/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.DialogPortion;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.Utils;
import org.mobicents.protocols.ss7.tcap.asn.comp.Component;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCBeginMessage;

public class TCBeginMessageImpl
implements TCBeginMessage {
    private static final String _OCTET_STRING_ENCODE = "US-ASCII";
    private Long originatingTransactionId;
    private DialogPortion dp;
    private Component[] component;

    public Component[] getComponent() {
        return this.component;
    }

    public DialogPortion getDialogPortion() {
        return this.dp;
    }

    public Long getOriginatingTransactionId() {
        return this.originatingTransactionId;
    }

    public void setComponent(Component[] c) {
        this.component = c;
    }

    public void setDialogPortion(DialogPortion dp) {
        this.dp = dp;
    }

    public void setOriginatingTransactionId(Long t) {
        this.originatingTransactionId = t;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            Component c;
            int len = ais.readLength();
            if (len > ais.available()) {
                throw new ParseException("Not enough data: " + ais.available());
            }
            if (len == 128) {
                throw new ParseException("Undefined len not supported");
            }
            byte[] data = new byte[len];
            if (len != ais.read(data)) {
                throw new ParseException("Not enough data read!");
            }
            AsnInputStream localAis = new AsnInputStream((InputStream)new ByteArrayInputStream(data));
            int tag = localAis.readTag();
            if (tag != 8) {
                throw new ParseException("Expected OriginatingTransactionId, found: " + tag);
            }
            this.originatingTransactionId = Utils.readTransactionId(localAis);
            if (localAis.available() <= 0) {
                return;
            }
            tag = localAis.readTag();
            if (tag == 11) {
                this.dp = TcapFactory.createDialogPortion(localAis);
                if (localAis.available() <= 0) {
                    return;
                }
                tag = localAis.readTag();
            }
            len = localAis.readLength();
            ArrayList<Component> cps = new ArrayList<Component>();
            while (localAis.available() > 0 && (c = TcapFactory.createComponent(localAis)) != null) {
                cps.add(c);
            }
            this.component = new Component[cps.size()];
            this.component = cps.toArray(this.component);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParseException {
        if (this.originatingTransactionId == null) {
            throw new ParseException("Transaction ID.");
        }
        try {
            AsnOutputStream localAos = new AsnOutputStream();
            byte[] data = null;
            if (this.component != null) {
                for (Component c : this.component) {
                    c.encode(localAos);
                }
                data = localAos.toByteArray();
                localAos.reset();
                localAos.writeTag(1, false, 12);
                localAos.writeLength(data.length);
                localAos.write(data);
                data = localAos.toByteArray();
                localAos.reset();
            }
            Utils.writeTransactionId(localAos, this.originatingTransactionId, 1, 8);
            if (this.dp != null) {
                this.dp.encode(localAos);
                if (data != null) {
                    localAos.write(data);
                }
                data = localAos.toByteArray();
            } else {
                if (data != null) {
                    localAos.write(data);
                }
                data = localAos.toByteArray();
            }
            aos.writeTag(1, false, 2);
            aos.writeLength(data.length);
            aos.write(data);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

