/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.tcap.asn.AbortSource;
import org.mobicents.protocols.ss7.tcap.asn.AbortSourceImpl;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextNameImpl;
import org.mobicents.protocols.ss7.tcap.asn.DialogAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogAbortAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogAbortAPDUImpl;
import org.mobicents.protocols.ss7.tcap.asn.DialogPortion;
import org.mobicents.protocols.ss7.tcap.asn.DialogPortionImpl;
import org.mobicents.protocols.ss7.tcap.asn.DialogRequestAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogRequestAPDUImpl;
import org.mobicents.protocols.ss7.tcap.asn.DialogResponseAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogResponseAPDUImpl;
import org.mobicents.protocols.ss7.tcap.asn.DialogUniAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogUniAPDUImpl;
import org.mobicents.protocols.ss7.tcap.asn.ErrorCodeImpl;
import org.mobicents.protocols.ss7.tcap.asn.InvokeImpl;
import org.mobicents.protocols.ss7.tcap.asn.OperationCodeImpl;
import org.mobicents.protocols.ss7.tcap.asn.ParameterImpl;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.ProblemImpl;
import org.mobicents.protocols.ss7.tcap.asn.ProtocolVersion;
import org.mobicents.protocols.ss7.tcap.asn.ProtocolVersionImpl;
import org.mobicents.protocols.ss7.tcap.asn.RejectImpl;
import org.mobicents.protocols.ss7.tcap.asn.Result;
import org.mobicents.protocols.ss7.tcap.asn.ResultImpl;
import org.mobicents.protocols.ss7.tcap.asn.ResultSourceDiagnostic;
import org.mobicents.protocols.ss7.tcap.asn.ResultSourceDiagnosticImpl;
import org.mobicents.protocols.ss7.tcap.asn.ReturnErrorImpl;
import org.mobicents.protocols.ss7.tcap.asn.ReturnResultImpl;
import org.mobicents.protocols.ss7.tcap.asn.ReturnResultLastImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCAbortMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCBeginMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCContinueMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCEndMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCUniMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.UserInformation;
import org.mobicents.protocols.ss7.tcap.asn.UserInformationImpl;
import org.mobicents.protocols.ss7.tcap.asn.comp.Component;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCodeType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCodeType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.protocols.ss7.tcap.asn.comp.ProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Reject;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnError;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResult;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultLast;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCAbortMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCBeginMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCContinueMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCEndMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCUniMessage;

public final class TcapFactory {
    public static DialogPortion createDialogPortion(AsnInputStream ais) throws ParseException {
        DialogPortionImpl dpi = new DialogPortionImpl();
        dpi.decode(ais);
        return dpi;
    }

    public static DialogPortion createDialogPortion() {
        return new DialogPortionImpl();
    }

    public static DialogAPDU createDialogAPDU(AsnInputStream ais, int tag, boolean unidirectional) throws ParseException {
        if (unidirectional) {
            if (tag != 0) {
                throw new ParseException("Wrong tag for APDU, found: " + tag);
            }
            DialogUniAPDUImpl d = new DialogUniAPDUImpl();
            d.decode(ais);
            return d;
        }
        if (tag == 0) {
            DialogRequestAPDUImpl d = new DialogRequestAPDUImpl();
            d.decode(ais);
            return d;
        }
        if (tag == 1) {
            DialogResponseAPDUImpl d = new DialogResponseAPDUImpl();
            d.decode(ais);
            return d;
        }
        if (tag == 4) {
            DialogAbortAPDUImpl da = new DialogAbortAPDUImpl();
            da.decode(ais);
            return da;
        }
        throw new ParseException("Wrong tag for APDU, found: " + tag);
    }

    public static DialogRequestAPDU createDialogAPDURequest() {
        return new DialogRequestAPDUImpl();
    }

    public static DialogResponseAPDU createDialogAPDUResponse() {
        return new DialogResponseAPDUImpl();
    }

    public static DialogUniAPDU createDialogAPDUUni() {
        return new DialogUniAPDUImpl();
    }

    public static DialogAbortAPDU createDialogAPDUAbort() {
        return new DialogAbortAPDUImpl();
    }

    public static ProtocolVersion createProtocolVersion() {
        return new ProtocolVersionImpl();
    }

    public static ProtocolVersion createProtocolVersion(AsnInputStream ais) throws ParseException {
        ProtocolVersionImpl pv = new ProtocolVersionImpl();
        pv.decode(ais);
        return pv;
    }

    public static ApplicationContextName createApplicationContextName(long[] oid) {
        ApplicationContextNameImpl acn = new ApplicationContextNameImpl();
        acn.setOid(oid);
        return acn;
    }

    public static ApplicationContextName createApplicationContextName(AsnInputStream ais) throws ParseException {
        ApplicationContextNameImpl acn = new ApplicationContextNameImpl();
        acn.decode(ais);
        return acn;
    }

    public static UserInformation createUserInformation() {
        return new UserInformationImpl();
    }

    public static UserInformation createUserInformation(AsnInputStream localAis) throws ParseException {
        UserInformationImpl ui = new UserInformationImpl();
        ui.decode(localAis);
        return ui;
    }

    public static Result createResult() {
        return new ResultImpl();
    }

    public static Result createResult(AsnInputStream localAis) throws ParseException {
        ResultImpl ui = new ResultImpl();
        ui.decode(localAis);
        return ui;
    }

    public static ResultSourceDiagnostic createResultSourceDiagnostic() {
        return new ResultSourceDiagnosticImpl();
    }

    public static ResultSourceDiagnostic createResultSourceDiagnostic(AsnInputStream localAis) throws ParseException {
        ResultSourceDiagnosticImpl ui = new ResultSourceDiagnosticImpl();
        ui.decode(localAis);
        return ui;
    }

    public static AbortSource createAbortSource() {
        AbortSourceImpl as = new AbortSourceImpl();
        return as;
    }

    public static AbortSource createAbortSource(AsnInputStream localAis) throws ParseException {
        AbortSourceImpl as = new AbortSourceImpl();
        as.decode(localAis);
        return as;
    }

    public static TCUniMessage createTCUniMessage(AsnInputStream localAis) throws ParseException {
        TCUniMessageImpl tc = new TCUniMessageImpl();
        tc.decode(localAis);
        return tc;
    }

    public static TCUniMessage createTCUniMessage() {
        TCUniMessageImpl tc = new TCUniMessageImpl();
        return tc;
    }

    public static TCContinueMessage createTCContinueMessage(AsnInputStream localAis) throws ParseException {
        TCContinueMessageImpl tc = new TCContinueMessageImpl();
        tc.decode(localAis);
        return tc;
    }

    public static TCContinueMessage createTCContinueMessage() {
        TCContinueMessageImpl tc = new TCContinueMessageImpl();
        return tc;
    }

    public static TCEndMessage createTCEndMessage(AsnInputStream localAis) throws ParseException {
        TCEndMessageImpl tc = new TCEndMessageImpl();
        tc.decode(localAis);
        return tc;
    }

    public static TCEndMessage createTCEndMessage() {
        TCEndMessageImpl tc = new TCEndMessageImpl();
        return tc;
    }

    public static TCAbortMessage createTCAbortMessage(AsnInputStream localAis) throws ParseException {
        TCAbortMessageImpl tc = new TCAbortMessageImpl();
        tc.decode(localAis);
        return tc;
    }

    public static TCAbortMessage createTCAbortMessage() {
        TCAbortMessageImpl tc = new TCAbortMessageImpl();
        return tc;
    }

    public static TCBeginMessage createTCBeginMessage(AsnInputStream localAis) throws ParseException {
        TCBeginMessageImpl tc = new TCBeginMessageImpl();
        tc.decode(localAis);
        return tc;
    }

    public static TCBeginMessage createTCBeginMessage() {
        TCBeginMessageImpl tc = new TCBeginMessageImpl();
        return tc;
    }

    public static OperationCode createOperationCode(boolean global, Long code) {
        OperationCodeImpl oc = new OperationCodeImpl();
        oc.setOperationType(global ? OperationCodeType.Global : OperationCodeType.Local);
        oc.setCode(code);
        return oc;
    }

    public static OperationCode createOperationCode(int tag, AsnInputStream localAis) throws ParseException {
        OperationCodeImpl oc = new OperationCodeImpl();
        oc.setOperationType(6 == tag ? OperationCodeType.Global : OperationCodeType.Local);
        oc.decode(localAis);
        return oc;
    }

    public static Parameter createParameter() {
        ParameterImpl p = new ParameterImpl();
        return p;
    }

    public static Parameter createParameter(int tag, AsnInputStream localAis) throws ParseException {
        ParameterImpl p = new ParameterImpl();
        p.setTag(tag);
        p.decode(localAis);
        return p;
    }

    public static Component createComponent(AsnInputStream localAis) throws ParseException {
        try {
            int tag = localAis.readTag();
            Invoke c = null;
            if (tag == 1) {
                c = TcapFactory.createComponentInvoke();
                c.decode(localAis);
            } else if (tag == 7) {
                c = TcapFactory.createComponentReturnResult();
                c.decode(localAis);
            } else if (tag == 2) {
                c = TcapFactory.createComponentReturnResultLast();
                c.decode(localAis);
            } else if (tag == 4) {
                c = TcapFactory.createComponentReject();
                c.decode(localAis);
            } else if (tag == 3) {
                c = TcapFactory.createComponentReturnError();
                c.decode(localAis);
            } else if (tag == 0 && localAis.readLength() == 0) {
                return null;
            }
            if (c == null) {
                throw new ParseException("Unknown component, tag: " + tag);
            }
            return c;
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public static Reject createComponentReject() {
        return new RejectImpl();
    }

    public static ReturnResultLast createComponentReturnResultLast() {
        return new ReturnResultLastImpl();
    }

    public static ReturnResult createComponentReturnResult() {
        return new ReturnResultImpl();
    }

    public static Invoke createComponentInvoke() {
        return new InvokeImpl();
    }

    public static ReturnError createComponentReturnError() {
        return new ReturnErrorImpl();
    }

    public static Problem createProblem(ProblemType pt, AsnInputStream ais) throws ParseException {
        Problem p = TcapFactory.createProblem(pt);
        p.decode(ais);
        return p;
    }

    public static Problem createProblem(ProblemType pt) {
        ProblemImpl p = new ProblemImpl();
        p.setType(pt);
        return p;
    }

    public static ErrorCode createErrorCode(ErrorCodeType pt, AsnInputStream ais) throws ParseException {
        ErrorCode p = TcapFactory.createErrorCode(pt);
        p.decode(ais);
        return p;
    }

    public static ErrorCode createErrorCode(ErrorCodeType pt) {
        ErrorCodeImpl p = new ErrorCodeImpl();
        p.setErrorType(pt);
        return p;
    }
}

