/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;

final class Utils {
    Utils() {
    }

    public static Long readTransactionId(AsnInputStream ais) throws AsnException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ais.readOctetString((OutputStream)bos);
        byte[] data = bos.toByteArray();
        byte[] longRep = new byte[8];
        System.arraycopy(data, 0, longRep, longRep.length - data.length, data.length);
        ByteBuffer bb = ByteBuffer.wrap(longRep);
        return bb.getLong();
    }

    public static void writeTransactionId(AsnOutputStream aos, Long txId, int tagClass, int tag) throws AsnException, IOException {
        byte[] data = new byte[4];
        long ll = txId;
        data[3] = (byte)ll;
        data[2] = (byte)(ll >> 8);
        data[1] = (byte)(ll >> 16);
        data[0] = (byte)(ll >> 24);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        for (int index = 0; index < 3 && data[index] == 0; ++index) {
            bais.read();
        }
        aos.writeStringOctet(tagClass, tag, (InputStream)bais);
    }
}

