/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.mobicents.protocols.xcap.diff;

import org.mobicents.protocols.xml.patch.XmlPatchOperationsBuilder;

/**
 * 
 * Factory to retrieve final and intermediate XCAP DIFF patch components, which
 * defines generics for whole API implementation.
 * 
 * @author baranowb
 * @author martins
 * 
 * @param <P>
 *            the patch type, defines what is the concrete type of finalized
 *            XCAP DIFF patch
 * @param <C>
 *            the component type, defines what is the concrete type of each
 *            patch component, to be aggregated in a XCAP DIFF patch
 * @param <D>
 *            the document type, defines what is the concrete type of XML
 *            documents used
 * @param <E>
 *            the element type, defines what is the concrete type of XML
 *            elements used
 * 
 * @param <N>
 *            the xml patch ops node type, defines what is the concrete type of
 *            XML patch ops node params used by
 *            {@link XmlPatchOperationsBuilder}
 */
public interface XcapDiffFactory<P, C, D, E, N> {

	public static final String XCAP_DIFF_NAMESPACE_URI = "urn:ietf:params:xml:ns:xcap-diff";

	/**
	 * Retrieves the patch applier.
	 * 
	 * @return
	 */
	public XcapDiffPatchApplier<P, D> getPatchApplier();

	/**
	 * Retrieves the patch builder.
	 * 
	 * @return
	 */
	public XcapDiffPatchBuilder<P, C, D, E, N> getPatchBuilder();
}
