/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.http;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mobicents.slee.resource.http.HttpServletResourceEntryPoint;
import org.mobicents.slee.resource.http.HttpServletResourceEntryPointManager;

public class HttpServletRaServlet
extends HttpServlet {
    private static final int HTTP_ERROR_CODE_SERVICE_UNAVAILABLE = 503;
    private static final Logger LOGGER = Logger.getLogger(HttpServletRaServlet.class.getName());
    private static final long serialVersionUID = 7542822118420702996L;
    private String servletName = null;

    public void service(HttpServletRequest request, HttpServletResponse response) {
        HttpServletResourceEntryPoint resourceEntryPoint;
        if (this.servletName == null) {
            this.servletName = this.getServletConfig().getServletName();
        }
        if ((resourceEntryPoint = HttpServletResourceEntryPointManager.getResourceEntryPoint(this.servletName)) == null) {
            HttpServletRaServlet.replyNotAvailableError(this.servletName, response);
        } else {
            resourceEntryPoint.onRequest(request, response);
        }
    }

    public static void replyNotAvailableError(String name, HttpServletResponse response) {
        try {
            response.sendError(503, "JSLEE Http Servlet RA Entity with name " + name + " is not available");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to send 503 response to inform client that RA is not available", e);
        }
    }
}

