/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.http;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.http.HttpServletResourceEntryPoint;
import org.mobicents.slee.resource.http.HttpServletResourceEntryPointManager;
import org.mobicents.slee.resource.http.HttpSessionWrapper;

public class HttpServletRaSessionListener
implements HttpSessionListener {
    private static final Logger log = Logger.getLogger((String)HttpServletRaSessionListener.class.getName());
    private static AtomicBoolean masterListener = new AtomicBoolean(true);
    private boolean active;

    public HttpServletRaSessionListener() {
        if (masterListener.compareAndSet(true, false)) {
            this.active = true;
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        if (this.active && log.isDebugEnabled()) {
            log.debug((Object)("sessionCreated sessionId = " + httpSessionEvent.getSession().getId()));
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        if (this.active) {
            HttpServletResourceEntryPoint resourceEntryPoint;
            HttpSession session;
            HttpSessionWrapper wrapper;
            String name;
            if (log.isDebugEnabled()) {
                log.debug((Object)("sessionDestroyed called for sessionId = " + httpSessionEvent.getSession().getId()));
            }
            if ((name = (wrapper = new HttpSessionWrapper(session = httpSessionEvent.getSession())).getResourceEntryPoint()) != null && (resourceEntryPoint = HttpServletResourceEntryPointManager.getResourceEntryPoint(name)) != null) {
                resourceEntryPoint.onSessionTerminated(wrapper);
            }
        }
    }
}

