/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.http;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpServletRaServlet
extends HttpServlet {
    public static int HTTP_ERROR_CODE_SERVICE_UNAVAILABLE = 503;
    private static Logger logger = Logger.getLogger(HttpServletRaServlet.class.getName());
    private static final long serialVersionUID = 7542822118420702996L;
    private static final String RA_ENTRY_POINT_PARAM = "ra-entry-point-jndi-name";
    private Servlet raEntryPoint = null;

    public void service(HttpServletRequest request, HttpServletResponse response) {
        Servlet ep = this.getRaEntryPont();
        if (ep == null) {
            try {
                response.sendError(HTTP_ERROR_CODE_SERVICE_UNAVAILABLE, "JSLEE Http Servlet RA");
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to send 503 response to inform client that RA is not available", e);
            }
        } else {
            try {
                this.raEntryPoint.service((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException e) {
                logger.log(Level.WARNING, "Http Servlet RA Failed to handle http request.", e);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Http Servlet RA Failed to handle http request.", e);
            }
        }
    }

    private synchronized Servlet getRaEntryPont() {
        if (this.raEntryPoint != null) {
            return this.raEntryPoint;
        }
        String raEntryPointJndiName = this.getInitParameter(RA_ENTRY_POINT_PARAM);
        try {
            InitialContext ictx = new InitialContext();
            Object obj = ictx.lookup(raEntryPointJndiName);
            this.raEntryPoint = (Servlet)obj;
            return this.raEntryPoint;
        }
        catch (NamingException e) {
            logger.log(Level.WARNING, "Failed to lookup Http Servlet RA Entry Point. JNDI location: " + raEntryPointJndiName);
            return null;
        }
    }
}

