/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.jcc.ra;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.csapi.cc.jcc.JccCall;
import javax.csapi.cc.jcc.JccCallEvent;
import javax.csapi.cc.jcc.JccCallListener;
import javax.csapi.cc.jcc.JccConnection;
import javax.csapi.cc.jcc.JccConnectionEvent;
import javax.csapi.cc.jcc.JccConnectionListener;
import javax.csapi.cc.jcc.JccEvent;
import javax.csapi.cc.jcc.JccPeer;
import javax.csapi.cc.jcc.JccPeerFactory;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.jcc.local.JccCallEventLocal;
import org.mobicents.slee.resource.jcc.local.JccCallLocal;
import org.mobicents.slee.resource.jcc.local.JccConnectionEventLocal;
import org.mobicents.slee.resource.jcc.local.JccConnectionLocal;
import org.mobicents.slee.resource.jcc.local.JccProviderLocal;
import org.mobicents.slee.resource.jcc.ra.JccActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.jcc.ra.JccCallActivityHandle;
import org.mobicents.slee.resource.jcc.ra.JccConnectionActivityHandle;
import org.mobicents.slee.resource.jcc.ratype.JccActivityContextInterfaceFactory;

public class JccResourceAdaptor
implements ResourceAdaptor,
Serializable,
JccConnectionListener {
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private transient BootstrapContext bootstrapContext = null;
    private JccProviderLocal provider;
    private Address address = new Address(AddressPlan.IP, "127.0.0.1");
    private Logger logger = Logger.getLogger(JccResourceAdaptor.class);
    private ConcurrentReaderHashMap activities = new ConcurrentReaderHashMap();
    private ConcurrentReaderHashMap handlers = new ConcurrentReaderHashMap();
    private String peerName = null;
    private String configName;
    private JccActivityContextInterfaceFactory activityContextInterfaceFactory;
    private boolean stopped = false;
    private Thread monitor;

    public String getJccPeer() {
        return this.peerName;
    }

    public void setJccPeer(String jccPeer) {
        this.peerName = jccPeer;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void activityEnded(ActivityHandle handle) {
        String ID = ((JccConnectionActivityHandle)handle).getID();
        Object activity = this.activities.remove((Object)ID);
        this.logger.debug((Object)("Removed activity: " + activity + " under key: " + ID));
        JccConnectionActivityHandle h = (JccConnectionActivityHandle)this.handlers.remove((Object)activity.toString());
        this.logger.debug((Object)("Removed handle: " + h.getID() + " under key: " + activity.toString()));
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
    }

    public void entityActivated() throws ResourceException {
        this.logger.info((Object)("Starting JCC Provider, Jcc Peer Name=" + this.peerName + ", config URL: " + this.configName));
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/" + this.configName));
            this.logger.info((Object)("Loaded properties: " + properties));
            JccPeer peer = JccPeerFactory.getJccPeer((String)this.peerName);
            String conf = "<jcc-inap>";
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                conf = conf + ";" + key + "=" + properties.getProperty(key);
            }
            this.provider = new JccProviderLocal(peer.getProvider(conf));
            this.provider.addConnectionListener(this, null);
            this.provider.addCallListener((JccCallListener)this);
            this.logger.info((Object)"JCC Provider started successfuly");
            this.initializeNamingContext();
            this.logger.info((Object)"Running monitoring thread");
            this.monitor = new Thread(new ActivityMonitor());
            this.monitor.start();
        }
        catch (UnsatisfiedLinkError ex) {
            this.logger.warn((Object)"JCC Resource adaptor is not attached to baord driver", (Throwable)ex);
        }
        catch (Exception e) {
            this.logger.error((Object)"Can not start Jcc Provider: ", (Throwable)e);
            throw new ResourceException(e.getMessage());
        }
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
        this.bootstrapContext = bootstrapContext;
    }

    public void entityDeactivated() {
        this.clearNamingContext();
        this.stopped = true;
        this.monitor.interrupt();
    }

    public void entityDeactivating() {
        this.provider.shutdown();
    }

    public void entityRemoved() {
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, Object obj, int param, Address address, int param4, FailureReason failureReason) {
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, Object obj, int param, Address address, int param4) {
    }

    public Object getActivity(ActivityHandle handle) {
        String ID = ((JccConnectionActivityHandle)handle).getID();
        return this.activities.get((Object)ID);
    }

    public ActivityHandle getActivityHandle(Object obj) {
        return (ActivityHandle)this.handlers.get((Object)obj.toString());
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String str) {
        return this.provider;
    }

    public void queryLiveness(ActivityHandle activityHandle) {
    }

    public void serviceActivated(String str) {
    }

    public void serviceDeactivated(String str) {
    }

    public void serviceInstalled(String serviceKey, int[] values, String[] str2) {
    }

    public void serviceUninstalled(String str) {
    }

    public void callActive(JccCallEvent event) {
        this.logger.debug((Object)"Receive JccCallEvent.CALL_ACTIVE event");
        JccCallEventLocal evt = this.wrapJccCallEvent(event);
        JccCall call = evt.getCall();
        ActivityHandle handle = this.getActivityHandle(call);
        this.fireEvent("javax.csapi.cc.jcc.JccCallEvent.CALL_ACTIVE", handle, (JccEvent)evt);
    }

    public void callCreated(JccCallEvent event) {
        this.logger.debug((Object)"Receive JccCallEvent.CALL_CREATED event");
        JccCallEventLocal evt = this.wrapJccCallEvent(event);
        JccCall call = evt.getCall();
        JccCallActivityHandle handle = new JccCallActivityHandle(call);
        this.activities.put((Object)call, (Object)handle);
        this.fireEvent("javax.csapi.cc.jcc.JccCallEvent.CALL_CREATED", handle, (JccEvent)evt);
    }

    public void callEventTransmissionEnded(JccCallEvent event) {
        this.logger.debug((Object)"Receive JccCallEvent.CALL_EVENT_TRANSMISSION_ENDED event");
        JccCallEventLocal evt = this.wrapJccCallEvent(event);
        JccCall call = evt.getCall();
        ActivityHandle handle = this.getActivityHandle(call);
        this.fireEvent("javax.csapi.cc.jcc.JccCallEvent.CALL_EVENT_TRANSMISSION_ENDED", handle, (JccEvent)evt);
        try {
            this.sleeEndpoint.activityEnding(handle);
        }
        catch (UnrecognizedActivityException uae) {
            this.logger.error((Object)"Caught an UnrecognizedActivityException: ");
            uae.printStackTrace();
        }
    }

    public void callInvalid(JccCallEvent event) {
        this.logger.debug((Object)"Receive JccCallEvent.CALL_INVALID event");
        JccCallEventLocal evt = this.wrapJccCallEvent(event);
        JccCall call = evt.getCall();
        ActivityHandle handle = this.getActivityHandle(call);
        this.fireEvent("javax.csapi.cc.jcc.JccCallEvent.CALL_INVALID", handle, (JccEvent)evt);
        try {
            this.sleeEndpoint.activityEnding(handle);
        }
        catch (UnrecognizedActivityException uae) {
            this.logger.error((Object)"Caught an UnrecognizedActivityException: ");
            uae.printStackTrace();
        }
    }

    public void callSuperviseEnd(JccCallEvent event) {
        this.logger.debug((Object)"Receive JccCallEvent.CALL_SUPERVISE_END event");
        JccCallEventLocal evt = this.wrapJccCallEvent(event);
        JccCall call = evt.getCall();
        ActivityHandle handle = this.getActivityHandle(call);
        this.fireEvent("javax.csapi.cc.jcc.JccCallEvent.CALL_CSUPERVISE_END", handle, (JccEvent)evt);
    }

    public void callSuperviseStart(JccCallEvent event) {
        this.logger.debug((Object)"Receive JccCallEvent.CALL_SUPERVISE_START event");
        JccCallEventLocal evt = this.wrapJccCallEvent(event);
        JccCall call = evt.getCall();
        ActivityHandle handle = this.getActivityHandle(call);
        this.fireEvent("javax.csapi.cc.jcc.JccCallEvent.CALL_CSUPERVISE_START", handle, (JccEvent)evt);
    }

    public void connectionAddressAnalyze(JccConnectionEvent event) {
        this.logger.debug((Object)"Receive JccConnection.CONNECTION_ADDRESS_ANALYZE event");
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_ADDRESS_ANALYZE", handle, (JccEvent)evt);
    }

    public void connectionAddressCollect(JccConnectionEvent event) {
        this.logger.debug((Object)"Receive JccConnection.CONNECTION_ADDRESS_COLLECT event");
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_ADDRESS_COLLECT", handle, (JccEvent)evt);
    }

    public void connectionAlerting(JccConnectionEvent event) {
        this.logger.debug((Object)"Receive JccConnection.CONNECTION_ALERTING event");
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_ALERTING", handle, (JccEvent)evt);
    }

    public void connectionAuthorizeCallAttempt(JccConnectionEvent event) {
        this.logger.debug((Object)"Receive JccConnection.CONNECTION_AUTHORIZE_CALL_ATTEMPT event");
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_AUTHORIZE_CALL_ATTEMPT", handle, (JccEvent)evt);
    }

    public void connectionCallDelivery(JccConnectionEvent event) {
        this.logger.debug((Object)"Receive JccConnection.CONNECTION_CALL_DELIVERY event");
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_CALL_DELIVERY", handle, (JccEvent)evt);
    }

    public void connectionConnected(JccConnectionEvent event) {
        this.logger.debug((Object)"Receive JccConnection.CONNECTION_CONNECTED event");
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_CONNECTED", handle, (JccEvent)evt);
    }

    public void connectionCreated(JccConnectionEvent event) {
        this.logger.debug((Object)"Receive JccConnection.CONNECTION_CREATED event");
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        JccConnectionActivityHandle handle = new JccConnectionActivityHandle(connection);
        this.handlers.put((Object)connection.toString(), (Object)handle);
        this.logger.debug((Object)("onConnectionCreate():put handle: " + handle + " under key: " + connection.toString()));
        this.activities.put((Object)handle.getID(), (Object)connection);
        this.logger.debug((Object)("onConnectionCreate():put connection " + connection + " under key: " + handle.getID()));
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_CREATED", handle, (JccEvent)evt);
    }

    public void connectionDisconnected(JccConnectionEvent event) {
        this.logger.debug((Object)"Receive JccConnection.CONNECTION_DISCONNECTED event");
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection.toString());
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_DISCONNECTED", handle, (JccEvent)evt);
        try {
            this.sleeEndpoint.activityEnding(handle);
        }
        catch (UnrecognizedActivityException uae) {
            this.logger.error((Object)"Caught an UnrecognizedActivityException: ");
            uae.printStackTrace();
        }
    }

    public void connectionFailed(JccConnectionEvent event) {
        this.logger.debug((Object)"Receive JccConnection.CONNECTION_FAILED event");
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        this.logger.debug((Object)("onfailed(): connectionID: " + connection.toString()));
        ActivityHandle handle = this.getActivityHandle(connection);
        this.logger.debug((Object)("onfailed(): handle=" + handle));
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_FAILED", handle, (JccEvent)evt);
    }

    public void connectionMidCall(JccConnectionEvent event) {
        this.logger.debug((Object)"Receive JccConnection.CONNECTION_MID_CALLevent");
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_MID_CALL", handle, (JccEvent)evt);
    }

    private JccConnectionEventLocal wrapJccConnectionEvent(JccConnectionEvent event) {
        JccCallLocal call = new JccCallLocal(event.getCall(), this.provider);
        JccConnectionLocal connection = new JccConnectionLocal(event.getConnection(), this.provider, call);
        return new JccConnectionEventLocal(connection, event.getID(), event.getCause(), event.getSource(), call);
    }

    private JccCallEventLocal wrapJccCallEvent(JccCallEvent event) {
        JccCallLocal call = new JccCallLocal(event.getCall(), this.provider);
        return new JccCallEventLocal(event.getID(), event.getCause(), event.getSource(), call);
    }

    private void fireEvent(String eventName, ActivityHandle activityHandle, JccEvent event) {
        int eventID = -1;
        try {
            eventID = this.eventLookup.getEventID(eventName, "javax.csapi.cc.jcc", "1.1");
        }
        catch (FacilityException fe) {
            this.logger.error((Object)"Caught a FacilityException: ");
            fe.printStackTrace();
            throw new RuntimeException("JccResourceAdaptor.firEvent(): FacilityException caught. ", fe);
        }
        catch (UnrecognizedEventException ue) {
            this.logger.error((Object)"Caught an UnrecognizedEventException: ");
            ue.printStackTrace();
            throw new RuntimeException("JccResourceAdaptor.firEvent(): UnrecognizedEventException caught.", ue);
        }
        if (eventID == -1) {
            this.logger.warn((Object)("Unknown event type: " + eventName));
            return;
        }
        try {
            this.sleeEndpoint.fireEvent(activityHandle, (Object)event, eventID, this.address);
            this.logger.debug((Object)("Fire event: " + eventName));
        }
        catch (IllegalStateException ise) {
            this.logger.error((Object)"Caught an IllegalStateException: ");
            ise.printStackTrace();
        }
        catch (ActivityIsEndingException aiee) {
            this.logger.error((Object)"Caught an ActivityIsEndingException: ");
            aiee.printStackTrace();
        }
        catch (UnrecognizedActivityException uaee) {
            this.logger.error((Object)"Caught an UnrecognizedActivityException: ");
            uaee.printStackTrace();
        }
    }

    private void initializeNamingContext() {
        this.logger.info((Object)"Initialize naming context");
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        String entityName = this.bootstrapContext.getEntityName();
        ResourceAdaptorEntity resourceAdaptorEntity = sleeContainer.getResourceAdaptorEnitity(entityName);
        ResourceAdaptorTypeIDImpl resourceAdaptorTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.activityContextInterfaceFactory = new JccActivityContextInterfaceFactoryImpl(sleeContainer, entityName);
        sleeContainer.getActivityContextInterfaceFactories().put(resourceAdaptorTypeId, this.activityContextInterfaceFactory);
        String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.activityContextInterfaceFactory).getJndiName();
        int i = jndiName.indexOf(58);
        int j = jndiName.lastIndexOf(47);
        String prefix = jndiName.substring(i + 1, j);
        String name = jndiName.substring(j + 1);
        SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.activityContextInterfaceFactory);
    }

    private void clearNamingContext() {
        String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.activityContextInterfaceFactory).getJndiName();
        int i = jndiName.indexOf(58);
        String name = jndiName.substring(i + 1);
        SleeContainer.unregisterWithJndi((String)name);
    }

    private class ActivityMonitor
    implements Runnable {
        private ActivityMonitor() {
        }

        public void run() {
            while (!JccResourceAdaptor.this.stopped) {
                try {
                    Thread.currentThread();
                    Thread.sleep(60000L);
                    JccResourceAdaptor.this.logger.info((Object)("activities=" + JccResourceAdaptor.this.activities.size() + ", handlers=" + JccResourceAdaptor.this.handlers.size()));
                }
                catch (InterruptedException e) {
                    JccResourceAdaptor.this.stopped = true;
                }
            }
        }
    }
}

