/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.media.ra;

import javax.slee.ActivityContextInterface;
import javax.slee.FactoryException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.resource.ActivityHandle;
import org.apache.log4j.Logger;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsResource;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.SleeActivityHandle;
import org.mobicents.slee.resource.media.ra.MediaActivityHandle;
import org.mobicents.slee.resource.media.ratype.MediaRaActivityContextInterfaceFactory;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextFactory;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;

public class MediaRaActivityContextInterfaceFactoryImpl
implements MediaRaActivityContextInterfaceFactory,
ResourceAdaptorActivityContextInterfaceFactory {
    private static Logger logger = Logger.getLogger(MediaRaActivityContextInterfaceFactoryImpl.class);
    private SleeContainer serviceContainer;
    private final String jndiName;
    private String raEntityName;
    private ActivityContextFactory activityContextFactory;

    public MediaRaActivityContextInterfaceFactoryImpl(SleeContainer serviceContainer, String entityName) {
        this.serviceContainer = serviceContainer;
        this.activityContextFactory = serviceContainer.getActivityContextFactory();
        this.raEntityName = entityName;
        this.jndiName = "java:slee/resources/" + entityName + "/mediaraacif";
        logger.debug((Object)("MediaRaActivityContextInterfaceFactoryImpl.jndiName = " + this.jndiName));
    }

    public String getJndiName() {
        return this.jndiName;
    }

    private ActivityContext getActivityContext(Object mediaActivity) {
        MediaActivityHandle handle = new MediaActivityHandle(mediaActivity.toString());
        SleeActivityHandle sleeActivityHandle = new SleeActivityHandle(this.raEntityName, (ActivityHandle)handle, this.serviceContainer);
        ActivityContext ac = this.activityContextFactory.getActivityContext((Object)sleeActivityHandle);
        return ac;
    }

    public ActivityContextInterface getActivityContextInterface(MsSession call) throws NullPointerException, UnrecognizedActivityException, FactoryException {
        ActivityContext ac = this.getActivityContext(call);
        return new ActivityContextInterfaceImpl(this.serviceContainer, ac.getActivityContextId());
    }

    public ActivityContextInterface getActivityContextInterface(MsConnection connection) throws NullPointerException, UnrecognizedActivityException, FactoryException {
        ActivityContext ac = this.getActivityContext(connection);
        return new ActivityContextInterfaceImpl(this.serviceContainer, ac.getActivityContextId());
    }

    public ActivityContextInterface getActivityContextInterface(MsResource resource) throws NullPointerException, UnrecognizedActivityException, FactoryException {
        ActivityContext ac = this.getActivityContext(resource);
        return new ActivityContextInterfaceImpl(this.serviceContainer, ac.getActivityContextId());
    }

    public ActivityContextInterface getActivityContextInterface(MsLink link) throws NullPointerException, UnrecognizedActivityException, FactoryException {
        ActivityContext ac = this.getActivityContext(link);
        return new ActivityContextInterfaceImpl(this.serviceContainer, ac.getActivityContextId());
    }
}

