/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.media.ra;

import java.util.HashMap;
import java.util.Properties;
import javax.naming.NamingException;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.common.events.EventID;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionEvent;
import org.mobicents.mscontrol.MsConnectionListener;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkEvent;
import org.mobicents.mscontrol.MsLinkListener;
import org.mobicents.mscontrol.MsNotifyEvent;
import org.mobicents.mscontrol.MsPeer;
import org.mobicents.mscontrol.MsPeerFactory;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsResource;
import org.mobicents.mscontrol.MsResourceListener;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.MsSessionEvent;
import org.mobicents.mscontrol.MsSessionListener;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.media.ra.MediaActivityHandle;
import org.mobicents.slee.resource.media.ra.MediaRaActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.media.ratype.MediaRaActivityContextInterfaceFactory;

public class MediaResourceAdaptor
implements ResourceAdaptor,
MsConnectionListener,
MsResourceListener,
MsLinkListener,
MsSessionListener {
    public Properties properties;
    private static final String LOCAL_HOST = "org.mobicents.LOCAL_HOST";
    private MsPeerFactory peerFactory;
    private MsProvider msProvider;
    private static transient Logger logger = Logger.getLogger(MediaResourceAdaptor.class);
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private HashMap activities = null;
    private HashMap handlers = new HashMap();
    private transient MediaRaActivityContextInterfaceFactory acif = null;

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
    }

    public void entityRemoved() {
    }

    public void entityActivated() throws ResourceException {
        try {
            try {
                MsPeer peer = MsPeerFactory.getPeer();
                this.msProvider = peer.getProvider();
                this.msProvider.addConnectionListener((MsConnectionListener)this);
                this.msProvider.addSessionListener((MsSessionListener)this);
                this.msProvider.addResourceListener((MsResourceListener)this);
                this.msProvider.addLinkListener((MsLinkListener)this);
            }
            catch (ClassNotFoundException e) {
                throw new ResourceException(e.getMessage());
            }
            this.initializeNamingContext();
            this.activities = new HashMap();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceException("MediaResourceAdaptor.entityActivated(): Failed to activate RAFrame Resource Adaptor!", (Throwable)e);
        }
    }

    public void entityDeactivating() {
    }

    public void entityDeactivated() {
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot unbind naming context", (Throwable)e);
        }
    }

    public void eventProcessingSuccessful(ActivityHandle handle, Object event, int eventID, Address address, int flags) {
    }

    public void eventProcessingFailed(ActivityHandle handle, Object event, int eventID, Address address, int flags, FailureReason reason) {
    }

    public void activityEnded(ActivityHandle activityHandle) {
        Object activity = this.activities.remove(activityHandle);
        this.handlers.remove(activity.toString());
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
    }

    public void queryLiveness(ActivityHandle activityHandle) {
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return this.activities.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        return (ActivityHandle)this.handlers.get(activity.toString());
    }

    public Object getSBBResourceAdaptorInterface(String className) {
        return this.msProvider;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void serviceInstalled(String serviceKey, int[] eventIDs, String[] resourceOptions) {
    }

    public void serviceUninstalled(String serviceKey) {
    }

    public void serviceActivated(String arg0) {
    }

    public void serviceDeactivated(String arg0) {
    }

    private void initializeNamingContext() throws NamingException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        String entityName = this.bootstrapContext.getEntityName();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(entityName);
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.acif = new MediaRaActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), entityName);
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                logger.debug((Object)("jndiName prefix =" + prefix + "; jndiName = " + name));
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug((Object)e);
        }
    }

    private void cleanNamingContext() throws NamingException {
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                String javaJNDIName = jndiName.substring(begind + 1);
                logger.debug((Object)("JNDI name to unregister: " + javaJNDIName));
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
                logger.debug((Object)"JNDI name unregistered.");
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug((Object)e);
        }
    }

    private synchronized void fireEvent(String eventName, ActivityHandle activityHandle, Object event) {
        int eventID = -1;
        try {
            eventID = this.eventLookup.getEventID(eventName, "org.mobicents.media", "1.0");
        }
        catch (FacilityException fe) {
            logger.error((Object)"Caught a FacilityException: ");
            fe.printStackTrace();
            throw new RuntimeException("MediaResourceAdaptor.firEvent(): FacilityException caught. ", fe);
        }
        catch (UnrecognizedEventException ue) {
            logger.error((Object)"Caught an UnrecognizedEventException: ");
            ue.printStackTrace();
            throw new RuntimeException("MediaResourceAdaptor.firEvent(): UnrecognizedEventException caught.", ue);
        }
        if (eventID == -1) {
            logger.warn((Object)("Unknown event type: " + eventName));
            return;
        }
        Address address = new Address(AddressPlan.IP, "localhost");
        try {
            this.sleeEndpoint.fireEvent(activityHandle, event, eventID, address);
            logger.info((Object)("Fire event: " + eventName));
        }
        catch (IllegalStateException ise) {
            logger.error((Object)"Caught an IllegalStateException: ");
            ise.printStackTrace();
        }
        catch (ActivityIsEndingException aiee) {
            logger.error((Object)"Caught an ActivityIsEndingException: ");
            aiee.printStackTrace();
        }
        catch (UnrecognizedActivityException uaee) {
            logger.error((Object)"Caught an UnrecognizedActivityException: ");
            uaee.printStackTrace();
        }
    }

    SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }

    public void onConnecting(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("org.mobicents.slee.media.CONNECTION_CONNECTING", handle, evt);
    }

    public void onConnected(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("org.mobicents.slee.media.CONNECTION_CONNECTED", handle, evt);
    }

    public void onFailed(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("org.mobicents.slee.media.CONNECTION_FAILED", handle, evt);
    }

    public void onDisconnected(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("org.mobicents.slee.media.CONNECTION_DISCONNECTED", handle, evt);
        try {
            this.sleeEndpoint.activityEnding(handle);
        }
        catch (Exception e) {
            logger.error((Object)("Could not end activity: " + connection));
        }
    }

    public void update(MsNotifyEvent event) {
        MsResource resource = event.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(resource.toString());
        this.activities.put(handle, handle);
        EventID eventid = event.getEventID();
        if (eventid.equals((Object)EventID.PLAY)) {
            this.fireEvent("org.mobicents.slee.media.announcement.PLAY", handle, event);
        } else if (eventid.equals((Object)EventID.COMPLETE)) {
            this.fireEvent("org.mobicents.slee.media.announcement.COMPLETE", handle, event);
        } else if (eventid.equals((Object)EventID.FAIL)) {
            this.fireEvent("org.mobicents.slee.media.announcement.FAIL", handle, event);
        } else if (eventid.equals((Object)EventID.DTMF)) {
            this.fireEvent("org.mobicents.slee.media.dtmf.DTMF", handle, event);
        }
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)handle);
        }
        catch (Exception e) {
            logger.error((Object)("Could not end activity: " + resource));
        }
    }

    public void linkJoined(MsLinkEvent evt) {
        MsLink link = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(link.toString());
        this.activities.put(handle, link);
        this.fireEvent("org.mobicents.slee.media.JOIN_COMPLETE", handle, evt);
    }

    public void linkDropped(MsLinkEvent evt) {
        MsLink link = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(link.toString());
        this.fireEvent("org.mobicents.slee.media.LINK_DROPPED", handle, evt);
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)handle);
        }
        catch (Exception e) {
            logger.error((Object)("Could not end activity: " + link));
        }
    }

    public void linkFailed(MsLinkEvent evt) {
        MsLink link = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(link.toString());
        this.fireEvent("org.mobicents.slee.media.JOIN_FAIL", handle, evt);
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)handle);
        }
        catch (Exception e) {
            logger.error((Object)("Could not end activity: " + link));
        }
    }

    public void connectionCreated(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        MediaActivityHandle handle = new MediaActivityHandle(connection.toString());
        this.activities.put(handle, connection);
        this.handlers.put(connection.toString(), handle);
        this.fireEvent("org.mobicents.slee.media.CONNECTION_CREATED", handle, evt);
    }

    public void connectionModifed(MsConnectionEvent event) {
        MsConnection connection = event.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("org.mobicents.slee.media.CONNECTION_MODIFIED", handle, event);
    }

    public void connectionDeleted(MsConnectionEvent event) {
        MsConnection connection = event.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("org.mobicents.slee.media.CONNECTION_DELETED", handle, event);
        try {
            this.sleeEndpoint.activityEnding(handle);
        }
        catch (Exception e) {
            logger.error((Object)("Could not end activity: " + connection));
        }
    }

    public void txFailed(MsConnectionEvent event) {
        MsConnection connection = event.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("org.mobicents.slee.media.CONNECTION_TX_FAILED", handle, event);
    }

    public void sessionCreated(MsSessionEvent evt) {
        MsSession session = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(session.toString());
        this.activities.put(handle, session);
        this.fireEvent("org.mobicents.slee.media.SESSION_CREATED", handle, evt);
    }

    public void sessionActive(MsSessionEvent evt) {
        MsSession session = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(session.toString());
        this.fireEvent("org.mobicents.slee.media.SESSION_ACTIVE", handle, evt);
    }

    public void sessionInvalid(MsSessionEvent evt) {
        MsSession session = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(session.toString());
        this.fireEvent("org.mobicents.slee.media.SESSION_INVALID", handle, evt);
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)handle);
        }
        catch (Exception e) {
            logger.error((Object)("Could not end activity: " + session));
        }
    }
}

