/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.mobicents.slee.resource.jdbc.event;

import java.sql.Statement;

public abstract class AbstractStatementEvent implements StatementEvent {

	private final Integer autoGeneratedKeys;
	private final int[] columnIndexes;
	private final String[] columnNames;
	private final String sql;
	private final Statement statement;
	
	protected AbstractStatementEvent(Integer autoGeneratedKeys,
			int[] columnIndexes, String[] columnNames, String sql,
			Statement statement) {				
		this.autoGeneratedKeys = autoGeneratedKeys;
		this.columnIndexes = columnIndexes;
		this.columnNames = columnNames;
		if (sql == null) {
			throw new NullPointerException("null sql");
		}
		this.sql = sql;
		if (statement == null) {
			throw new NullPointerException("null statement");
		}
		this.statement = statement;
	}

	@Override
	public Integer getAutoGeneratedKeys() {
		return autoGeneratedKeys;
	}
	
	@Override
	public int[] getColumnIndexes() {
		return columnIndexes;
	}
	
	@Override
	public String[] getColumnNames() {
		return columnNames;
	}
	
	@Override
	public String getSQL() {
		return sql;
	}
	
	@Override
	public Statement getStatement() {
		return statement;
	}	
	
}
