/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.Address;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.sql.DataSource;
import org.mobicents.slee.resource.jdbc.JdbcActivityImpl;
import org.mobicents.slee.resource.jdbc.JdbcResourceAdaptorMarshaller;
import org.mobicents.slee.resource.jdbc.JdbcResourceAdaptorSbbInterfaceImpl;
import org.mobicents.slee.resource.jdbc.event.PreparedStatementResultSetEvent;
import org.mobicents.slee.resource.jdbc.event.PreparedStatementResultSetEventImpl;
import org.mobicents.slee.resource.jdbc.event.PreparedStatementSQLExceptionEvent;
import org.mobicents.slee.resource.jdbc.event.PreparedStatementSQLExceptionEventImpl;
import org.mobicents.slee.resource.jdbc.event.PreparedStatementUnknownResultEvent;
import org.mobicents.slee.resource.jdbc.event.PreparedStatementUnknownResultEventImpl;
import org.mobicents.slee.resource.jdbc.event.PreparedStatementUpdateCountEvent;
import org.mobicents.slee.resource.jdbc.event.PreparedStatementUpdateCountEventImpl;
import org.mobicents.slee.resource.jdbc.event.StatementResultSetEvent;
import org.mobicents.slee.resource.jdbc.event.StatementResultSetEventImpl;
import org.mobicents.slee.resource.jdbc.event.StatementSQLExceptionEvent;
import org.mobicents.slee.resource.jdbc.event.StatementSQLExceptionEventImpl;
import org.mobicents.slee.resource.jdbc.event.StatementUnknownResultEvent;
import org.mobicents.slee.resource.jdbc.event.StatementUnknownResultEventImpl;
import org.mobicents.slee.resource.jdbc.event.StatementUpdateCountEvent;
import org.mobicents.slee.resource.jdbc.event.StatementUpdateCountEventImpl;

public class JdbcResourceAdaptor
implements ResourceAdaptor {
    private ResourceAdaptorContext context;
    private static final String DATASOURCE_JNDI_NAME_CONFIG_PROPERTY = "DATASOURCE_JNDI_NAME";
    private String datasourceName;
    private static final String EXECUTOR_SERVICE_THREADS_CONFIG_PROPERTY = "EXECUTOR_SERVICE_THREADS";
    private int executorServiceThreads;
    private JdbcResourceAdaptorSbbInterfaceImpl sbbInterface = new JdbcResourceAdaptorSbbInterfaceImpl(this);
    private JdbcResourceAdaptorMarshaller marshaller = new JdbcResourceAdaptorMarshaller(this);
    private Tracer tracer;
    private DataSource datasource;
    private ExecutorService executorService;
    private FireableEventType preparedStatementResultSetEventType;
    private FireableEventType preparedStatementSQLExceptionEventType;
    private FireableEventType preparedStatementUnknownResultEventType;
    private FireableEventType preparedStatementUpdateCountEventType;
    private FireableEventType statementResultSetEventType;
    private FireableEventType statementSQLExceptionEventType;
    private FireableEventType statementUnknownResultEventType;
    private FireableEventType statementUpdateCountEventType;

    public ResourceAdaptorContext getContext() {
        return this.context;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void activityEnded(ActivityHandle activityHandle) {
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
    }

    public void administrativeRemove(ActivityHandle activityHandle) {
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, FireableEventType eventType, Object eventObject, Address address, ReceivableService service, int eventFlags, FailureReason reason) {
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, FireableEventType eventType, Object eventObject, Address address, ReceivableService service, int eventFlags) {
    }

    public void eventUnreferenced(ActivityHandle activityHandle, FireableEventType eventType, Object eventObject, Address address, ReceivableService service, int eventFlags) {
        Statement statement = null;
        if (eventType == this.preparedStatementUnknownResultEventType) {
            statement = ((PreparedStatementUnknownResultEventImpl)eventObject).getPreparedStatement();
        } else if (eventType == this.statementUnknownResultEventType) {
            statement = ((StatementUnknownResultEventImpl)eventObject).getStatement();
        } else {
            this.tracer.warning("got event unreferenced callback for unexpected event type, ignoring");
            return;
        }
        this.closeConnectionIfNeeded(statement);
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return activityHandle;
    }

    public ActivityHandle getActivityHandle(Object activityObject) {
        return (JdbcActivityImpl)activityObject;
    }

    public Marshaler getMarshaler() {
        return this.marshaller;
    }

    public Object getResourceAdaptorInterface(String className) {
        return this.sbbInterface;
    }

    public void queryLiveness(ActivityHandle activityHandle) {
    }

    public void raActive() {
        try {
            this.datasource = (DataSource)InitialContext.doLookup(this.datasourceName);
        }
        catch (NamingException e) {
            this.tracer.severe("failed to retrieve the data source", (Throwable)e);
        }
        this.executorService = Executors.newFixedThreadPool(this.executorServiceThreads);
    }

    public void raConfigurationUpdate(ConfigProperties configuration) {
    }

    public void raConfigure(ConfigProperties configuration) {
        this.datasourceName = (String)configuration.getProperty(DATASOURCE_JNDI_NAME_CONFIG_PROPERTY).getValue();
        this.executorServiceThreads = (Integer)configuration.getProperty(EXECUTOR_SERVICE_THREADS_CONFIG_PROPERTY).getValue();
    }

    public void raInactive() {
        this.datasource = null;
        this.executorService = null;
    }

    public void raStopping() {
    }

    public void raUnconfigure() {
        this.datasourceName = null;
        this.executorServiceThreads = 0;
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
        String datasourceName = (String)properties.getProperty(DATASOURCE_JNDI_NAME_CONFIG_PROPERTY).getValue();
        try {
            InitialContext.doLookup(datasourceName);
        }
        catch (NamingException e) {
            throw new InvalidConfigurationException("bad datasource name", (Throwable)e);
        }
        Integer executorServiceThreads = (Integer)properties.getProperty(EXECUTOR_SERVICE_THREADS_CONFIG_PROPERTY).getValue();
        if (executorServiceThreads < 1) {
            throw new InvalidConfigurationException("executor service threads must be a positive integer");
        }
    }

    public void serviceActive(ReceivableService service) {
    }

    public void serviceInactive(ReceivableService service) {
    }

    public void serviceStopping(ReceivableService service) {
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.context = context;
        this.tracer = context.getTracer(this.getClass().getSimpleName());
        try {
            this.preparedStatementResultSetEventType = context.getEventLookupFacility().getFireableEventType(PreparedStatementResultSetEvent.EVENT_TYPE_ID);
            this.preparedStatementSQLExceptionEventType = context.getEventLookupFacility().getFireableEventType(PreparedStatementSQLExceptionEvent.EVENT_TYPE_ID);
            this.preparedStatementUnknownResultEventType = context.getEventLookupFacility().getFireableEventType(PreparedStatementUnknownResultEvent.EVENT_TYPE_ID);
            this.preparedStatementUpdateCountEventType = context.getEventLookupFacility().getFireableEventType(PreparedStatementUpdateCountEvent.EVENT_TYPE_ID);
            this.statementResultSetEventType = context.getEventLookupFacility().getFireableEventType(StatementResultSetEvent.EVENT_TYPE_ID);
            this.statementSQLExceptionEventType = context.getEventLookupFacility().getFireableEventType(StatementSQLExceptionEvent.EVENT_TYPE_ID);
            this.statementUnknownResultEventType = context.getEventLookupFacility().getFireableEventType(StatementUnknownResultEvent.EVENT_TYPE_ID);
            this.statementUpdateCountEventType = context.getEventLookupFacility().getFireableEventType(StatementUpdateCountEvent.EVENT_TYPE_ID);
        }
        catch (Throwable e) {
            this.tracer.severe("Failed to retrieve fireable event types", e);
        }
    }

    public void unsetResourceAdaptorContext() {
        this.context = null;
        this.tracer = null;
        this.preparedStatementResultSetEventType = null;
        this.preparedStatementSQLExceptionEventType = null;
        this.preparedStatementUnknownResultEventType = null;
        this.preparedStatementUpdateCountEventType = null;
        this.statementResultSetEventType = null;
        this.statementSQLExceptionEventType = null;
        this.statementUnknownResultEventType = null;
        this.statementUpdateCountEventType = null;
    }

    JdbcActivityImpl createActivity() {
        JdbcActivityImpl activity = new JdbcActivityImpl(this, UUID.randomUUID().toString());
        try {
            this.context.getSleeEndpoint().startActivitySuspended((ActivityHandle)activity, (Object)activity, 1);
        }
        catch (Exception e) {
            this.tracer.severe("failed to start activity " + activity.getId(), (Throwable)e);
        }
        return activity;
    }

    void endActivity(JdbcActivityImpl activity) {
        try {
            this.context.getSleeEndpoint().endActivityTransacted((ActivityHandle)activity);
        }
        catch (Exception e) {
            this.tracer.severe("failed to end activity", (Throwable)e);
        }
    }

    void executeQuery(final PreparedStatement preparedStatement, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("executeQuery( preparedStatement = " + preparedStatement + " , activity = " + activity + " )");
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    ResultSet resultSet = preparedStatement.executeQuery();
                    preparedStatement.getConnection().close();
                    PreparedStatementResultSetEventImpl event = new PreparedStatementResultSetEventImpl(preparedStatement, resultSet);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.preparedStatementResultSetEventType, event, activity);
                }
                catch (SQLException e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed execute sql", (Throwable)e);
                    }
                    JdbcResourceAdaptor.this.closeConnectionIfNeeded(preparedStatement);
                    PreparedStatementSQLExceptionEventImpl event = new PreparedStatementSQLExceptionEventImpl(preparedStatement, e);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.preparedStatementSQLExceptionEventType, event, activity);
                }
            }
        };
        this.executorService.submit(task);
    }

    private void fireEvent(FireableEventType eventType, Object event, ActivityHandle activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("firing event: eventType = " + eventType + " , event = " + event + " , activity = " + activity);
        }
        int eventFlags = 0;
        if (eventType == this.statementUnknownResultEventType || eventType == this.preparedStatementUnknownResultEventType) {
            eventFlags = 128;
        }
        try {
            this.context.getSleeEndpoint().fireEvent(activity, eventType, event, null, null, eventFlags);
        }
        catch (Throwable e) {
            this.tracer.severe("failed to fire event " + eventType + " in handle " + activity, e);
        }
    }

    private void closeConnectionIfNeeded(Statement statement) {
        try {
            if (!statement.getConnection().isClosed()) {
                statement.getConnection().close();
            }
        }
        catch (Exception f) {
            this.tracer.severe("failed to close connection", (Throwable)f);
        }
    }

    void executeUpdate(final PreparedStatement preparedStatement, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("executeUpdate( preparedStatement = " + preparedStatement + " , activity = " + activity + " )");
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    int updateCount = preparedStatement.executeUpdate();
                    preparedStatement.getConnection().close();
                    PreparedStatementUpdateCountEventImpl event = new PreparedStatementUpdateCountEventImpl(preparedStatement, updateCount);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.preparedStatementUpdateCountEventType, event, activity);
                }
                catch (SQLException e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed execute sql", (Throwable)e);
                    }
                    JdbcResourceAdaptor.this.closeConnectionIfNeeded(preparedStatement);
                    PreparedStatementSQLExceptionEventImpl event = new PreparedStatementSQLExceptionEventImpl(preparedStatement, e);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.preparedStatementSQLExceptionEventType, event, activity);
                }
            }
        };
        this.executorService.submit(task);
    }

    void execute(final PreparedStatement preparedStatement, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("execute( preparedStatement = " + preparedStatement + " , activity = " + activity + " )");
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    boolean executionResult = preparedStatement.execute();
                    PreparedStatementUnknownResultEventImpl event = new PreparedStatementUnknownResultEventImpl(preparedStatement, executionResult);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.preparedStatementUnknownResultEventType, event, activity);
                }
                catch (SQLException e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed execute sql", (Throwable)e);
                    }
                    JdbcResourceAdaptor.this.closeConnectionIfNeeded(preparedStatement);
                    PreparedStatementSQLExceptionEventImpl event = new PreparedStatementSQLExceptionEventImpl(preparedStatement, e);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.preparedStatementSQLExceptionEventType, event, activity);
                }
            }
        };
        this.executorService.submit(task);
    }

    void execute(final Statement statement, final String sql, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("execute( statement = " + statement + " , sql = " + sql + " , activity = " + activity + " )");
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    boolean executionResult = statement.execute(sql);
                    StatementUnknownResultEventImpl event = new StatementUnknownResultEventImpl(null, null, null, sql, statement, executionResult);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementUnknownResultEventType, event, activity);
                }
                catch (SQLException e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed execute sql", (Throwable)e);
                    }
                    JdbcResourceAdaptor.this.closeConnectionIfNeeded(statement);
                    StatementSQLExceptionEventImpl event = new StatementSQLExceptionEventImpl(null, null, null, sql, statement, e);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementSQLExceptionEventType, event, activity);
                }
            }
        };
        this.executorService.submit(task);
    }

    void execute(final Statement statement, final String sql, final int autoGeneratedKeys, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("execute( statement = " + statement + " , sql = " + sql + " , autoGeneratedKeys = " + autoGeneratedKeys + " , activity = " + activity + " )");
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    boolean executionResult = statement.execute(sql);
                    StatementUnknownResultEventImpl event = new StatementUnknownResultEventImpl(autoGeneratedKeys, null, null, sql, statement, executionResult);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementUnknownResultEventType, event, activity);
                }
                catch (SQLException e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed execute sql", (Throwable)e);
                    }
                    JdbcResourceAdaptor.this.closeConnectionIfNeeded(statement);
                    StatementSQLExceptionEventImpl event = new StatementSQLExceptionEventImpl(autoGeneratedKeys, null, null, sql, statement, e);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementSQLExceptionEventType, event, activity);
                }
            }
        };
        this.executorService.submit(task);
    }

    void execute(final Statement statement, final String sql, final int[] columnIndexes, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("execute( statement = " + statement + " , sql = " + sql + " , columnIndexes = " + columnIndexes == null ? null : Arrays.asList(new int[][]{columnIndexes}) + " , activity = " + activity + " )");
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    boolean executionResult = statement.execute(sql);
                    StatementUnknownResultEventImpl event = new StatementUnknownResultEventImpl(null, columnIndexes, null, sql, statement, executionResult);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementUnknownResultEventType, event, activity);
                }
                catch (SQLException e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed execute sql", (Throwable)e);
                    }
                    JdbcResourceAdaptor.this.closeConnectionIfNeeded(statement);
                    StatementSQLExceptionEventImpl event = new StatementSQLExceptionEventImpl(null, columnIndexes, null, sql, statement, e);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementSQLExceptionEventType, event, activity);
                }
            }
        };
        this.executorService.submit(task);
    }

    void execute(final Statement statement, final String sql, final String[] columnNames, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("execute( statement = " + statement + " , sql = " + sql + " , columnNames = " + columnNames == null ? null : Arrays.asList(columnNames) + " , activity = " + activity + " )");
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    boolean executionResult = statement.execute(sql);
                    StatementUnknownResultEventImpl event = new StatementUnknownResultEventImpl(null, null, columnNames, sql, statement, executionResult);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementUnknownResultEventType, event, activity);
                }
                catch (SQLException e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed execute sql", (Throwable)e);
                    }
                    JdbcResourceAdaptor.this.closeConnectionIfNeeded(statement);
                    StatementSQLExceptionEventImpl event = new StatementSQLExceptionEventImpl(null, null, columnNames, sql, statement, e);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementSQLExceptionEventType, event, activity);
                }
            }
        };
        this.executorService.submit(task);
    }

    void executeQuery(final Statement statement, final String sql, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("executeQuery( statement = " + statement + " , sql = " + sql + " , activity = " + activity + " )");
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    ResultSet resultSet = statement.executeQuery(sql);
                    statement.getConnection().close();
                    StatementResultSetEventImpl event = new StatementResultSetEventImpl(sql, statement, resultSet);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementResultSetEventType, event, activity);
                }
                catch (SQLException e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed execute sql", (Throwable)e);
                    }
                    JdbcResourceAdaptor.this.closeConnectionIfNeeded(statement);
                    StatementSQLExceptionEventImpl event = new StatementSQLExceptionEventImpl(null, null, null, sql, statement, e);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementSQLExceptionEventType, event, activity);
                }
            }
        };
        this.executorService.submit(task);
    }

    void executeUpdate(final Statement statement, final String sql, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("executeUpdate( statement = " + statement + " , sql = " + sql + " , activity = " + activity + " )");
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    int updateCount = statement.executeUpdate(sql);
                    statement.getConnection().close();
                    StatementUpdateCountEventImpl event = new StatementUpdateCountEventImpl(null, null, null, sql, statement, updateCount);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementUpdateCountEventType, event, activity);
                }
                catch (SQLException e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed execute sql", (Throwable)e);
                    }
                    JdbcResourceAdaptor.this.closeConnectionIfNeeded(statement);
                    StatementSQLExceptionEventImpl event = new StatementSQLExceptionEventImpl(null, null, null, sql, statement, e);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementSQLExceptionEventType, event, activity);
                }
            }
        };
        this.executorService.submit(task);
    }

    void executeUpdate(final Statement statement, final String sql, final int autoGeneratedKeys, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("executeUpdate( statement = " + statement + " , sql = " + sql + " , autoGeneratedKeys = " + autoGeneratedKeys + " , activity = " + activity + " )");
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    int updateCount = statement.executeUpdate(sql);
                    statement.getConnection().close();
                    StatementUpdateCountEventImpl event = new StatementUpdateCountEventImpl(autoGeneratedKeys, null, null, sql, statement, updateCount);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementUpdateCountEventType, event, activity);
                }
                catch (SQLException e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed execute sql", (Throwable)e);
                    }
                    JdbcResourceAdaptor.this.closeConnectionIfNeeded(statement);
                    StatementSQLExceptionEventImpl event = new StatementSQLExceptionEventImpl(autoGeneratedKeys, null, null, sql, statement, e);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementSQLExceptionEventType, event, activity);
                }
            }
        };
        this.executorService.submit(task);
    }

    void executeUpdate(final Statement statement, final String sql, final int[] columnIndexes, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("executeUpdate( statement = " + statement + " , sql = " + sql + " , columnIndexes = " + columnIndexes == null ? null : Arrays.asList(new int[][]{columnIndexes}) + " , activity = " + activity + " )");
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    int updateCount = statement.executeUpdate(sql);
                    statement.getConnection().close();
                    StatementUpdateCountEventImpl event = new StatementUpdateCountEventImpl(null, columnIndexes, null, sql, statement, updateCount);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementUpdateCountEventType, event, activity);
                }
                catch (SQLException e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed execute sql", (Throwable)e);
                    }
                    JdbcResourceAdaptor.this.closeConnectionIfNeeded(statement);
                    StatementSQLExceptionEventImpl event = new StatementSQLExceptionEventImpl(null, columnIndexes, null, sql, statement, e);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementSQLExceptionEventType, event, activity);
                }
            }
        };
        this.executorService.submit(task);
    }

    void executeUpdate(final Statement statement, final String sql, final String[] columnNames, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("executeUpdate( statement = " + statement + " , sql = " + sql + " , columnNames = " + columnNames == null ? null : Arrays.asList(columnNames) + " , activity = " + activity + " )");
        }
        Runnable task = new Runnable(){

            public void run() {
                try {
                    int updateCount = statement.executeUpdate(sql);
                    statement.getConnection().close();
                    StatementUpdateCountEventImpl event = new StatementUpdateCountEventImpl(null, null, columnNames, sql, statement, updateCount);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementUpdateCountEventType, event, activity);
                }
                catch (SQLException e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed execute sql", (Throwable)e);
                    }
                    JdbcResourceAdaptor.this.closeConnectionIfNeeded(statement);
                    StatementSQLExceptionEventImpl event = new StatementSQLExceptionEventImpl(null, null, columnNames, sql, statement, e);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.statementSQLExceptionEventType, event, activity);
                }
            }
        };
        this.executorService.submit(task);
    }
}

