/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.xcapclient;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.slee.Address;
import javax.slee.EventTypeID;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import org.mobicents.slee.resource.xcapclient.AsyncActivityImpl;
import org.mobicents.slee.resource.xcapclient.ResponseEvent;
import org.mobicents.slee.resource.xcapclient.XCAPClientResourceAdaptorSbbInterfaceImpl;
import org.mobicents.slee.resource.xcapclient.XCAPResourceAdaptorActivityHandle;
import org.mobicents.xcap.client.XcapClient;
import org.mobicents.xcap.client.impl.XcapClientImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCAPClientResourceAdaptor
implements ResourceAdaptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private ConcurrentHashMap<XCAPResourceAdaptorActivityHandle, AsyncActivityImpl> activities;
    private XCAPClientResourceAdaptorSbbInterfaceImpl sbbInterface;
    private XcapClient client;
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private ResourceAdaptorContext raContext;
    private SleeEndpoint sleeEndpoint;
    private EventLookupFacility eventLookupFacility;
    private Tracer tracer;
    private FireableEventType getResponseEvent;
    private FireableEventType putResponseEvent;
    private FireableEventType deleteResponseEvent;

    public FireableEventType getGetResponseEventType() {
        return this.getResponseEvent;
    }

    public FireableEventType getDeleteResponseEventType() {
        return this.deleteResponseEvent;
    }

    public FireableEventType getPutResponseEventType() {
        return this.putResponseEvent;
    }

    public void endActivity(ActivityHandle ah) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("endActivity");
        }
        if (this.activities.containsKey(ah)) {
            try {
                this.sleeEndpoint.endActivity(ah);
            }
            catch (Exception e) {
                this.tracer.severe("unable to end activity: ", (Throwable)e);
            }
        }
    }

    public void activityEnded(ActivityHandle ah) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("activityEnded( handle = " + ah + ")");
        }
        this.activities.remove(ah);
    }

    public void activityUnreferenced(ActivityHandle ah) {
    }

    public void queryLiveness(ActivityHandle ah) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("queryLiveness( handle = " + ah + ")");
        }
        if (!this.activities.contains(ah)) {
            this.raContext.getSleeEndpoint().endActivity(ah);
        }
    }

    public Object getActivity(ActivityHandle ah) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("get Activity with ActivityHandle " + ah.toString());
        }
        return this.activities.get(ah);
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        XCAPResourceAdaptorActivityHandle activityHandle;
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("getActivityHandle");
        }
        if (this.activities.containsKey(activityHandle = ((AsyncActivityImpl)arg0).getHandle())) {
            return activityHandle;
        }
        return null;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void processResponseEvent(FireableEventType eventType, ResponseEvent event, XCAPResourceAdaptorActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("NEW RESPONSE EVENT");
        }
        try {
            this.sleeEndpoint.fireEvent((ActivityHandle)handle, eventType, (Object)event, null, null);
        }
        catch (Exception e) {
            this.tracer.severe("unable to fire event", (Throwable)e);
        }
    }

    protected ConcurrentHashMap<XCAPResourceAdaptorActivityHandle, AsyncActivityImpl> getActivities() {
        return this.activities;
    }

    public SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }

    public XcapClient getClient() {
        return this.client;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void addActivity(XCAPResourceAdaptorActivityHandle activityHandle, AsyncActivityImpl activity) {
        this.activities.put(activityHandle, activity);
    }

    public Tracer getTracer(String tracerName) {
        return this.tracer;
    }

    public ResourceAdaptorContext getXCAPResourceAdaptorContext() {
        return this.raContext;
    }

    public void administrativeRemove(ActivityHandle arg0) {
        this.activities.remove(arg0);
    }

    public void eventProcessingFailed(ActivityHandle ah, FireableEventType arg1, Object arg2, Address ad, ReceivableService arg4, int arg5, FailureReason fr) {
    }

    public void eventProcessingSuccessful(ActivityHandle ah, FireableEventType arg1, Object arg2, Address ad, ReceivableService arg4, int arg5) {
    }

    public void eventUnreferenced(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public Object getResourceAdaptorInterface(String arg0) {
        return this.sbbInterface;
    }

    public void raActive() {
        this.client = new XcapClientImpl();
        this.activities = new ConcurrentHashMap();
        this.executorService = Executors.newCachedThreadPool();
        this.sbbInterface.setActive(true);
    }

    public void raConfigurationUpdate(ConfigProperties arg0) {
    }

    public void raConfigure(ConfigProperties arg0) {
    }

    public void raInactive() {
        this.sbbInterface.setActive(false);
        this.activities = null;
        this.client.shutdown();
        this.client = null;
        this.executorService.shutdown();
        this.executorService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raStopping() {
        ConcurrentHashMap<XCAPResourceAdaptorActivityHandle, AsyncActivityImpl> concurrentHashMap = this.activities;
        synchronized (concurrentHashMap) {
            for (XCAPResourceAdaptorActivityHandle handle : this.activities.keySet()) {
                this.endActivity((ActivityHandle)handle);
            }
        }
    }

    public void raUnconfigure() {
    }

    public void raVerifyConfiguration(ConfigProperties arg0) throws InvalidConfigurationException {
    }

    public void serviceActive(ReceivableService arg0) {
    }

    public void serviceInactive(ReceivableService arg0) {
    }

    public void serviceStopping(ReceivableService arg0) {
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext raContext) {
        block2: {
            this.raContext = raContext;
            this.tracer = raContext.getTracer("XCAPClientResourceAdaptor");
            this.sbbInterface = new XCAPClientResourceAdaptorSbbInterfaceImpl(this);
            this.sleeEndpoint = raContext.getSleeEndpoint();
            this.eventLookupFacility = raContext.getEventLookupFacility();
            try {
                this.getResponseEvent = this.eventLookupFacility.getFireableEventType(new EventTypeID("GetResponseEvent", "org.mobicents", "2.0"));
                this.putResponseEvent = this.eventLookupFacility.getFireableEventType(new EventTypeID("PutResponseEvent", "org.mobicents", "2.0"));
                this.deleteResponseEvent = this.eventLookupFacility.getFireableEventType(new EventTypeID("DeleteResponseEvent", "org.mobicents", "2.0"));
            }
            catch (Exception e) {
                if (!this.tracer.isWarningEnabled()) break block2;
                this.tracer.warning("Could not look up Response Event", (Throwable)e);
            }
        }
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.tracer = null;
        this.sleeEndpoint = null;
        this.eventLookupFacility = null;
        this.sbbInterface = null;
    }
}

