/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.callleg;

import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.P_INVALID_ADDRESS;
import org.csapi.P_INVALID_AMOUNT;
import org.csapi.P_INVALID_CRITERIA;
import org.csapi.P_INVALID_CURRENCY;
import org.csapi.P_INVALID_EVENT_TYPE;
import org.csapi.P_INVALID_NETWORK_STATE;
import org.csapi.P_INVALID_SESSION_ID;
import org.csapi.P_UNSUPPORTED_ADDRESS_PLAN;
import org.csapi.TpAddress;
import org.csapi.TpAoCInfo;
import org.csapi.TpCommonExceptions;
import org.csapi.cc.TpCallAppInfo;
import org.csapi.cc.TpCallChargePlan;
import org.csapi.cc.TpCallError;
import org.csapi.cc.TpCallEventInfo;
import org.csapi.cc.TpCallEventRequest;
import org.csapi.cc.TpCallLegConnectionProperties;
import org.csapi.cc.TpCallLegInfoReport;
import org.csapi.cc.TpReleaseCause;
import org.csapi.cc.mpccs.IpCallLeg;
import org.csapi.cc.mpccs.TpCallLegIdentifier;
import org.csapi.cc.mpccs.TpMultiPartyCallIdentifier;
import org.mobicents.csapi.jr.slee.cc.mpccs.AttachMediaErrEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.AttachMediaResEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.CallLegEndedEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.DetachMediaErrEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.DetachMediaResEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.EventReportErrEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.EventReportResEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.GetInfoErrEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.GetInfoResEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.RouteErrEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.SuperviseErrEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.SuperviseResEvent;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.MpccsListener;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.TpCallLegActivityHandle;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.callleg.CallLeg;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycall.MultiPartyCall;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycallcontrolmanager.MultiPartyCallControlManager;
import org.mobicents.slee.resource.parlay.util.ParlayExceptionUtil;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;

public class CallLegImpl
implements CallLeg {
    private static final String CALL_LEG_SESSION_IS_NO_LONGER_VALID = "Call leg session is no longer valid.";
    private static final Log logger = LogFactory.getLog(CallLegImpl.class);
    private transient MultiPartyCallControlManager multiPartyCallControlManager;
    private transient MultiPartyCall multiPartyCall;
    private final transient org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier tpCallLegIdentifier;
    private transient IpCallLeg ipCallLeg;
    private final transient int callLegSessionID;
    private final transient ActivityManager activityManager;
    private transient MpccsListener eventListener;
    private final transient ActivityHandle activityHandle;

    public CallLegImpl(MultiPartyCallControlManager multiPartyCallControlManager, MultiPartyCall multiPartyCall, org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier tpCallLegIdentifier, IpCallLeg ipCallLeg, int callLegSessionID, ActivityManager activityManager, MpccsListener eventListener) {
        this.multiPartyCallControlManager = multiPartyCallControlManager;
        this.multiPartyCall = multiPartyCall;
        this.tpCallLegIdentifier = tpCallLegIdentifier;
        this.ipCallLeg = ipCallLeg;
        this.callLegSessionID = callLegSessionID;
        this.activityManager = activityManager;
        this.eventListener = eventListener;
        this.activityHandle = new TpCallLegActivityHandle(tpCallLegIdentifier);
    }

    public void init() {
    }

    public org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier getTpCallLegIdentifier() {
        return this.tpCallLegIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpCallLeg getIpCallLeg() {
        CallLegImpl callLegImpl = this;
        synchronized (callLegImpl) {
            return this.ipCallLeg;
        }
    }

    public MultiPartyCallControlManager getMpccsSession() {
        return this.multiPartyCallControlManager;
    }

    public void routeReq(TpAddress arg1, TpAddress arg2, TpCallAppInfo[] arg3, TpCallLegConnectionProperties arg4) throws TpCommonExceptions, P_INVALID_NETWORK_STATE, P_INVALID_ADDRESS, P_UNSUPPORTED_ADDRESS_PLAN, ResourceException {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                callLeg.routeReq(this.callLegSessionID, arg1, arg2, arg3, arg4);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void eventReportReq(TpCallEventRequest[] arg1) throws TpCommonExceptions, P_INVALID_EVENT_TYPE, P_INVALID_CRITERIA, ResourceException {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                callLeg.eventReportReq(this.callLegSessionID, arg1);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void release(TpReleaseCause arg1) throws TpCommonExceptions, P_INVALID_NETWORK_STATE, ResourceException {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                callLeg.release(this.callLegSessionID, arg1);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void getInfoReq(int arg1) throws TpCommonExceptions, ResourceException {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                callLeg.getInfoReq(this.callLegSessionID, arg1);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public org.mobicents.csapi.jr.slee.cc.mpccs.TpMultiPartyCallIdentifier getCall() throws TpCommonExceptions, ResourceException {
        org.mobicents.csapi.jr.slee.cc.mpccs.TpMultiPartyCallIdentifier result = null;
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                TpMultiPartyCallIdentifier callIdentifier = callLeg.getCall(this.callLegSessionID);
                result = new org.mobicents.csapi.jr.slee.cc.mpccs.TpMultiPartyCallIdentifier(this.multiPartyCall.getTpMultiPartyCallIdentifier().getCallRefID(), callIdentifier.CallSessionID);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
        }
        return result;
    }

    public void attachMediaReq() throws TpCommonExceptions, P_INVALID_NETWORK_STATE, ResourceException {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                callLeg.attachMediaReq(this.callLegSessionID);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void detachMediaReq() throws TpCommonExceptions, P_INVALID_NETWORK_STATE, ResourceException {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                callLeg.detachMediaReq(this.callLegSessionID);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public TpAddress getCurrentDestinationAddress() throws TpCommonExceptions, ResourceException {
        TpAddress result = null;
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                result = callLeg.getCurrentDestinationAddress(this.callLegSessionID);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
        }
        return result;
    }

    public void continueProcessing() throws TpCommonExceptions, P_INVALID_NETWORK_STATE, ResourceException {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                callLeg.continueProcessing(this.callLegSessionID);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void setChargePlan(TpCallChargePlan arg1) throws TpCommonExceptions, ResourceException {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                callLeg.setChargePlan(this.callLegSessionID, arg1);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void setAdviceOfCharge(TpAoCInfo arg1, int arg2) throws TpCommonExceptions, P_INVALID_CURRENCY, P_INVALID_AMOUNT, ResourceException {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                callLeg.setAdviceOfCharge(this.callLegSessionID, arg1, arg2);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void superviseReq(int arg1, int arg2) throws TpCommonExceptions, ResourceException {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                callLeg.superviseReq(this.callLegSessionID, arg1, arg2);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void deassign() throws TpCommonExceptions, ResourceException {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            try {
                callLeg.deassign(this.callLegSessionID);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((Object)(CALL_LEG_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_LEG_SESSION_IS_NO_LONGER_VALID);
            }
            this.dispose();
            this.activityManager.remove(this.activityHandle, this.tpCallLegIdentifier);
            this.activityManager.activityEnding(this.activityHandle);
        }
    }

    public void eventReportRes(int arg0, TpCallEventInfo arg1) {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            EventReportResEvent event = new EventReportResEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.multiPartyCall.getTpMultiPartyCallIdentifier(), this.tpCallLegIdentifier, arg1);
            this.eventListener.onEventReportResEvent(event);
        }
    }

    public void eventReportErr(int arg0, TpCallError arg1) {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            EventReportErrEvent event = new EventReportErrEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.multiPartyCall.getTpMultiPartyCallIdentifier(), this.tpCallLegIdentifier, arg1);
            this.eventListener.onEventReportErrEvent(event);
        }
    }

    public void attachMediaRes(int arg0) {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            AttachMediaResEvent event = new AttachMediaResEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.multiPartyCall.getTpMultiPartyCallIdentifier(), this.tpCallLegIdentifier);
            this.eventListener.onAttachMediaResEvent(event);
        }
    }

    public void attachMediaErr(int arg0, TpCallError arg1) {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            AttachMediaErrEvent event = new AttachMediaErrEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.multiPartyCall.getTpMultiPartyCallIdentifier(), this.tpCallLegIdentifier, arg1);
            this.eventListener.onAttachMediaErrEvent(event);
        }
    }

    public void detachMediaRes(int arg0) {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            DetachMediaResEvent event = new DetachMediaResEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.multiPartyCall.getTpMultiPartyCallIdentifier(), this.tpCallLegIdentifier);
            this.eventListener.onDetachMediaResEvent(event);
        }
    }

    public void detachMediaErr(int arg0, TpCallError arg1) {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            DetachMediaErrEvent event = new DetachMediaErrEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.multiPartyCall.getTpMultiPartyCallIdentifier(), this.tpCallLegIdentifier, arg1);
            this.eventListener.onDetachMediaErrEvent(event);
        }
    }

    public void getInfoRes(int arg0, TpCallLegInfoReport arg1) {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            GetInfoResEvent event = new GetInfoResEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.multiPartyCall.getTpMultiPartyCallIdentifier(), this.tpCallLegIdentifier, arg1);
            this.eventListener.onGetInfoResEvent(event);
        }
    }

    public void getInfoErr(int arg0, TpCallError arg1) {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            GetInfoErrEvent event = new GetInfoErrEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.multiPartyCall.getTpMultiPartyCallIdentifier(), this.tpCallLegIdentifier, arg1);
            this.eventListener.onGetInfoErrEvent(event);
        }
    }

    public void routeErr(int arg0, TpCallError arg1) {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            RouteErrEvent event = new RouteErrEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.multiPartyCall.getTpMultiPartyCallIdentifier(), this.tpCallLegIdentifier, arg1);
            this.eventListener.onRouteErrEvent(event);
        }
    }

    public void superviseRes(int arg0, int arg1, int arg2) {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            SuperviseResEvent event = new SuperviseResEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.multiPartyCall.getTpMultiPartyCallIdentifier(), this.tpCallLegIdentifier, arg1, arg2);
            this.eventListener.onSuperviseResEvent(event);
        }
    }

    public void superviseErr(int arg0, TpCallError arg1) {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            SuperviseErrEvent event = new SuperviseErrEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.multiPartyCall.getTpMultiPartyCallIdentifier(), this.tpCallLegIdentifier, arg1);
            this.eventListener.onSuperviseErrEvent(event);
        }
    }

    public void callLegEnded(int arg0, TpReleaseCause arg1) {
        IpCallLeg callLeg = this.getIpCallLeg();
        if (callLeg != null) {
            CallLegEndedEvent event = new CallLegEndedEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.multiPartyCall.getTpMultiPartyCallIdentifier(), this.tpCallLegIdentifier, arg1);
            this.eventListener.onCallLegEndedEvent(event);
            this.activityManager.remove(this.activityHandle, this.tpCallLegIdentifier);
            this.activityManager.activityEnding(this.activityHandle);
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        CallLegImpl callLegImpl = this;
        synchronized (callLegImpl) {
            this.ipCallLeg = null;
            if (this.multiPartyCall != null) {
                this.multiPartyCall.removeCallLeg(this.tpCallLegIdentifier.getCallLegSessionID());
                this.multiPartyCall = null;
            }
            this.multiPartyCallControlManager = null;
            this.eventListener = null;
        }
    }

    public void closeConnection() throws ResourceException {
    }

    public TpCallLegIdentifier getParlayTpCallLegIdentifier() {
        return new TpCallLegIdentifier(this.ipCallLeg, this.callLegSessionID);
    }

    public ActivityHandle getActivityHandle() {
        return this.activityHandle;
    }
}

