/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.util.crypto;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.openssl.PEMReader;
import org.mobicents.slee.resource.parlay.util.crypto.RSAUtilException;

public class RSAUtil {
    private static final Log logger = LogFactory.getLog(RSAUtil.class);
    private static final String CIPHER_ALGORITHM_PROVIDER = "BC";
    private static final String IO_EXCEPTION = "IOException";
    private static KeyStore keyStore = null;
    private static char[] password = "password".toCharArray();

    public static KeyPair generateRSAKeyPair(int keySize) throws RSAUtilException {
        KeyPair keyPair = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Getting a KeyPairGenerator");
                logger.debug((Object)"Algorithm = RSA");
                logger.debug((Object)"Provider  = BC");
            }
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", CIPHER_ALGORITHM_PROVIDER);
            kpg.initialize(keySize);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Generating a Key Pair of size " + keySize + " ..."));
            }
            keyPair = kpg.generateKeyPair();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Key pairs generated.");
            }
        }
        catch (GeneralSecurityException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exception:", ex.fillInStackTrace());
            }
            throw new RSAUtilException("GeneralSecurityException", ex);
        }
        return keyPair;
    }

    public static RSAPublicKey getPublicKey(String file, String clientID) throws RSAUtilException {
        X509Certificate cert = RSAUtil.getCertificate(file, clientID);
        return (RSAPublicKey)cert.getPublicKey();
    }

    private static X509Certificate getCertificate(String file, String clientID) throws RSAUtilException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retreiving certificate for client: " + clientID));
        }
        X509Certificate result = null;
        try {
            if (keyStore.containsAlias(clientID + "CSWAY")) {
                result = (X509Certificate)keyStore.getCertificate(clientID);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Certificate obtained in keyStore.");
                }
            } else {
                result = RSAUtil.readPEM(file);
                keyStore.setCertificateEntry(clientID + "CSWAY", result);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Obtained certificate from file.");
                }
            }
        }
        catch (KeyStoreException e) {
            throw new RSAUtilException("KeyStoreException", e);
        }
        catch (RSAUtilException e) {
            throw new RSAUtilException("RSAUtilException", e);
        }
        return result;
    }

    public static PrivateKey getPrivateKey(String clientID) throws RSAUtilException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"getPrivateKey");
        }
        PrivateKey result = null;
        try {
            Key tmp = keyStore.getKey(clientID, password);
            if (!(tmp instanceof PrivateKey)) {
                logger.info((Object)("CLASS: " + tmp.getClass()));
                throw new RSAUtilException("No private key for clientID: " + clientID);
            }
            result = (PrivateKey)tmp;
        }
        catch (KeyStoreException e) {
            throw new RSAUtilException("KeyStoreException " + e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RSAUtilException("NoSuchAlgorithmException " + e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RSAUtilException("UnrecoverableKeyException " + e);
        }
        return result;
    }

    private static X509Certificate readPEM(String certFile) throws RSAUtilException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reading PEM file: " + certFile));
        }
        X509Certificate cert = null;
        PEMReader pemRd = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            fis = new FileInputStream(certFile);
            isr = new InputStreamReader(fis);
            pemRd = new PEMReader((Reader)isr);
            Object o = pemRd.readObject();
            if (o instanceof X509Certificate) {
                cert = (X509Certificate)o;
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error reading PEM file.");
            }
        }
        catch (FileNotFoundException e) {
            throw new RSAUtilException("File (" + certFile + ") not found.", e);
        }
        catch (IOException e) {
            throw new RSAUtilException(IO_EXCEPTION, e);
        }
        finally {
            try {
                fis.close();
                isr.close();
                pemRd.close();
            }
            catch (IOException e1) {
                throw new RSAUtilException(IO_EXCEPTION, e1);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read PEM file: " + certFile));
        }
        return cert;
    }

    public static byte[] encryptMessage(byte[] message, RSAPublicKey publicKey, String cipherAlgorithm) throws RSAUtilException {
        byte[] result = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ciper Algorithm: " + cipherAlgorithm));
        }
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm, CIPHER_ALGORITHM_PROVIDER);
            cipher.init(1, publicKey);
            result = cipher.doFinal(message);
        }
        catch (GeneralSecurityException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exception:", ex.fillInStackTrace());
            }
            throw new RSAUtilException("Invalid key", ex);
        }
        return result;
    }

    public static byte[] decryptMessage(byte[] message, PrivateKey privateKey, String cipherAlgorithm) throws RSAUtilException {
        byte[] result = null;
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm, CIPHER_ALGORITHM_PROVIDER);
            cipher.init(2, privateKey);
            result = cipher.doFinal(message);
        }
        catch (GeneralSecurityException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exception:", ex.fillInStackTrace());
            }
            throw new RSAUtilException("GeneralSecurityException", ex);
        }
        return result;
    }

    public static void loadKeyStore(String vault, String file) throws RSAUtilException {
        String keyStoreLocation = vault + "/" + file;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempting to open keyStore >>" + keyStoreLocation + "<<"));
            }
            keyStore = KeyStore.getInstance("BKS", CIPHER_ALGORITHM_PROVIDER);
            try {
                keyStore.load(new FileInputStream(keyStoreLocation), password);
            }
            catch (NoSuchAlgorithmException e1) {
                logger.warn((Object)"NoSuchAlgorithmException, keyStore not found creating new keyStore");
                keyStore.load(null, password);
            }
            catch (CertificateException e1) {
                logger.warn((Object)"CertificateException, keyStore not found creating new keyStore");
                keyStore.load(null, password);
            }
            catch (FileNotFoundException e1) {
                logger.warn((Object)"FileNotFoundException, keyStore not found creating new keyStore");
                keyStore.load(null, password);
            }
            catch (IOException e1) {
                logger.warn((Object)"IOException, keyStore not found creating new keyStore");
                keyStore.load(null, password);
            }
        }
        catch (KeyStoreException e) {
            throw new RSAUtilException("KeyStoreException", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RSAUtilException("NoSuchAlgorithmException", e);
        }
        catch (CertificateException e) {
            throw new RSAUtilException("CertificateException", e);
        }
        catch (IOException e) {
            throw new RSAUtilException(IO_EXCEPTION, e);
        }
        catch (NoSuchProviderException e) {
            throw new RSAUtilException("NoSuchProviderException", e);
        }
    }

    public static void saveKeyStore(String vault) throws RSAUtilException {
        try {
            keyStore.store(new FileOutputStream(vault + "/mobicents-parlay-ra.jks"), password);
        }
        catch (KeyStoreException e) {
            throw new RSAUtilException(IO_EXCEPTION, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RSAUtilException(IO_EXCEPTION, e);
        }
        catch (CertificateException e) {
            throw new RSAUtilException(IO_EXCEPTION, e);
        }
        catch (FileNotFoundException e) {
            throw new RSAUtilException(IO_EXCEPTION, e);
        }
        catch (IOException e) {
            throw new RSAUtilException(IO_EXCEPTION, e);
        }
    }
}

