/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.call;

import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.P_INVALID_ADDRESS;
import org.csapi.P_INVALID_CRITERIA;
import org.csapi.P_INVALID_EVENT_TYPE;
import org.csapi.P_INVALID_NETWORK_STATE;
import org.csapi.P_INVALID_SESSION_ID;
import org.csapi.P_UNSUPPORTED_ADDRESS_PLAN;
import org.csapi.TpAddress;
import org.csapi.TpAoCInfo;
import org.csapi.TpCommonExceptions;
import org.csapi.cc.TpCallChargePlan;
import org.csapi.cc.TpCallError;
import org.csapi.cc.gccs.IpCall;
import org.csapi.cc.gccs.TpCallAppInfo;
import org.csapi.cc.gccs.TpCallEndedReport;
import org.csapi.cc.gccs.TpCallFault;
import org.csapi.cc.gccs.TpCallInfoReport;
import org.csapi.cc.gccs.TpCallReleaseCause;
import org.csapi.cc.gccs.TpCallReport;
import org.csapi.cc.gccs.TpCallReportRequest;
import org.mobicents.csapi.jr.slee.cc.gccs.CallEndedEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.CallFaultDetectedEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.GetCallInfoErrEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.GetCallInfoResEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.GetMoreDialledDigitsErrEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.GetMoreDialledDigitsResEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.RouteErrEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.RouteResEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.SuperviseCallErrEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.SuperviseCallResEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.TpCallIdentifier;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.GccsListener;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.TpCallActivityHandle;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.call.Call;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.callcontrolmanager.CallControlManager;
import org.mobicents.slee.resource.parlay.util.ParlayExceptionUtil;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;

public class CallImpl
implements Call {
    private static final Log logger = LogFactory.getLog(CallImpl.class);
    private static final String CALL_NOT_VALID = "Call session is no longer valid.";
    private transient CallControlManager callControlManager;
    private final transient IpCall ipCall;
    private final transient int callSessionID;
    private final transient TpCallIdentifier tpCallIdentifier;
    private final transient ActivityManager activityManager;
    private transient GccsListener eventListener;
    private final transient ActivityHandle activityHandle;

    public CallImpl(CallControlManager manager, IpCall ipCall, int callSessionID, TpCallIdentifier tpCallIdenitifier, ActivityManager activityManager, GccsListener eventListener) {
        this.callControlManager = manager;
        this.ipCall = ipCall;
        this.callSessionID = callSessionID;
        this.tpCallIdentifier = tpCallIdenitifier;
        this.activityManager = activityManager;
        this.activityHandle = new TpCallActivityHandle(this.tpCallIdentifier);
        this.eventListener = eventListener;
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        CallImpl callImpl = this;
        synchronized (callImpl) {
            if (this.callControlManager != null) {
                this.callControlManager.removeCall(this.callSessionID);
                this.callControlManager = null;
            }
            this.eventListener = null;
        }
    }

    public void routeRes(int callSessionID, TpCallReport eventReport, int callLegSessionID) {
        IpCall ipCall = this.getIpCall();
        if (ipCall != null) {
            RouteResEvent event = new RouteResEvent(this.callControlManager.getTpServiceIdentifier(), this.tpCallIdentifier, eventReport, callLegSessionID);
            this.eventListener.onRouteResEvent(event);
        }
    }

    public void routeErr(int callSessionID, TpCallError errorIndication, int callLegSessionID) {
        IpCall ipCall = this.getIpCall();
        if (ipCall != null) {
            RouteErrEvent event = new RouteErrEvent(this.callControlManager.getTpServiceIdentifier(), this.tpCallIdentifier, errorIndication, callLegSessionID);
            this.eventListener.onRouteErrEvent(event);
        }
    }

    public void getCallInfoRes(int callSessionID, TpCallInfoReport callInfoReport) {
        IpCall ipCall = this.getIpCall();
        if (ipCall != null) {
            GetCallInfoResEvent event = new GetCallInfoResEvent(this.callControlManager.getTpServiceIdentifier(), this.tpCallIdentifier, callInfoReport);
            this.eventListener.onGetCallInfoResEvent(event);
        }
    }

    public void getCallInfoErr(int callSessionID, TpCallError errorIndication) {
        IpCall ipCall = this.getIpCall();
        if (ipCall != null) {
            GetCallInfoErrEvent event = new GetCallInfoErrEvent(this.callControlManager.getTpServiceIdentifier(), this.tpCallIdentifier, errorIndication);
            this.eventListener.onGetCallInfoErrEvent(event);
        }
    }

    public void superviseCallRes(int callSessionID, int report, int usedTime) {
        IpCall ipCall = this.getIpCall();
        if (ipCall != null) {
            SuperviseCallResEvent event = new SuperviseCallResEvent(this.callControlManager.getTpServiceIdentifier(), this.tpCallIdentifier, report, usedTime);
            this.eventListener.onSuperviseCallResEvent(event);
        }
    }

    public void superviseCallErr(int callSessionID, TpCallError errorIndication) {
        IpCall ipCall = this.getIpCall();
        if (ipCall != null) {
            SuperviseCallErrEvent event = new SuperviseCallErrEvent(this.callControlManager.getTpServiceIdentifier(), this.tpCallIdentifier, errorIndication);
            this.eventListener.onSuperviseCallErrEvent(event);
        }
    }

    public void callFaultDetected(int callSessionID, TpCallFault fault) {
        IpCall ipCall = this.getIpCall();
        if (ipCall != null) {
            CallFaultDetectedEvent event = new CallFaultDetectedEvent(this.callControlManager.getTpServiceIdentifier(), this.tpCallIdentifier, fault);
            this.eventListener.onCallFaultDetectedEvent(event);
        }
        this.activityManager.remove(this.activityHandle, this.tpCallIdentifier);
        this.activityManager.activityEnding(this.activityHandle);
        this.dispose();
    }

    public void getMoreDialledDigitsRes(int callSessionID, String digits) {
        IpCall ipCall = this.getIpCall();
        if (ipCall != null) {
            GetMoreDialledDigitsResEvent event = new GetMoreDialledDigitsResEvent(this.callControlManager.getTpServiceIdentifier(), this.tpCallIdentifier, digits);
            this.eventListener.onGetMoreDialledDigitsResEvent(event);
        }
    }

    public void getMoreDialledDigitsErr(int callSessionID, TpCallError errorIndication) {
        IpCall ipCall = this.getIpCall();
        if (ipCall != null) {
            GetMoreDialledDigitsErrEvent event = new GetMoreDialledDigitsErrEvent(this.callControlManager.getTpServiceIdentifier(), this.tpCallIdentifier, errorIndication);
            this.eventListener.onGetMoreDialledDigitsErrEvent(event);
        }
    }

    public void callEnded(int callSessionID, TpCallEndedReport report) {
        IpCall ipCall = this.getIpCall();
        if (ipCall != null) {
            CallEndedEvent event = new CallEndedEvent(this.callControlManager.getTpServiceIdentifier(), this.tpCallIdentifier, report);
            this.eventListener.onCallEndedEvent(event);
        }
    }

    public int routeReq(TpCallReportRequest[] responseRequested, TpAddress targetAddress, TpAddress originatingAddress, TpAddress originalDestinationAddress, TpAddress redirectingAddress, TpCallAppInfo[] appInfo) throws TpCommonExceptions, P_INVALID_ADDRESS, P_UNSUPPORTED_ADDRESS_PLAN, P_INVALID_NETWORK_STATE, P_INVALID_CRITERIA, P_INVALID_EVENT_TYPE, ResourceException {
        IpCall call = this.getIpCall();
        int sessionID = 0;
        try {
            sessionID = call.routeReq(this.callSessionID, responseRequested, targetAddress, originatingAddress, originalDestinationAddress, redirectingAddress, appInfo);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(CALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(CALL_NOT_VALID);
        }
        return sessionID;
    }

    public void release(TpCallReleaseCause cause) throws TpCommonExceptions, P_INVALID_NETWORK_STATE, ResourceException {
        IpCall call = this.getIpCall();
        try {
            call.release(this.callSessionID, cause);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(CALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(CALL_NOT_VALID);
        }
        this.activityManager.remove(this.activityHandle, this.tpCallIdentifier);
        this.activityManager.activityEnding(this.activityHandle);
        this.dispose();
    }

    public void deassignCall() throws TpCommonExceptions, ResourceException {
        IpCall call = this.getIpCall();
        try {
            call.deassignCall(this.callSessionID);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(CALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(CALL_NOT_VALID);
        }
        this.activityManager.remove(this.activityHandle, this.tpCallIdentifier);
        this.activityManager.activityEnding(this.activityHandle);
        this.dispose();
    }

    public void getCallInfoReq(int callInfoRequested) throws TpCommonExceptions, ResourceException {
        IpCall call = this.getIpCall();
        try {
            call.getCallInfoReq(this.callSessionID, callInfoRequested);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(CALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(CALL_NOT_VALID);
        }
    }

    public void setCallChargePlan(TpCallChargePlan callChargePlan) throws TpCommonExceptions, ResourceException {
        IpCall call = this.getIpCall();
        try {
            call.setCallChargePlan(this.callSessionID, callChargePlan);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(CALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(CALL_NOT_VALID);
        }
    }

    public void setAdviceOfCharge(TpAoCInfo aOCInfo, int tariffSwitch) throws TpCommonExceptions, ResourceException {
        IpCall call = this.getIpCall();
        try {
            call.setAdviceOfCharge(this.callSessionID, aOCInfo, tariffSwitch);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(CALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(CALL_NOT_VALID);
        }
    }

    public void getMoreDialledDigitsReq(int length) throws TpCommonExceptions, ResourceException {
        IpCall call = this.getIpCall();
        try {
            call.getMoreDialledDigitsReq(this.callSessionID, length);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(CALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(CALL_NOT_VALID);
        }
    }

    public void superviseCallReq(int time, int treatment) throws TpCommonExceptions, ResourceException {
        IpCall call = this.getIpCall();
        try {
            call.superviseCallReq(this.callSessionID, time, treatment);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(CALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(CALL_NOT_VALID);
        }
    }

    public void continueProcessing() throws TpCommonExceptions, P_INVALID_NETWORK_STATE, ResourceException {
        IpCall call = this.getIpCall();
        try {
            call.continueProcessing(this.callSessionID);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(CALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(CALL_NOT_VALID);
        }
    }

    public void closeConnection() throws ResourceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpCall getIpCall() {
        CallImpl callImpl = this;
        synchronized (callImpl) {
            return this.ipCall;
        }
    }

    public TpCallIdentifier getTpCallIdentifier() {
        return this.tpCallIdentifier;
    }

    public ActivityHandle getActivityHandle() {
        return this.activityHandle;
    }

    public org.csapi.cc.gccs.TpCallIdentifier getParlayTpCallIdentifier() {
        return new org.csapi.cc.gccs.TpCallIdentifier(this.ipCall, this.callSessionID);
    }
}

