/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uimanager;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.IpInterface;
import org.csapi.P_INVALID_ASSIGNMENT_ID;
import org.csapi.P_INVALID_CRITERIA;
import org.csapi.P_INVALID_INTERFACE_TYPE;
import org.csapi.P_INVALID_NETWORK_STATE;
import org.csapi.TpAddress;
import org.csapi.TpCommonExceptions;
import org.csapi.ui.IpAppUI;
import org.csapi.ui.IpAppUICall;
import org.csapi.ui.IpAppUICallHelper;
import org.csapi.ui.IpAppUIHelper;
import org.csapi.ui.IpAppUIManager;
import org.csapi.ui.IpAppUIManagerHelper;
import org.csapi.ui.IpUIManager;
import org.csapi.ui.TpUICallIdentifier;
import org.csapi.ui.TpUIEventCriteria;
import org.csapi.ui.TpUIEventCriteriaResult;
import org.csapi.ui.TpUIEventInfo;
import org.csapi.ui.TpUIEventNotificationInfo;
import org.csapi.ui.TpUIIdentifier;
import org.csapi.ui.TpUITargetObject;
import org.mobicents.csapi.jr.slee.InvalidUnionAccessorException;
import org.mobicents.csapi.jr.slee.TpServiceIdentifier;
import org.mobicents.csapi.jr.slee.ui.CallLegUITarget;
import org.mobicents.csapi.jr.slee.ui.CallUITarget;
import org.mobicents.csapi.jr.slee.ui.IpUICallConnection;
import org.mobicents.csapi.jr.slee.ui.IpUIConnection;
import org.mobicents.csapi.jr.slee.ui.MultiPartyCallUITarget;
import org.mobicents.csapi.jr.slee.ui.ReportEventNotificationEvent;
import org.mobicents.csapi.jr.slee.ui.ReportNotificationEvent;
import org.mobicents.csapi.jr.slee.ui.TpUITargetObjectType;
import org.mobicents.csapi.jr.slee.ui.UserInteractionAbortedEvent;
import org.mobicents.csapi.jr.slee.ui.UserInteractionNotificationContinuedEvent;
import org.mobicents.csapi.jr.slee.ui.UserInteractionNotificationInterruptedEvent;
import org.mobicents.slee.resource.parlay.csapi.jr.ParlayServiceActivityHandle;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.call.Call;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.callcontrolmanager.CallControlManager;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.callleg.CallLeg;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycall.MultiPartyCall;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycallcontrolmanager.MultiPartyCallControlManager;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.IpAppUICallImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.IpAppUIImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.IpAppUIManagerImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.IpUICallConnectionImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.IpUIConnectionImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.UiListener;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.ui.AbstractUI;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.ui.UIGeneric;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.ui.UIGenericImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uicall.UICall;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uicall.UICallImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uimanager.UIManager;
import org.mobicents.slee.resource.parlay.fw.FwSession;
import org.mobicents.slee.resource.parlay.session.ParlaySession;
import org.mobicents.slee.resource.parlay.session.ServiceSession;
import org.mobicents.slee.resource.parlay.util.ParlayExceptionUtil;
import org.mobicents.slee.resource.parlay.util.ResourceIDFactory;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;
import org.mobicents.slee.resource.parlay.util.corba.POAFactory;
import org.mobicents.slee.resource.parlay.util.corba.PolicyFactory;
import org.mobicents.slee.resource.parlay.util.corba.ServantActivationHelper;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class UIManagerImpl
implements UIManager {
    private static final Log logger = LogFactory.getLog(UIManagerImpl.class);
    private static final String CALLBACK_FAILED = "Failed to set manager uiback.";
    private final transient Map abstractUiMap;
    private final transient TpServiceIdentifier serviceIdentifier;
    private final transient Executor ipAppUIManagerExecutor;
    private final transient Executor[] ipAppUIExecutors;
    private transient FwSession fwSession;
    private transient ActivityManager activityManager;
    private transient ActivityHandle activityHandle;
    private transient UiListener eventListener;
    private transient POA ipAppUIManagerPOA;
    private transient POA ipAppUIPOA;
    private transient POA ipAppUICallPOA;
    private transient IpAppUIManagerImpl ipAppUIManagerImpl;
    private transient IpAppUIImpl ipAppUIImpl;
    private transient IpAppUICallImpl ipAppUICallImpl;
    private transient IpAppUIManager ipAppUIManager;
    private transient IpAppUI ipAppUI;
    private transient IpAppUICall ipAppUICall;
    private transient IpUIManager ipUIManager;
    private final transient ThreadFactory threadFactory;
    private ParlaySession parlaySession;
    private static final int NUM_EXECUTORS = 20;
    private static final int THREAD_POOL_SIZE = 20;

    public UIManagerImpl(ParlaySession parlaySession, FwSession fwSession, IpUIManager ipUIManager, UiListener eventListener, ActivityManager activityManager, TpServiceIdentifier serviceIdentifier) {
        this.parlaySession = parlaySession;
        this.fwSession = fwSession;
        this.ipUIManager = ipUIManager;
        this.eventListener = eventListener;
        this.activityManager = activityManager;
        this.serviceIdentifier = serviceIdentifier;
        this.abstractUiMap = new HashMap();
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Initialising threadpool with size 20");
        }
        this.ipAppUIManagerExecutor = new PooledExecutor(20);
        this.threadFactory = new ThreadFactory(){
            private ThreadGroup threadGroup = new ThreadGroup("UI-ThreadGroup");
            private final SynchronizedInt i = new SynchronizedInt(0);

            public Thread newThread(Runnable runnable) {
                return new Thread(this.threadGroup, runnable, "UI-Thread-" + this.i.increment());
            }
        };
        ((PooledExecutor)this.ipAppUIManagerExecutor).setThreadFactory(this.threadFactory);
        ((PooledExecutor)this.ipAppUIManagerExecutor).setKeepAliveTime(-1L);
        this.ipAppUIExecutors = new Executor[20];
        for (int i = 0; i < 20; ++i) {
            this.ipAppUIExecutors[i] = new QueuedExecutor();
            ((QueuedExecutor)this.ipAppUIExecutors[i]).setThreadFactory(this.threadFactory);
        }
        this.activityHandle = new ParlayServiceActivityHandle(this.serviceIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ResourceException {
        Policy[] policies = PolicyFactory.createTransientPoaPolicies(this.fwSession.getRootPOA());
        UIManagerImpl uIManagerImpl = this;
        synchronized (uIManagerImpl) {
            this.createPOAs(policies);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Activating servants.");
            }
            this.activateIpAppUI();
            this.activateIpAppUICall();
            this.activateIpAppUIManager();
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoking setCallback on ipUIManager ...");
            }
            try {
                this.ipUIManager.setCallback((IpInterface)this.ipAppUIManager);
            }
            catch (P_INVALID_INTERFACE_TYPE e) {
                logger.error((java.lang.Object)(CALLBACK_FAILED + ParlayExceptionUtil.stringify(e)), (Throwable)e);
                throw new ResourceException(CALLBACK_FAILED, (Throwable)e);
            }
            catch (TpCommonExceptions e) {
                logger.error((java.lang.Object)CALLBACK_FAILED, (Throwable)e);
                throw new ResourceException(CALLBACK_FAILED, (Throwable)e);
            }
            this.activityManager.add(this.activityHandle, this.serviceIdentifier);
            this.activityManager.activityStartedSuspended(this.activityHandle);
        }
    }

    protected void activateIpAppUI() throws ResourceException {
        this.ipAppUIImpl = new IpAppUIImpl(this, this.ipAppUIManagerPOA, this.ipAppUIExecutors);
        try {
            Object tmpRef = ServantActivationHelper.activateServant(this.ipAppUIPOA, (Servant)this.ipAppUIImpl);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Activated ipAppUI.");
            }
            this.ipAppUI = IpAppUIHelper.narrow((Object)tmpRef);
        }
        catch (UserException e) {
            logger.error((java.lang.Object)"Failed to activate ipAppUI.", (Throwable)e);
            throw new ResourceException("Failed to activate ipAppUI.", (Throwable)e);
        }
    }

    protected void activateIpAppUICall() throws ResourceException {
        this.ipAppUICallImpl = new IpAppUICallImpl(this, this.ipAppUIManagerPOA, this.ipAppUIExecutors);
        try {
            Object tmpRef = ServantActivationHelper.activateServant(this.ipAppUICallPOA, (Servant)this.ipAppUICallImpl);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Activated ipAppUICall.");
            }
            this.ipAppUICall = IpAppUICallHelper.narrow((Object)tmpRef);
        }
        catch (UserException e) {
            logger.error((java.lang.Object)"Failed to activate ipAppUICall.", (Throwable)e);
            throw new ResourceException("Failed to activate ipAppUICall.", (Throwable)e);
        }
    }

    protected void activateIpAppUIManager() throws ResourceException {
        this.ipAppUIManagerImpl = new IpAppUIManagerImpl(this, this.ipAppUIManagerPOA, this.ipAppUIManagerExecutor);
        try {
            Object tmpRef = ServantActivationHelper.activateServant(this.ipAppUIManagerPOA, (Servant)this.ipAppUIManagerImpl);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Activated ipAppUIManager.");
            }
            this.ipAppUIManager = IpAppUIManagerHelper.narrow((Object)tmpRef);
        }
        catch (UserException e) {
            logger.error((java.lang.Object)"Failed to activate ipAppUIManager.", (Throwable)e);
            throw new ResourceException("Failed to activate ipAppUIManager.", (Throwable)e);
        }
    }

    protected void createPOAs(Policy[] policies) throws ResourceException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Creating UI POAs.");
            }
            this.ipAppUIManagerPOA = POAFactory.createPOA(this.fwSession.getRootPOA(), "ipAppUIManagerPOA_" + this.serviceIdentifier.getServiceID(), this.fwSession.getRootPOA().the_POAManager(), policies);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("Created ipAppUIManagerPOA_" + this.serviceIdentifier.getServiceID()));
            }
            this.ipAppUICallPOA = POAFactory.createPOA(this.fwSession.getRootPOA(), "ipAppUIPOA_" + this.serviceIdentifier.getServiceID(), this.fwSession.getRootPOA().the_POAManager(), policies);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("Created ipAppUIPOA_" + this.serviceIdentifier.getServiceID()));
            }
            this.ipAppUIPOA = POAFactory.createPOA(this.fwSession.getRootPOA(), "ipAppUICallPOA_" + this.serviceIdentifier.getServiceID(), this.fwSession.getRootPOA().the_POAManager(), policies);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("Created ipAppUICallPOA_" + this.serviceIdentifier.getServiceID()));
            }
        }
        catch (UserException e) {
            logger.error((java.lang.Object)"Failed to initialise POAs.", (Throwable)e);
            throw new ResourceException("Failed to initialise POAs.", (Throwable)e);
        }
    }

    protected void deactivateIpAppUI() {
        if (this.ipAppUIImpl != null) {
            try {
                ServantActivationHelper.deactivateServant((Servant)this.ipAppUIImpl);
            }
            catch (UserException e) {
                logger.error((java.lang.Object)"Failed to deactivate IpAppUI servant.", (Throwable)e);
            }
            this.ipAppUIImpl.dispose();
            this.ipAppUI = null;
            this.ipAppUIImpl = null;
        }
    }

    protected void deactivateIpAppUICall() {
        if (this.ipAppUICallImpl != null) {
            try {
                ServantActivationHelper.deactivateServant((Servant)this.ipAppUICallImpl);
            }
            catch (UserException e) {
                logger.error((java.lang.Object)"Failed to deactivate ipAppUICallImpl servant.", (Throwable)e);
            }
            this.ipAppUICallImpl.dispose();
            this.ipAppUICall = null;
            this.ipAppUICallImpl = null;
        }
    }

    protected void deactivateIpAppUIManager() {
        if (this.ipAppUIManagerImpl != null) {
            try {
                ServantActivationHelper.deactivateServant((Servant)this.ipAppUIManagerImpl);
            }
            catch (UserException e) {
                logger.error((java.lang.Object)"Failed to deactivate IpAppUI servant.", (Throwable)e);
            }
            this.ipAppUIManagerImpl.dispose();
            this.ipAppUIManagerImpl = null;
            this.ipAppUIManager = null;
        }
    }

    public void destroy() {
        this.ipUIManager = null;
        this.ipAppUI = null;
        this.ipAppUICall = null;
        Collection uis = this.abstractUiMap.values();
        for (AbstractUI ui : uis) {
            ui.dispose();
        }
        this.abstractUiMap.clear();
        this.deactivateIpAppUI();
        this.deactivateIpAppUICall();
        this.deactivateIpAppUIManager();
        this.destroyPOAs();
        this.eventListener = null;
    }

    private void destroyPOAs() {
        if (this.ipAppUICallPOA != null) {
            POAFactory.destroyPOA(this.ipAppUICallPOA);
            this.ipAppUICallPOA = null;
        }
        if (this.ipAppUIPOA != null) {
            POAFactory.destroyPOA(this.ipAppUIPOA);
            this.ipAppUIPOA = null;
        }
        if (this.ipAppUIManagerPOA != null) {
            POAFactory.destroyPOA(this.ipAppUIManagerPOA);
            this.ipAppUIManagerPOA = null;
        }
    }

    public AbstractUI getAbstractUI(int uiSessionID) {
        return (AbstractUI)this.abstractUiMap.get(new Integer(uiSessionID));
    }

    public UIGeneric getUIGeneric(int uiSessionID) {
        return (UIGeneric)this.getAbstractUI(uiSessionID);
    }

    public UICall getUICall(int uiSessionID) {
        return (UICall)this.getAbstractUI(uiSessionID);
    }

    public AbstractUI removeUI(int uiSessionID) {
        return (AbstractUI)this.abstractUiMap.remove(new Integer(uiSessionID));
    }

    public void addUI(int uiSessionID, AbstractUI ui) {
        this.abstractUiMap.put(new Integer(uiSessionID), ui);
    }

    public UIGeneric createUIGeneric(TpUIIdentifier corbaTpUIIdentifier) {
        int sleeUiID = ResourceIDFactory.getNextID();
        org.mobicents.csapi.jr.slee.ui.TpUIIdentifier sleeTpUIIdentifier = new org.mobicents.csapi.jr.slee.ui.TpUIIdentifier(sleeUiID, corbaTpUIIdentifier.UserInteractionSessionID);
        UIGenericImpl ui = new UIGenericImpl(this, corbaTpUIIdentifier.UIRef, corbaTpUIIdentifier.UserInteractionSessionID, sleeTpUIIdentifier, this.activityManager, this.eventListener);
        ui.init();
        this.addUI(corbaTpUIIdentifier.UserInteractionSessionID, ui);
        return ui;
    }

    public UICall createUICall(TpUICallIdentifier corbaTpUIIdentifier) {
        int sleeUiID = ResourceIDFactory.getNextID();
        org.mobicents.csapi.jr.slee.ui.TpUICallIdentifier sleeTpUICallIdentifier = new org.mobicents.csapi.jr.slee.ui.TpUICallIdentifier(sleeUiID, corbaTpUIIdentifier.UserInteractionSessionID);
        UICallImpl ui = new UICallImpl(this, corbaTpUIIdentifier.UICallRef, corbaTpUIIdentifier.UserInteractionSessionID, sleeTpUICallIdentifier, this.activityManager, this.eventListener);
        ui.init();
        this.addUI(corbaTpUIIdentifier.UserInteractionSessionID, ui);
        return ui;
    }

    public IpUIConnection getIpUIConnection(org.mobicents.csapi.jr.slee.ui.TpUIIdentifier uiIdentifier) throws ResourceException {
        UIGeneric ui = this.getUIGeneric(uiIdentifier.getUserInteractionSessionID());
        if (ui != null) {
            return new IpUIConnectionImpl(ui);
        }
        throw new ResourceException("Unrecognized TpUIIdentifier");
    }

    public IpUICallConnection getIpUICallConnection(org.mobicents.csapi.jr.slee.ui.TpUICallIdentifier uICallIdentifier) throws ResourceException {
        UICall ui = this.getUICall(uICallIdentifier.getUserInteractionSessionID());
        if (ui != null) {
            return new IpUICallConnectionImpl(ui);
        }
        throw new ResourceException("Unrecognized TpUIIdentifier");
    }

    public void closeConnection() throws ResourceException {
    }

    public IpAppUI getIpAppUI() {
        return this.ipAppUI;
    }

    public IpAppUICall getIpAppUICall() {
        return this.ipAppUICall;
    }

    public TpServiceIdentifier getTpServiceIdentifier() {
        return this.serviceIdentifier;
    }

    public int getType() {
        return 1;
    }

    public IpAppUIImpl getIpAppUIImpl() {
        return this.ipAppUIImpl;
    }

    public IpUIManager getIpUIManager() {
        return this.ipUIManager;
    }

    IpAppUIManager getIpAppUIManager() {
        return this.ipAppUIManager;
    }

    public void userInteractionAborted(TpUIIdentifier userInteraction) {
        IpUIManager uiManager = this.getIpUIManager();
        if (uiManager != null) {
            UserInteractionAbortedEvent event = null;
            AbstractUI uiActivity = this.getAbstractUI(userInteraction.UserInteractionSessionID);
            if (uiActivity != null) {
                if (uiActivity instanceof UIGeneric) {
                    UIGeneric uiGeneric = (UIGeneric)uiActivity;
                    event = new UserInteractionAbortedEvent(this.serviceIdentifier, uiGeneric.getTpUIIdentifier());
                    this.eventListener.onUserInteractionAbortedEvent(event);
                    this.activityManager.remove(uiActivity.getActivityHandle(), uiGeneric.getTpUIIdentifier());
                } else if (uiActivity instanceof UICall) {
                    UICall uiCall = (UICall)uiActivity;
                    event = new UserInteractionAbortedEvent(this.serviceIdentifier, uiCall.getTpUICallIdentifier());
                    this.eventListener.onUserInteractionAbortedEvent(event);
                    this.activityManager.remove(uiActivity.getActivityHandle(), uiCall.getTpUICallIdentifier());
                }
                this.activityManager.activityEnding(uiActivity.getActivityHandle());
                uiActivity.dispose();
            }
        }
    }

    public void reportNotification(org.mobicents.csapi.jr.slee.ui.TpUIIdentifier userInteraction, TpUIEventInfo eventInfo, int assignmentID) {
        if (this.getIpUIManager() != null) {
            UIGeneric ui = this.getUIGeneric(userInteraction.getUserInteractionSessionID());
            if (ui != null) {
                this.activityManager.add(ui.getActivityHandle(), ui.getTpUIIdentifier());
                this.activityManager.activityStarted(ui.getActivityHandle());
            } else {
                UICall uiCall = this.getUICall(userInteraction.getUserInteractionSessionID());
                if (uiCall != null) {
                    this.activityManager.add(uiCall.getActivityHandle(), uiCall.getTpUICallIdentifier());
                    this.activityManager.activityStarted(uiCall.getActivityHandle());
                }
            }
            ReportNotificationEvent event = new ReportNotificationEvent(this.serviceIdentifier, userInteraction, eventInfo, assignmentID);
            this.eventListener.onReportNotificationEvent(event);
        }
    }

    public void userInteractionNotificationInterrupted() {
        IpUIManager uiManager = this.getIpUIManager();
        if (uiManager != null) {
            UserInteractionNotificationInterruptedEvent event = new UserInteractionNotificationInterruptedEvent(this.serviceIdentifier);
            this.eventListener.onUserInteractionNotificationInterruptedEvent(event);
        }
    }

    public void userInteractionNotificationContinued() {
        if (this.getIpUIManager() != null) {
            UserInteractionNotificationContinuedEvent event = new UserInteractionNotificationContinuedEvent(this.serviceIdentifier);
            this.eventListener.onUserInteractionNotificationContinuedEvent(event);
        }
    }

    public void reportEventNotification(org.mobicents.csapi.jr.slee.ui.TpUIIdentifier userInteraction, TpUIEventNotificationInfo eventNotificationInfo, int assignmentID) {
        if (this.getIpUIManager() != null) {
            UIGeneric ui = this.getUIGeneric(userInteraction.getUserInteractionSessionID());
            if (ui != null) {
                this.activityManager.add(ui.getActivityHandle(), ui.getTpUIIdentifier());
                this.activityManager.activityStarted(ui.getActivityHandle());
            } else {
                UICall uiCall = this.getUICall(userInteraction.getUserInteractionSessionID());
                if (uiCall != null) {
                    this.activityManager.add(uiCall.getActivityHandle(), uiCall.getTpUICallIdentifier());
                    this.activityManager.activityStarted(uiCall.getActivityHandle());
                }
            }
            ReportEventNotificationEvent event = new ReportEventNotificationEvent(this.serviceIdentifier, userInteraction, eventNotificationInfo, assignmentID);
            this.eventListener.onReportEventNotificationEvent(event);
        }
    }

    public org.mobicents.csapi.jr.slee.ui.TpUIIdentifier createUI(TpAddress userAddress) throws TpCommonExceptions, P_INVALID_NETWORK_STATE, ResourceException {
        org.mobicents.csapi.jr.slee.ui.TpUIIdentifier result;
        IpUIManager uiManager = this.getIpUIManager();
        if (uiManager != null) {
            try {
                TpUIIdentifier corbaUiReference = uiManager.createUI(this.getIpAppUI(), userAddress);
                UIGeneric generic = this.createUIGeneric(corbaUiReference);
                result = generic.getTpUIIdentifier();
                this.activityManager.add(generic.getActivityHandle(), generic.getTpUIIdentifier());
                this.activityManager.activityStartedSuspended(generic.getActivityHandle());
            }
            catch (P_INVALID_INTERFACE_TYPE e) {
                logger.error((java.lang.Object)ParlayExceptionUtil.stringify(e), (Throwable)e);
                throw new ResourceException("Unexpected Parlay Exception", (Throwable)e);
            }
        } else {
            result = null;
        }
        return result;
    }

    public org.mobicents.csapi.jr.slee.ui.TpUICallIdentifier createUICall(org.mobicents.csapi.jr.slee.ui.TpUITargetObject sleeUiTargetObject) throws TpCommonExceptions, P_INVALID_NETWORK_STATE, ResourceException {
        org.mobicents.csapi.jr.slee.ui.TpUICallIdentifier result = null;
        if (sleeUiTargetObject != null) {
            IpUIManager uiManager = this.getIpUIManager();
            if (uiManager != null) {
                try {
                    TpUICallIdentifier corbaUiReference = uiManager.createUICall(this.getIpAppUICall(), this.getCorbaUITargetObject(sleeUiTargetObject));
                    UICall ui = this.createUICall(corbaUiReference);
                    result = ui.getTpUICallIdentifier();
                    this.activityManager.add(ui.getActivityHandle(), ui.getTpUICallIdentifier());
                    this.activityManager.activityStartedSuspended(ui.getActivityHandle());
                }
                catch (P_INVALID_INTERFACE_TYPE e) {
                    logger.error((java.lang.Object)ParlayExceptionUtil.stringify(e), (Throwable)e);
                    throw new ResourceException("Unexpected Parlay Exception", (Throwable)e);
                }
            }
        } else {
            logger.error((java.lang.Object)"Null TpUITargetObject not allowed.");
            throw new ResourceException("Null TpUITargetObject not allowed.");
        }
        return result;
    }

    public int createNotification(TpUIEventCriteria eventCriteria) throws TpCommonExceptions, P_INVALID_CRITERIA, ResourceException {
        IpUIManager uiManager = this.getIpUIManager();
        int result = 0;
        if (uiManager != null) {
            try {
                result = uiManager.createNotification(this.getIpAppUIManager(), eventCriteria);
            }
            catch (P_INVALID_INTERFACE_TYPE e) {
                logger.error((java.lang.Object)ParlayExceptionUtil.stringify(e), (Throwable)e);
                throw new ResourceException("Unexpected Parlay exception", (Throwable)e);
            }
        }
        return result;
    }

    public void destroyNotification(int assignmentID) throws TpCommonExceptions, P_INVALID_ASSIGNMENT_ID, ResourceException {
        IpUIManager uiManager = this.getIpUIManager();
        if (uiManager != null) {
            uiManager.destroyNotification(assignmentID);
        }
    }

    public void changeNotification(int assignmentID, TpUIEventCriteria eventCriteria) throws TpCommonExceptions, P_INVALID_ASSIGNMENT_ID, P_INVALID_CRITERIA, ResourceException {
        IpUIManager uiManager = this.getIpUIManager();
        if (uiManager != null) {
            uiManager.changeNotification(assignmentID, eventCriteria);
        }
    }

    public TpUIEventCriteriaResult[] getNotification() throws TpCommonExceptions, ResourceException {
        IpUIManager uiManager = this.getIpUIManager();
        TpUIEventCriteriaResult[] result = null;
        if (uiManager != null) {
            result = uiManager.getNotification();
        }
        return result;
    }

    public int enableNotifications() throws TpCommonExceptions, ResourceException {
        IpUIManager uiManager = this.getIpUIManager();
        int result = 0;
        if (uiManager != null) {
            result = uiManager.enableNotifications(this.getIpAppUIManager());
        }
        return result;
    }

    public void disableNotifications() throws TpCommonExceptions, ResourceException {
        IpUIManager uiManager = this.getIpUIManager();
        if (uiManager != null) {
            uiManager.disableNotifications();
        }
    }

    TpUITargetObject getCorbaUITargetObject(org.mobicents.csapi.jr.slee.ui.TpUITargetObject sleeTpUITargetObject) throws ResourceException {
        TpUITargetObject result = new TpUITargetObject();
        try {
            if (sleeTpUITargetObject.getDiscriminator() == TpUITargetObjectType.P_UI_TARGET_OBJECT_CALL) {
                CallUITarget target = sleeTpUITargetObject.getCallUITarget();
                ServiceSession sleeServiceSession = this.parlaySession.getServiceSession(target.getTpServiceIdentifier());
                CallControlManager managerActivity = (CallControlManager)sleeServiceSession;
                Call callActivity = managerActivity.getCall(target.getTpCallIdentifier().getCallSessionID());
                result.Call(callActivity.getParlayTpCallIdentifier());
            } else if (sleeTpUITargetObject.getDiscriminator() == TpUITargetObjectType.P_UI_TARGET_OBJECT_CALL_LEG) {
                CallLegUITarget target = sleeTpUITargetObject.getCallLegUITarget();
                ServiceSession sleeServiceSession = this.parlaySession.getServiceSession(target.getTpServiceIdentifier());
                MultiPartyCallControlManager managerActivity = (MultiPartyCallControlManager)sleeServiceSession;
                MultiPartyCall multiPartyCallActivity = managerActivity.getMultiPartyCall(target.getTpMultiPartyCallIdentifier().getCallSessionID());
                CallLeg callLegActivity = multiPartyCallActivity.getCallLeg(target.getTpCallLegIdentifier().getCallLegSessionID());
                result.CallLeg(callLegActivity.getParlayTpCallLegIdentifier());
            } else if (sleeTpUITargetObject.getDiscriminator() == TpUITargetObjectType.P_UI_TARGET_OBJECT_MULTI_PARTY_CALL) {
                MultiPartyCallUITarget target = sleeTpUITargetObject.getMultiPartyCallUITarget();
                ServiceSession sleeServiceSession = this.parlaySession.getServiceSession(target.getTpServiceIdentifier());
                MultiPartyCallControlManager managerActivity = (MultiPartyCallControlManager)sleeServiceSession;
                MultiPartyCall multiPartyCallActivity = managerActivity.getMultiPartyCall(target.getTpMultiPartyCallIdentifier().getCallSessionID());
                result.MultiPartyCall(multiPartyCallActivity.getParlayTpMultiPartyCallIdentifier());
            }
        }
        catch (InvalidUnionAccessorException e) {
            throw new ResourceException("Could not translate to a CORBA org.csapi.ui.TpUITargetObject", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new ResourceException("Could not translate to a CORBA org.csapi.ui.TpUITargetObject", (Throwable)e);
        }
        return result;
    }
}

