/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.fw.application;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.TpCommonExceptions;
import org.csapi.fw.P_ACCESS_DENIED;
import org.csapi.fw.P_INVALID_AGREEMENT_TEXT;
import org.csapi.fw.P_INVALID_SERVICE_ID;
import org.csapi.fw.P_INVALID_SERVICE_TOKEN;
import org.csapi.fw.P_INVALID_SIGNATURE;
import org.csapi.fw.P_INVALID_SIGNING_ALGORITHM;
import org.csapi.fw.P_SERVICE_ACCESS_DENIED;
import org.csapi.fw.TpSignatureAndServiceMgr;
import org.csapi.fw.fw_application.service_agreement.IpAppServiceAgreementManagement;
import org.csapi.fw.fw_application.service_agreement.IpServiceAgreementManagement;
import org.mobicents.csapi.jr.slee.fw.TerminateServiceAgreementEvent;
import org.mobicents.slee.resource.parlay.fw.FwSessionException;
import org.mobicents.slee.resource.parlay.fw.ServiceAndToken;
import org.mobicents.slee.resource.parlay.fw.access.TSMBean;
import org.mobicents.slee.resource.parlay.fw.application.SABean;
import org.mobicents.slee.resource.parlay.fw.application.SABeanException;
import org.mobicents.slee.resource.parlay.fw.application.SABeanListener;
import org.mobicents.slee.resource.parlay.fw.application.ServiceAgreementCallbackFactory;
import org.mobicents.slee.resource.parlay.util.Convert;
import org.mobicents.slee.resource.parlay.util.crypto.RSAUtil;
import org.mobicents.slee.resource.parlay.util.crypto.RSAUtilException;
import org.omg.CORBA.SystemException;

public class SABeanImpl
implements Serializable,
SABean {
    private static final Log logger = LogFactory.getLog(SABeanImpl.class);
    private static final String EXCEPTION_INVOKING = "Exception invoking ";
    private static final String SERVICE_AGREEMENT_MANAGEMENT = "org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement";
    private static final String SELECT_SERVICE = ".selectService()";
    private static final String INITIATE_SIGN_SERVICE_AGREEMENT = ".initiateSignServiceAgreement()";
    private static final String SIGN_SERVICE_AGREEMENT = ".signServiceAgreement()";
    private static final String TERMINATE_SERVICE_AGREEMENT = ".terminateServiceAgreement()";
    private static final String INVOKING = "Invoking ";
    private static final String INVOKED = "Invoked ";
    private static final String NO_SIGNING_ALGORITHM = "No signing algorithm for token ";
    private Hashtable serviceTokenSigningAlgorithmTable;
    private transient Vector SABeanListeners;
    private IpServiceAgreementManagement serviceAgreementManagement = null;
    private IpAppServiceAgreementManagement appServiceAgreementManagement = null;
    private ServiceAgreementCallbackFactory factory = null;
    private boolean clean = false;
    private Object serviceAgreementMonitor = new Object();
    private boolean isAgreementSigned = false;
    private long signServiceAgreementTimeout = Integer.MIN_VALUE;
    private TSMBean tsmBean = null;

    public SABeanImpl(TSMBean tsmBean) {
        this.serviceTokenSigningAlgorithmTable = new Hashtable();
        this.SABeanListeners = new Vector();
        this.tsmBean = tsmBean;
        this.signServiceAgreementTimeout = tsmBean.getFwProperties().getSsaTimeout();
    }

    public void initialise() throws SABeanException {
        if (this.tsmBean != null) {
            this.factory = new ServiceAgreementCallbackFactory(this.tsmBean.getOrbHandler());
            try {
                this.appServiceAgreementManagement = this.factory.createIpAppServiceAgreementManagement(this);
            }
            catch (FwSessionException ex) {
                logger.warn((Object)("Exception activating an appServiceAgreementManagement callback " + ex.toString()));
                throw new SABeanException("Exception activating an appServiceAgreementManagement callback ", ex);
            }
        }
    }

    public synchronized void setServiceAgreementManagement(IpServiceAgreementManagement newServiceAgreementManagement) {
        this.serviceAgreementManagement = newServiceAgreementManagement;
    }

    public synchronized IpServiceAgreementManagement getServiceAgreementManagement() {
        return this.serviceAgreementManagement;
    }

    public synchronized IpAppServiceAgreementManagement getAppServiceAgreementManagement() {
        return this.appServiceAgreementManagement;
    }

    public Object getServiceAgreementMonitor() {
        return this.serviceAgreementMonitor;
    }

    public void setIsAgreementSigned(boolean value) {
        this.isAgreementSigned = value;
    }

    public synchronized void removeSABeanListener(SABeanListener l) {
        if (this.SABeanListeners != null && this.SABeanListeners.contains(l)) {
            Vector v = (Vector)this.SABeanListeners.clone();
            v.removeElement(l);
            this.SABeanListeners = v;
        }
    }

    public synchronized void addSABeanListener(SABeanListener l) {
        Vector v;
        Vector vector = v = this.SABeanListeners == null ? new Vector(2) : (Vector)this.SABeanListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.SABeanListeners = v;
        }
    }

    public synchronized ServiceAndToken selectAndSignServiceAgreement(String serviceID, String agreementText) throws SABeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"SABean.selectAndSignServiceAgreement() called.");
        }
        ServiceAndToken result = null;
        if (this.serviceAgreementManagement == null) {
            throw new SABeanException("This bean cannot be used, org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement ref missing");
        }
        result = this.selectAndSignWithGateway(serviceID, agreementText);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceAndToken selectAndSignWithGateway(String serviceID, String agreementText) throws SABeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Selecting and signing with Gateway.");
        }
        String serviceToken = this.selectService(serviceID);
        Object object = this.getServiceAgreementMonitor();
        synchronized (object) {
            this.initiateSignServiceAgreement(serviceToken);
            while (!this.isAgreementSigned) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Waiting for signServiceAgreement() message.");
                    }
                    this.getServiceAgreementMonitor().wait(this.signServiceAgreementTimeout);
                }
                catch (InterruptedException ex) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)"Interrupted.");
                }
            }
            this.setIsAgreementSigned(false);
        }
        String signingAlgorithm = this.getSigningAlgorithm(serviceToken);
        if (signingAlgorithm == null) {
            logger.warn((Object)(NO_SIGNING_ALGORITHM + serviceToken));
            throw new SABeanException(NO_SIGNING_ALGORITHM + serviceToken);
        }
        TpSignatureAndServiceMgr signatureAndServiceMgr = this.signServiceAgreement(serviceToken, agreementText, signingAlgorithm);
        ServiceAndToken result = new ServiceAndToken(signatureAndServiceMgr.ServiceMgrInterface, serviceToken);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning :" + result));
        }
        return result;
    }

    private String selectService(String serviceID) throws SABeanException {
        String serviceToken = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.selectService()");
                logger.debug((Object)("Service ID = " + serviceID));
            }
            serviceToken = this.serviceAgreementManagement.selectService(serviceID);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoked org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.selectService()");
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.selectService() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.selectService()", (Exception)((Object)ex));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.selectService() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.selectService()", (Exception)((Object)ex));
        }
        catch (P_INVALID_SERVICE_ID ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.selectService() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.selectService()", (Exception)((Object)ex));
        }
        catch (P_SERVICE_ACCESS_DENIED ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.selectService() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.selectService()", (Exception)((Object)ex));
        }
        return serviceToken;
    }

    private void initiateSignServiceAgreement(String serviceToken) throws SABeanException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.initiateSignServiceAgreement()");
                logger.debug((Object)("Service Token = " + serviceToken));
            }
            this.serviceAgreementManagement.initiateSignServiceAgreement(serviceToken);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoked org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.initiateSignServiceAgreement()");
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.initiateSignServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.initiateSignServiceAgreement()", (Exception)((Object)ex));
        }
        catch (P_INVALID_SERVICE_TOKEN ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.initiateSignServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.initiateSignServiceAgreement()", (Exception)((Object)ex));
        }
        catch (P_SERVICE_ACCESS_DENIED ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.initiateSignServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.initiateSignServiceAgreement()", (Exception)((Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.initiateSignServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.initiateSignServiceAgreement()", (Exception)((Object)ex));
        }
    }

    private TpSignatureAndServiceMgr signServiceAgreement(String serviceToken, String agreementText, String signingAlgorithm) throws SABeanException {
        TpSignatureAndServiceMgr signatureAndServiceMgr = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement()");
                logger.debug((Object)("Service Token = " + serviceToken));
                logger.debug((Object)("Agreement Text = " + agreementText));
                logger.debug((Object)("Signing Algorithm = " + signingAlgorithm));
            }
            signatureAndServiceMgr = this.serviceAgreementManagement.signServiceAgreement(serviceToken, agreementText, signingAlgorithm);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoked org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement()");
            }
            this.verifyDigitalSignature(agreementText, serviceToken, signingAlgorithm, signatureAndServiceMgr.DigitalSignature);
        }
        catch (TpCommonExceptions ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement()", (Exception)((Object)ex));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement()", (Exception)((Object)ex));
        }
        catch (P_INVALID_AGREEMENT_TEXT ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement()", (Exception)((Object)ex));
        }
        catch (P_INVALID_SERVICE_TOKEN ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement()", (Exception)((Object)ex));
        }
        catch (P_INVALID_SIGNING_ALGORITHM ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement()", (Exception)((Object)ex));
        }
        catch (P_SERVICE_ACCESS_DENIED ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement()", (Exception)((Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.signServiceAgreement()", (Exception)((Object)ex));
        }
        return signatureAndServiceMgr;
    }

    public synchronized void terminateServiceAgreement(String serviceToken, String terminationText) throws SABeanException {
        String signingAlgorithm;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"SABean.terminateServiceAgreement() called.");
        }
        if ((signingAlgorithm = this.getSigningAlgorithm(serviceToken)) == null) {
            logger.warn((Object)(NO_SIGNING_ALGORITHM + serviceToken));
            throw new SABeanException(NO_SIGNING_ALGORITHM + serviceToken);
        }
        byte[] digitalSignature = this.generateDigitalSignature(terminationText, serviceToken, signingAlgorithm);
        this.terminateServiceAgreement(serviceToken, terminationText, digitalSignature);
        this.removeSigningAlgorithm(serviceToken);
    }

    private void terminateServiceAgreement(String serviceToken, String terminationText, byte[] digitalSignature) throws SABeanException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.terminateServiceAgreement()");
                logger.debug((Object)("Service Token = " + serviceToken));
                logger.debug((Object)("Termination Text = " + terminationText));
                logger.debug((Object)("Digintal Signature = " + Convert.toHexString(digitalSignature)));
            }
            this.serviceAgreementManagement.terminateServiceAgreement(serviceToken, terminationText, digitalSignature);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoked org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.terminateServiceAgreement()");
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.terminateServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.terminateServiceAgreement()", (Exception)((Object)ex));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.terminateServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.terminateServiceAgreement()", (Exception)((Object)ex));
        }
        catch (P_INVALID_SERVICE_TOKEN ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.terminateServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.terminateServiceAgreement()", (Exception)((Object)ex));
        }
        catch (P_INVALID_SIGNATURE ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.terminateServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.terminateServiceAgreement()", (Exception)((Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((Object)("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.terminateServiceAgreement() " + ex.toString()));
            throw new SABeanException("Exception invoking org::csapi::jr::fw::fwapplication::service_agreement::IpServiceAgreementManagement.terminateServiceAgreement()", (Exception)((Object)ex));
        }
    }

    public void fireTerminateServiceAgreement(TerminateServiceAgreementEvent e) {
        if (this.SABeanListeners != null) {
            Vector listeners = this.SABeanListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                try {
                    ((SABeanListener)listeners.elementAt(i)).terminateServiceAgreement(e);
                    continue;
                }
                catch (RuntimeException ex) {
                    logger.error((Object)("Caught exception invoking application SABeanListener " + ex.toString()));
                }
            }
        }
    }

    public synchronized void cleanup() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cleaning up " + this.toString()));
        }
        if (!this.clean) {
            block4: {
                this.serviceAgreementManagement = null;
                try {
                    this.factory.deactivateIpAppServiceAgreementManagement();
                }
                catch (FwSessionException e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("Exception deactivating IpAppServiceAgreementManagement" + e));
                }
            }
            this.appServiceAgreementManagement = null;
            this.serviceTokenSigningAlgorithmTable.clear();
            this.factory.destroy();
            this.tsmBean = null;
            this.clean = true;
        }
    }

    public String removeSigningAlgorithm(String serviceToken) {
        return (String)this.serviceTokenSigningAlgorithmTable.remove(serviceToken);
    }

    private String getSigningAlgorithm(String serviceToken) {
        return (String)this.serviceTokenSigningAlgorithmTable.get(serviceToken);
    }

    public void putServiceTokenSigningAlgorithm(String serviceToken, String signingAlgorithm) {
        this.serviceTokenSigningAlgorithmTable.put(serviceToken, signingAlgorithm);
    }

    public byte[] generateDigitalSignature(String text, String serviceToken, String signingAlgorithm) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Generating a digital signature.");
            logger.debug((Object)("Text = " + text));
            logger.debug((Object)("Token = " + serviceToken));
            logger.debug((Object)("Algorithm = " + signingAlgorithm));
        }
        PrivateKey privateKey = null;
        byte[] result = null;
        Signature signature = null;
        if ((signingAlgorithm.equals("P_MD5_RSA_512") || signingAlgorithm.equals("P_MD5_RSA_1024")) && (this.tsmBean.getFwProperties().getAuthenticationSequence().getType().equals("TWO_WAY") || this.tsmBean.getFwProperties().getAuthenticationSequence().getType().equals("ONE_WAY"))) {
            try {
                privateKey = RSAUtil.getPrivateKey(this.tsmBean.getClientID());
            }
            catch (RSAUtilException ex) {
                logger.error((Object)"Exception caught obtaining private key.", (Throwable)ex);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Using DigestInfo to generate Digital Signature");
            }
            try {
                signature = Signature.getInstance("MD5withRSA");
                signature.initSign(privateKey);
                signature.update(text.getBytes("ISO-8859-1"));
                signature.update(serviceToken.getBytes("ISO-8859-1"));
                result = signature.sign();
            }
            catch (NoSuchAlgorithmException ex) {
                logger.error((Object)"NoSuchAlgorithmException caught:", ex.fillInStackTrace());
            }
            catch (InvalidKeyException ex) {
                logger.error((Object)"InvalidKeyException caught:", ex.fillInStackTrace());
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((Object)"UnsupportedEncodingException caught:", ex.fillInStackTrace());
            }
            catch (SignatureException ex) {
                logger.error((Object)"SignatureException caught:", ex.fillInStackTrace());
            }
        } else {
            try {
                result = signingAlgorithm.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"UnsupportedEncodingException caught generating digital signature.", (Throwable)e);
            }
        }
        return result;
    }

    public boolean verifyDigitalSignature(String text, String serviceToken, String signingAlgorithm, byte[] digitalSignature) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Verifying a digital signature.");
            logger.debug((Object)("Text = " + text));
            logger.debug((Object)("Token = " + serviceToken));
            logger.debug((Object)("Algorithm = " + signingAlgorithm));
        }
        return false;
    }

    public TSMBean getTSMBean() {
        return this.tsmBean;
    }
}

