/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.util.activity;

import java.util.HashMap;
import java.util.Map;
import javax.slee.UnrecognizedActivityException;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.CouldNotStartActivityException;
import javax.slee.resource.SleeEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;

public class ActivityManagerImpl
implements ActivityManager {
    private static final String FAILED_ENDING_SLEE_ACTIVITY = "Failed ending SLEE activity.";
    private static final String FAILED_STARTING_SLEE_ACTIVITY = "Failed starting SLEE activity.";
    private static final Log logger = LogFactory.getLog(ActivityManagerImpl.class);
    private final transient SleeEndpoint sleeEndpoint;
    private final transient Map activities;
    private final transient Map handles;

    public ActivityManagerImpl(SleeEndpoint sleeEndpoint) {
        this.sleeEndpoint = sleeEndpoint;
        this.activities = new HashMap();
        this.handles = new HashMap();
    }

    public void activityEnded(ActivityHandle activityHandle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Received activityEnded()");
        }
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Received activityUnreferenced()");
        }
    }

    public void queryLiveness(ActivityHandle activityHandle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Received queryLiveness()");
        }
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return this.activities.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        return (ActivityHandle)this.handles.get(activity);
    }

    public void activityStarted(ActivityHandle activityHandle) {
        try {
            this.sleeEndpoint.activityStarted(activityHandle);
        }
        catch (NullPointerException e) {
            logger.error((Object)FAILED_STARTING_SLEE_ACTIVITY, (Throwable)e);
        }
        catch (IllegalStateException e) {
            logger.error((Object)FAILED_STARTING_SLEE_ACTIVITY, (Throwable)e);
        }
        catch (ActivityAlreadyExistsException e) {
            logger.error((Object)FAILED_STARTING_SLEE_ACTIVITY, (Throwable)e);
        }
        catch (CouldNotStartActivityException e) {
            logger.error((Object)FAILED_STARTING_SLEE_ACTIVITY, (Throwable)e);
        }
    }

    public void activityStartedSuspended(ActivityHandle activityHandle) {
        try {
            this.sleeEndpoint.activityStartedSuspended(activityHandle);
        }
        catch (NullPointerException e) {
            logger.error((Object)FAILED_STARTING_SLEE_ACTIVITY, (Throwable)e);
        }
        catch (IllegalStateException e) {
            logger.error((Object)FAILED_STARTING_SLEE_ACTIVITY, (Throwable)e);
        }
        catch (ActivityAlreadyExistsException e) {
            logger.error((Object)FAILED_STARTING_SLEE_ACTIVITY, (Throwable)e);
        }
        catch (CouldNotStartActivityException e) {
            logger.error((Object)FAILED_STARTING_SLEE_ACTIVITY, (Throwable)e);
        }
    }

    public void activityEnding(ActivityHandle activityHandle) {
        try {
            this.sleeEndpoint.activityEnding(activityHandle);
        }
        catch (NullPointerException e) {
            logger.error((Object)FAILED_ENDING_SLEE_ACTIVITY, (Throwable)e);
        }
        catch (IllegalStateException e) {
            logger.error((Object)FAILED_ENDING_SLEE_ACTIVITY, (Throwable)e);
        }
        catch (UnrecognizedActivityException e) {
            logger.error((Object)FAILED_ENDING_SLEE_ACTIVITY, (Throwable)e);
        }
    }

    public void add(ActivityHandle handle, Object activity) {
        this.activities.put(handle, activity);
        this.handles.put(activity, handle);
    }

    public void remove(ActivityHandle handle, Object activity) {
        this.activities.remove(handle);
        this.handles.remove(activity);
    }
}

