/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.util.corba;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class ServantActivationHelper {
    private static final String ERROR_GETTING_OBJECT_REFERENCE = "Error getting object reference, this should not happen!";
    private static final Log logger = LogFactory.getLog(ServantActivationHelper.class);

    public static Object activateServantWithID(POA poa, Servant servant, byte[] oid) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        Object corbaObject = null;
        poa.activate_object_with_id(oid, servant);
        try {
            corbaObject = poa.id_to_reference(oid);
        }
        catch (ObjectNotActive e) {
            logger.fatal((java.lang.Object)ERROR_GETTING_OBJECT_REFERENCE);
        }
        catch (WrongPolicy e) {
            logger.fatal((java.lang.Object)ERROR_GETTING_OBJECT_REFERENCE);
        }
        return corbaObject;
    }

    public static Object activateServant(POA poa, Servant servant) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        Object corbaObject = null;
        byte[] oid = poa.activate_object(servant);
        try {
            corbaObject = poa.id_to_reference(oid);
        }
        catch (ObjectNotActive e) {
            logger.fatal((java.lang.Object)ERROR_GETTING_OBJECT_REFERENCE);
        }
        catch (WrongPolicy e) {
            logger.fatal((java.lang.Object)ERROR_GETTING_OBJECT_REFERENCE);
        }
        return corbaObject;
    }

    public static void deactivateServant(Servant servant) throws ObjectNotActive, WrongPolicy, ServantNotActive {
        servant._default_POA().deactivate_object(servant._default_POA().servant_to_id(servant));
    }

    public static void deactivateServant(POA poa, byte[] oid) throws ObjectNotActive, WrongPolicy {
        poa.deactivate_object(oid);
    }
}

