/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.csapi.jr.ui;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import org.apache.log4j.Logger;
import org.csapi.ui.IpAppUIOperations;
import org.csapi.ui.TpUIError;
import org.csapi.ui.TpUIFault;
import org.csapi.ui.TpUIReport;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uimanager.UIManager;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.eventHandlers.SendInfoAndCollectErrHandler;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.eventHandlers.SendInfoAndCollectResHandler;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.eventHandlers.SendInfoErrHandler;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.eventHandlers.SendInfoResHandler;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.eventHandlers.UserInteractionFaultDetectedHandler;

public class IpAppUIOperationsDelegate
implements IpAppUIOperations {
    private static final Logger logger = Logger.getLogger(IpAppUIOperationsDelegate.class);
    private final transient UIManager uiManager;
    private final transient Executor[] executors;

    public IpAppUIOperationsDelegate(UIManager uiManager, Executor[] executors) {
        this.uiManager = uiManager;
        this.executors = executors;
    }

    public void sendInfoRes(int userInteractionSessionID, int assignmentID, TpUIReport response) {
        SendInfoResHandler handler = new SendInfoResHandler(this.uiManager, userInteractionSessionID, assignmentID, response);
        try {
            this.executors[userInteractionSessionID % this.executors.length].execute((Runnable)handler);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted handling sendInfoRes");
        }
    }

    public void sendInfoErr(int userInteractionSessionID, int assignmentID, TpUIError error) {
        SendInfoErrHandler handler = new SendInfoErrHandler(this.uiManager, userInteractionSessionID, assignmentID, error);
        try {
            this.executors[userInteractionSessionID % this.executors.length].execute((Runnable)handler);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted handling sendInfoErr");
        }
    }

    public void sendInfoAndCollectRes(int userInteractionSessionID, int assignmentID, TpUIReport response, String collectedInfo) {
        SendInfoAndCollectResHandler handler = new SendInfoAndCollectResHandler(this.uiManager, userInteractionSessionID, assignmentID, response, collectedInfo);
        try {
            this.executors[userInteractionSessionID % this.executors.length].execute((Runnable)handler);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted handling sendInfoAndCollectRes");
        }
    }

    public void sendInfoAndCollectErr(int userInteractionSessionID, int assignmentID, TpUIError error) {
        SendInfoAndCollectErrHandler handler = new SendInfoAndCollectErrHandler(this.uiManager, userInteractionSessionID, assignmentID, error);
        try {
            this.executors[userInteractionSessionID % this.executors.length].execute((Runnable)handler);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted handling sendInfoAndCollectErr");
        }
    }

    public void userInteractionFaultDetected(int userInteractionSessionID, TpUIFault fault) {
        UserInteractionFaultDetectedHandler handler = new UserInteractionFaultDetectedHandler(this.uiManager, userInteractionSessionID, fault);
        try {
            this.executors[userInteractionSessionID % this.executors.length].execute((Runnable)handler);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted handling userInteractionFaultDetected");
        }
    }
}

