/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay;

import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.resource.BootstrapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mobicents.csapi.jr.slee.ParlayConnection;
import org.mobicents.slee.resource.parlay.ParlayProvider;
import org.mobicents.slee.resource.parlay.ParlayResourceAdaptorProperties;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.GccsListenerImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.MpccsListenerImpl;
import org.mobicents.slee.resource.parlay.jca.ManagedConnectionFactoryImpl;
import org.mobicents.slee.resource.parlay.jca.ResourceAdapter;
import org.mobicents.slee.resource.parlay.jca.ResourceAdapterImpl;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;
import org.mobicents.slee.resource.parlay.util.event.EventSenderImpl;

public class ParlayProviderImpl
implements ParlayProvider {
    private static final Log logger = LogFactory.getLog(ParlayProviderImpl.class);
    private final transient ManagedConnectionFactoryImpl managedConnectionFactory;
    private transient ResourceAdapter resourceAdapterImpl = null;
    private transient ConnectionFactory connectionFactory = null;
    private final transient BootstrapContext bootstrapContext;
    private final transient ActivityManager activityManager;

    public ParlayProviderImpl(BootstrapContext bootstrapContext, ParlayResourceAdaptorProperties adaptorProperties, ActivityManager activityManager) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Creating ParlayProvider.");
            logger.debug((Object)("Properties = " + adaptorProperties));
        }
        this.bootstrapContext = bootstrapContext;
        this.activityManager = activityManager;
        this.resourceAdapterImpl = new ResourceAdapterImpl();
        this.resourceAdapterImpl.setAuthenticationSequence(adaptorProperties.getAuthenticationSequence());
        this.resourceAdapterImpl.setDomainID(adaptorProperties.getDomainID());
        this.resourceAdapterImpl.setIpInitialIOR(adaptorProperties.getIpInitialIOR());
        this.resourceAdapterImpl.setIpInitialLocation(adaptorProperties.getIpInitialLocation());
        this.resourceAdapterImpl.setIpInitialURL(adaptorProperties.getIpInitialURL());
        this.resourceAdapterImpl.setNamingServiceIOR(adaptorProperties.getNamingServiceIOR());
        this.resourceAdapterImpl.setParlayVersion(adaptorProperties.getParlayVersion());
        this.resourceAdapterImpl.setSharedSecret(adaptorProperties.getSharedSecret());
        this.managedConnectionFactory = new ManagedConnectionFactoryImpl();
        this.managedConnectionFactory.setAuthenticationSequence(adaptorProperties.getAuthenticationSequence());
        this.managedConnectionFactory.setDomainID(adaptorProperties.getDomainID());
        this.managedConnectionFactory.setIpInitialIOR(adaptorProperties.getIpInitialIOR());
        this.managedConnectionFactory.setIpInitialLocation(adaptorProperties.getIpInitialLocation());
        this.managedConnectionFactory.setIpInitialURL(adaptorProperties.getIpInitialURL());
        this.managedConnectionFactory.setNamingServiceIOR(adaptorProperties.getNamingServiceIOR());
    }

    public void start() throws javax.slee.resource.ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting ParlayProvider.");
        }
        Address address = new Address(AddressPlan.SIP, "127.0.0.1");
        EventSenderImpl eventSender = new EventSenderImpl(this.bootstrapContext.getEventLookupFacility(), this.bootstrapContext.getSleeEndpoint(), address);
        MpccsListenerImpl mpccsListener = new MpccsListenerImpl(eventSender);
        this.resourceAdapterImpl.setMpccsListener(mpccsListener);
        GccsListenerImpl gccsListener = new GccsListenerImpl(eventSender);
        this.resourceAdapterImpl.setGccsListener(gccsListener);
        this.resourceAdapterImpl.setActivityManager(this.activityManager);
        try {
            this.managedConnectionFactory.setResourceAdapter(this.resourceAdapterImpl);
        }
        catch (ResourceException e) {
            logger.error((Object)"Failed to setResourceAdapter() on managedConnectionFactory", (Throwable)e);
            throw new javax.slee.resource.ResourceException("Failed to setResourceAdapter() on managedConnectionFactory", (Throwable)e);
        }
        this.startResourceAdapter();
        try {
            this.connectionFactory = (ConnectionFactory)this.managedConnectionFactory.createConnectionFactory();
        }
        catch (ResourceException e) {
            logger.error((Object)"Failed to createConnectionFactory() on managedConnectionFactory", (Throwable)e);
            throw new javax.slee.resource.ResourceException("Failed to createConnectionFactory() on managedConnectionFactory", (Throwable)e);
        }
    }

    protected void startResourceAdapter() throws javax.slee.resource.ResourceException {
        try {
            this.resourceAdapterImpl.start(null);
        }
        catch (ResourceAdapterInternalException e) {
            logger.error((Object)"Failed to start() on resourceAdapterImpl", (Throwable)e);
            throw new javax.slee.resource.ResourceException("Failed to start provider, internal resource error");
        }
    }

    public ParlayConnection getParlayConnection() throws javax.slee.resource.ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Attempting to getParlayConnection()");
        }
        if (this.connectionFactory == null) {
            throw new javax.slee.resource.ResourceException("Cannot allocate connection - no ConnectionFactory");
        }
        try {
            return (ParlayConnection)this.connectionFactory.getConnection();
        }
        catch (ResourceException e) {
            logger.error((Object)"Failed to getParlayConnection()", (Throwable)e);
            throw new javax.slee.resource.ResourceException("Failed to getParlayConnection()", (Throwable)e);
        }
    }

    public void stop() throws javax.slee.resource.ResourceException {
        block3: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Stopping ParlayProvider.");
            }
            this.connectionFactory = null;
            this.resourceAdapterImpl.stop();
            try {
                this.managedConnectionFactory.setResourceAdapter(null);
            }
            catch (ResourceException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)"Problem stopping Parlay Resources.", (Throwable)e);
            }
        }
    }

    public void setResourceAdapterImpl(ResourceAdapter resourceAdapterImpl) {
        this.resourceAdapterImpl = resourceAdapterImpl;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

