/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip;

import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.ServerTransaction;
import javax.slee.ActivityContextInterface;
import javax.slee.FactoryException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.resource.ActivityHandle;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.SleeActivityHandle;
import org.mobicents.slee.resource.sip.SipActivityContextInterfaceFactory;
import org.mobicents.slee.resource.sip.SipActivityHandle;
import org.mobicents.slee.resource.sip.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip.wrappers.ServerTransactionWrapper;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextFactory;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;

public class SipActivityContextInterfaceFactoryImpl
implements SipActivityContextInterfaceFactory,
ResourceAdaptorActivityContextInterfaceFactory {
    private final String jndiName;
    private String raEntityName;
    private SleeContainer serviceContainer;
    private ActivityContextFactory activityContextFactory;

    public SipActivityContextInterfaceFactoryImpl(SleeContainer svcContainer, String entityName) {
        this.serviceContainer = svcContainer;
        this.activityContextFactory = svcContainer.getActivityContextFactory();
        this.raEntityName = entityName;
        this.jndiName = "java:slee/resources/" + entityName + "/sipacif";
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public ActivityContextInterface getActivityContextInterface(ClientTransaction clientTransaction) throws NullPointerException, UnrecognizedActivityException, FactoryException {
        if (clientTransaction == null) {
            throw new NullPointerException("sip activity ! huh!!");
        }
        ActivityContext AC = this.getActivityContextForActivity(clientTransaction);
        return new ActivityContextInterfaceImpl(this.serviceContainer, AC.getActivityContextId());
    }

    public ActivityContextInterface getActivityContextInterface(ServerTransaction serverTransaction) throws NullPointerException, UnrecognizedActivityException, FactoryException {
        if (serverTransaction == null) {
            throw new NullPointerException("sip activity ! huh!!");
        }
        ActivityContext AC = this.getActivityContextForActivity(serverTransaction);
        return new ActivityContextInterfaceImpl(this.serviceContainer, AC.getActivityContextId());
    }

    public ActivityContextInterface getActivityContextInterface(Dialog dialog) throws NullPointerException, UnrecognizedActivityException, FactoryException {
        if (dialog == null) {
            throw new NullPointerException("sip activity ! huh!!");
        }
        ActivityContext AC = this.getActivityContextForActivity(dialog);
        return new ActivityContextInterfaceImpl(this.serviceContainer, AC.getActivityContextId());
    }

    private ActivityContext getActivityContextForActivity(Object activity) {
        SipActivityHandle SAH = null;
        if (activity instanceof ServerTransactionWrapper) {
            SAH = ((ServerTransactionWrapper)activity).getActivityHandle();
        } else if (activity instanceof ClientTransactionWrapper) {
            SAH = ((ClientTransactionWrapper)activity).getActivityHandle();
        } else if (activity instanceof DialogWrapper) {
            SAH = ((DialogWrapper)activity).getActivityHandle();
        } else {
            throw new ClassCastException(" Activity does not implement javax.sip.Dialog or javax.sip.Transaction!!!");
        }
        SleeActivityHandle SLAH = new SleeActivityHandle(this.raEntityName, (ActivityHandle)SAH, this.serviceContainer);
        ActivityContext AC = this.activityContextFactory.getActivityContext((Object)SLAH);
        return AC;
    }
}

