/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip;

import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPRequest;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.AddressFactory;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.EventTypeID;
import javax.slee.InvalidStateException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.EventTypeIDImpl;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorState;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.sip.SipActivityContextInterfaceFactory;
import org.mobicents.slee.resource.sip.SipActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.sip.SipActivityHandle;
import org.mobicents.slee.resource.sip.SipFactoryProvider;
import org.mobicents.slee.resource.sip.SipProviderProxy;
import org.mobicents.slee.resource.sip.SipToSLEEUtility;
import org.mobicents.slee.resource.sip.mbean.SipRaConfiguration;
import org.mobicents.slee.resource.sip.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip.wrappers.DialogTerminatedEventWrapper;
import org.mobicents.slee.resource.sip.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip.wrappers.RequestEventWrapper;
import org.mobicents.slee.resource.sip.wrappers.ResponseEventWrapper;
import org.mobicents.slee.resource.sip.wrappers.SecretWrapperInterface;
import org.mobicents.slee.resource.sip.wrappers.ServerTransactionWrapper;
import org.mobicents.slee.resource.sip.wrappers.TimeoutEventWrapper;
import org.mobicents.slee.resource.sip.wrappers.TransactionTerminatedEventWrapper;
import org.mobicents.slee.runtime.ActivityContextFactory;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class SipResourceAdaptor
implements SipListener,
ResourceAdaptor,
Serializable {
    private static transient Logger log = Logger.getLogger(SipResourceAdaptor.class);
    private static final String SIP_BIND_ADDRESS = "javax.sip.IP_ADDRESS";
    private static final String SIP_PORT_BIND = "javax.sip.PORT";
    private static final String CANCEL_WAIT_BIND = "net.java.CANCEL_WAIT";
    private static final String DIALOG_TIMEOUT_BIND = "net.java.DIALOG_TIMEOUT";
    private static final String DIALOG_AUTOMATIC_CREATION_BIND = "net.java.AUTOMATIC_DIALOG_SUPPORT";
    private static final String TRANSPORTS_BIND = "javax.sip.TRANSPORT";
    private static final String STACK_NAME_BIND = "javax.sip.STACK_NAME";
    private int port = 5060;
    private Set transports = new HashSet();
    private Set allowedTransports = new HashSet();
    private String stackAddress = "0.0.0.0";
    private String stackPrefix = "gov.nist";
    private transient SipProvider provider;
    private transient SipStack sipStack = null;
    private transient SipFactory sipFactory = null;
    private transient SipFactoryProvider sipFactoryProvider;
    private boolean automaticDialogSupport;
    private boolean createDialogAutomaticly;
    private long dialogTimeout = 30000L;
    private long cancelWait = 1000L;
    private static Set rfc3261Methods = new HashSet();
    private transient Map activities = null;
    private transient SipActivityContextInterfaceFactory acif;
    private String entityName = "SipRA";
    private ResourceAdaptorState state;
    private String configurationMBeanName = "SipRA_1_2_Configuration";
    private Properties properties;
    private Properties provisionedProperties = new Properties();
    private transient Address address;
    private transient SleeEndpoint sleeEndpoint;
    private transient EventLookupFacility eventLookup;
    private transient BootstrapContext bootstrapContext;
    private transient SleeContainer serviceContainer;
    private transient SleeTransactionManager tm = null;
    private ActivityContextFactory activityContextFactory;
    private transient Map sipToSleeEvent = new ConcurrentHashMap();
    public static final String EVENT_PREFIX_1_2 = "javax.sip.dialog.";
    public static final String EVENT_PREFIX_1_1 = "javax.sip.message.";
    public static final String VENDOR_1_2 = "net.java";
    public static final String VERSION_1_2 = "1.2";
    public static final String VENDOR_1_1 = "javax.sip";
    public static final String VERSION_1_1 = "1.1";
    public static final String EVENT_REQUEST_DIALOG_TERMINATION_EVENT_NAME_1_2 = "javax.sip.dialog.TerminationRequest";
    public static final String EVENT_REQUEST_CANCEL_1_1 = "javax.sip.message.Request.CANCEL";
    public static final String EVENT_RESPONSE_TRYING_1_1 = "javax.sip.message.Response.TRYING";
    public static final String EVENT_RESPONSE_INFORMATIONAL_1_1 = "javax.sip.message.Response.INFORMATIONAL";
    public static final String EVENT_RESPONSE_SUCCESS_1_1 = "javax.sip.message.Response.SUCCESS";
    public static final String EVENT_RESPONSE_REDIRECTION_1_1 = "javax.sip.message.Response.REDIRECTION";
    public static final String EVENT_RESPONSE_CLIENT_ERROR_1_1 = "javax.sip.message.Response.CLIENT_ERROR";
    public static final String EVENT_RESPONSE_SERVER_ERROR_1_1 = "javax.sip.message.Response.SERVER_ERROR";
    public static final String EVENT_RESPONSE_GLOBAL_FAILURE_1_1 = "javax.sip.message.Response.GLOBAL_FAILURE";
    public static final String EVENT_TIMEOUT_TRANSACTION = "javax.sip.timeout.TRANSACTION";
    public static final String EVENT_TIMEOUT_DIALOG = "javax.sip.timeout.DIALOG";
    public static final String EVENT_DIALOG_STATE_SetupEarly = "javax.sip.dialog.SetupEarly";
    public static final String EVENT_DIALOG_STATE_SetupConfirmed = "javax.sip.dialog.SetupConfirmed";
    public static final String EVENT_DIALOG_STATE_SetupFailed = "javax.sip.dialog.SetupFailed";
    public static final String EVENT_DIALOG_STATE_SetupTimedOut = "javax.sip.dialog.SetupTimedOut";
    private transient Map eventIDsOfServicesInstalled = new ConcurrentHashMap(31);
    private transient Map eventResourceOptionsOfServicesInstalled = new ConcurrentHashMap(31);
    private transient Map myComponentKeys = new ConcurrentHashMap(31);
    private Timer timer = new Timer();
    private Timer debugTimer = new Timer();
    private Logger debugLogger = Logger.getLogger((String)"org.mobicents.slee.resource.sip.DEBUG");
    private HashMap receivedEvents = new HashMap();
    private ArrayList orderOfEvent = new ArrayList();
    private HashMap timeStamps = new HashMap();

    public SipResourceAdaptor() {
        this.allowedTransports.add("udp");
        this.allowedTransports.add("tcp");
        this.transports.add("udp");
    }

    public String getIp() {
        return this.stackAddress;
    }

    public void setIp(String ip) {
        this.stackAddress = ip.equals("null") ? System.getProperty("jboss.bind.address") : ip;
        this.provisionedProperties.put(SIP_BIND_ADDRESS, this.stackAddress);
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port < 1024 ? 5060 : port;
        this.provisionedProperties.put(SIP_PORT_BIND, "" + this.port);
    }

    public Long getCancelWait() {
        return this.cancelWait;
    }

    public void setCancelWait(Long cancelWait) {
        this.cancelWait = cancelWait > 0L ? 1000L : cancelWait;
        this.provisionedProperties.put(CANCEL_WAIT_BIND, "" + this.cancelWait);
    }

    public Long getDialogIdleTimeTimeout() {
        return this.dialogTimeout;
    }

    public void setDialogIdleTimeTimeout(Long idleTimeOut) {
        this.dialogTimeout = idleTimeOut < 0L ? 30000L : idleTimeOut;
        this.provisionedProperties.put(DIALOG_TIMEOUT_BIND, "" + this.dialogTimeout);
    }

    public String getTransports() {
        return Arrays.toString(this.transports.toArray()).replaceFirst("\\[", "").replaceFirst("\\]", "");
    }

    public void setTransports(String transportsToSet) {
        String[] tmp = transportsToSet.split(",");
        if (tmp.length > 0) {
            boolean valid = false;
            int i = 0;
            if (i < tmp.length && this.allowedTransports.contains(tmp[i].toLowerCase())) {
                valid = true;
            }
            if (valid) {
                this.transports.clear();
                for (i = 0; i < tmp.length; ++i) {
                    if (this.allowedTransports.contains(tmp[i].toLowerCase())) {
                        this.transports.add(tmp[i].toLowerCase());
                        continue;
                    }
                    log.error((Object)(" TRANSPORT[" + tmp[i] + "] IS NOT A VALID TRANSPORT!!!"));
                }
            }
        }
        this.provisionedProperties.put(TRANSPORTS_BIND, transportsToSet);
    }

    private void init(BootstrapContext bootstrapContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SipResourceAdaptor: init()");
        }
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
        this.state = ResourceAdaptorState.UNCONFIGURED;
    }

    private Properties loadProperties(BootstrapContext bootstrapContext) {
        Properties props = new Properties();
        try {
            String bindAddress;
            props.load(this.getClass().getResourceAsStream("sipra.properties"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading default SIP RA properties: " + props));
            }
            if ((bindAddress = props.getProperty(SIP_BIND_ADDRESS)) == null && (bindAddress = System.getProperty("jboss.bind.address")) != null) {
                props.setProperty(SIP_BIND_ADDRESS, bindAddress);
            }
        }
        catch (IOException ex) {
            props.setProperty("javax.sip.RETRANSMISSION_FILTER", "on");
        }
        return props;
    }

    public void configure(Properties properties) throws InvalidStateException {
        String confValue;
        if (this.state != ResourceAdaptorState.UNCONFIGURED) {
            throw new InvalidStateException("Cannot configure RA wrong state: " + this.state);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuring RA" + properties));
        }
        this.properties = this.loadProperties(this.bootstrapContext);
        if (properties != null) {
            if (log.isDebugEnabled()) {
                for (Map.Entry<Object, Object> en : properties.entrySet()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("---[SetHotProps][" + this.entityName + "] " + en.getKey() + " [*] " + en.getValue()));
                }
            }
            this.properties.putAll((Map<?, ?>)properties);
        }
        if ((confValue = this.properties.getProperty(SIP_PORT_BIND)) != null) {
            this.port = Integer.parseInt(confValue);
            confValue = null;
        }
        if ((confValue = this.properties.getProperty(TRANSPORTS_BIND, "udp")) != null) {
            String[] tmp = confValue.split(",");
            if (tmp.length > 0) {
                boolean valid = false;
                int i = 0;
                if (i < tmp.length && this.allowedTransports.contains(tmp[i])) {
                    valid = true;
                }
                if (valid) {
                    this.transports.clear();
                    for (i = 0; i < tmp.length; ++i) {
                        if (this.allowedTransports.contains(tmp[i])) {
                            this.transports.add(tmp[i]);
                            continue;
                        }
                        log.error((Object)(" TRANSPORT[" + tmp[i] + "] IS NOT A VALID TRANSPORT!!!"));
                    }
                }
            }
            confValue = null;
        }
        if ((confValue = this.properties.getProperty(SIP_BIND_ADDRESS)) != null) {
            this.stackAddress = confValue;
            this.properties.remove(SIP_BIND_ADDRESS);
            confValue = null;
        } else {
            this.stackAddress = System.getProperty("jboss.bind.address");
        }
        confValue = this.properties.getProperty(STACK_NAME_BIND);
        confValue = confValue == null ? "SipResourceAdaptorStack_" + this.stackAddress + "_" + this.port : confValue + "_" + this.stackAddress + "_" + this.port;
        this.properties.put(STACK_NAME_BIND, confValue);
        confValue = null;
        this.stackPrefix = this.properties.getProperty("javax.sip.STACK_PREFIX", "gov.nist");
        confValue = this.properties.getProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT");
        if (confValue != null) {
            this.automaticDialogSupport = !confValue.equals("off");
            confValue = null;
        }
        int i = 0;
        for (i = 0; i < 10; ++i) {
            InetSocketAddress sockAddress = new InetSocketAddress(this.stackAddress, this.port);
            try {
                log.info((Object)("Trying to bind to " + sockAddress));
                DatagramSocket socket = new DatagramSocket(sockAddress);
                this.properties.setProperty(SIP_PORT_BIND, Integer.valueOf(this.port).toString());
                socket.close();
                break;
            }
            catch (Exception ex) {
                this.port += 10;
                continue;
            }
        }
        if (i == 10) {
            throw new RuntimeException("Cannot create SIP Resource adaptor - no port available to bind to ");
        }
        log.info((Object)("RA bound to " + this.port));
        this.dialogTimeout = Long.parseLong(this.properties.getProperty(DIALOG_TIMEOUT_BIND, this.dialogTimeout + ""));
        this.cancelWait = Long.parseLong(this.properties.getProperty(CANCEL_WAIT_BIND, this.cancelWait + ""));
        this.createDialogAutomaticly = Boolean.valueOf(this.properties.getProperty(DIALOG_AUTOMATIC_CREATION_BIND, "false"));
        this.configurationMBeanName = this.properties.getProperty("net.java.sipra.configurationBeanName", this.configurationMBeanName);
        this.state = ResourceAdaptorState.CONFIGURED;
    }

    public void entityCreated(BootstrapContext ctx) throws ResourceException {
        this.init(ctx);
    }

    public void entityActivated() throws ResourceException {
        try {
            try {
                this.configure(this.provisionedProperties);
            }
            catch (InvalidStateException e1) {
                e1.printStackTrace();
            }
            this.start();
        }
        catch (ResourceException e) {
            e.printStackTrace();
            throw new ResourceException("Failed to Activate Resource Adaptor!", (Throwable)e);
        }
    }

    public void entityDeactivating() {
        this.stopping();
    }

    public void entityDeactivated() {
        this.stop();
    }

    public void entityRemoved() {
    }

    public void start() throws ResourceException {
        try {
            this.initializeNamingContext();
            this.initializeStack();
            this.activities = new ConcurrentHashMap();
            this.sipToSleeEvent = new ConcurrentHashMap();
            this.eventIDsOfServicesInstalled = new ConcurrentHashMap(31);
            this.eventResourceOptionsOfServicesInstalled = new ConcurrentHashMap(31);
            this.myComponentKeys = new ConcurrentHashMap(31);
            this.state = ResourceAdaptorState.ACTIVE;
            boolean created = false;
            for (String trans : this.transports) {
                ListeningPoint lp = this.sipStack.createListeningPoint(this.stackAddress, this.port, trans);
                if (!created) {
                    this.provider = this.sipStack.createSipProvider(lp);
                    this.provider.setAutomaticDialogSupportEnabled(this.automaticDialogSupport);
                    created = true;
                } else {
                    this.provider.addListeningPoint(lp);
                }
                try {
                    this.provider.addSipListener((SipListener)this);
                }
                catch (Exception ex) {
                    log.fatal((Object)"Unexpected exception ", (Throwable)ex);
                    throw new ResourceException("SIP RA failed to register as SipListener");
                }
            }
            AddressFactory addressFactory = this.sipFactory.createAddressFactory();
            HeaderFactory headerFactory = this.sipFactory.createHeaderFactory();
            MessageFactory messageFactory = this.sipFactory.createMessageFactory();
            this.sipFactoryProvider = new SipFactoryProvider(addressFactory, messageFactory, headerFactory, this.provider, this);
            ResourceAdaptorEntity resourceAdaptorEntity = this.serviceContainer.getResourceAdaptorEnitity(this.bootstrapContext.getEntityName());
            this.entityName = resourceAdaptorEntity.getName();
            EventTypeID[] eventTypeIDs = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getRaTypeDescr().getEventTypes();
            for (int i = 0; i < eventTypeIDs.length; ++i) {
                ComponentKey eventKey = this.serviceContainer.getEventKey(eventTypeIDs[i]);
                this.myComponentKeys.put(eventKey, Collections.synchronizedSet(new HashSet(10)));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Keys for this RA: " + this.myComponentKeys.keySet().toString()));
            }
            String[] tmp = new String[this.transports.size()];
            tmp = this.transports.toArray(tmp);
            SipRaConfiguration sipc = new SipRaConfiguration(this.automaticDialogSupport, this.stackAddress, tmp, this.port);
            ServerTransactionWrapper.setCancelWait(this.cancelWait);
            DialogWrapper.setDialogTimeout(this.dialogTimeout);
            sipc.startService(this.configurationMBeanName + "_" + this.entityName);
        }
        catch (Exception ex) {
            log.error((Object)"error in initializing resource adaptor", (Throwable)ex);
            throw new ResourceException(ex.getMessage());
        }
    }

    protected void initializeStack() throws SipException {
        this.sipFactory = SipFactory.getInstance();
        this.sipFactory.setPathName("gov.nist");
        this.properties.remove(SIP_PORT_BIND);
        this.sipStack = this.sipFactory.createSipStack(this.properties);
        this.sipStack.start();
    }

    public void setProperties(Properties properties) throws ResourceException {
        if (this.state != ResourceAdaptorState.UNCONFIGURED) {
            throw new ResourceException("Cannot modify configuration properties wrong state: " + this.state);
        }
        this.properties = properties;
    }

    public Properties getProperties(Properties pproperties) {
        pproperties.putAll((Map<?, ?>)this.properties);
        return pproperties;
    }

    private void initializeNamingContext() throws NamingException {
        SleeContainer container;
        this.serviceContainer = container = SleeContainer.lookupFromJndi();
        this.activityContextFactory = this.serviceContainer.getActivityContextFactory();
        SipResourceAdaptor sipResourceAdaptor = this;
        this.tm = sipResourceAdaptor.serviceContainer.getTransactionManager();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(this.bootstrapContext.getEntityName());
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.acif = new SipActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), this.bootstrapContext.getEntityName());
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        this.entityName = this.bootstrapContext.getEntityName();
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("jndiName prefix =" + prefix + "; jndiName = " + name));
                }
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    private void cleanNamingContext() throws NamingException {
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                String javaJNDIName = jndiName.substring(begind + 1);
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public void stopping() {
        this.state = ResourceAdaptorState.STOPPING;
    }

    public void stop() {
        SipRaConfiguration.stopService(this.configurationMBeanName + "_" + this.entityName);
        this.provider.removeSipListener((SipListener)this);
        ListeningPoint[] listeningPoints = this.provider.getListeningPoints();
        block6: for (int i = 0; i < listeningPoints.length; ++i) {
            ListeningPoint lp = listeningPoints[i];
            for (int k = 0; k < 10; ++k) {
                try {
                    this.sipStack.deleteListeningPoint(lp);
                    this.sipStack.deleteSipProvider(this.provider);
                    continue block6;
                }
                catch (ObjectInUseException ex) {
                    log.error((Object)"Object in use -- retrying to delete listening point");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            log.error((Object)"Cannot unbind naming context");
        }
        this.state = ResourceAdaptorState.UNCONFIGURED;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sip Resource Adaptor stopped.");
        }
    }

    public Object getInterface() {
        return this.provider;
    }

    public Object getFactoryInterface() {
        return this.sipFactoryProvider;
    }

    public Object getActivityContextInterfaceFactory() {
        return this.acif;
    }

    public SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }

    public Object getSBBResourceAdaptorInterface(String arg0) {
        return this.getFactoryInterface();
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Map getActivities() {
        return this.activities;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public SipFactoryProvider getSipFactoryProvider() {
        return this.sipFactoryProvider;
    }

    public void sendActivityEndEvent(Transaction sipT) {
        SipActivityHandle ah = null;
        if (sipT instanceof ServerTransactionWrapper && ah.transactionId.endsWith("INVITE")) {
            ((ServerTransactionWrapper)sipT).processCancelOnActivityEnd();
        }
        if (sipT.getState() != TransactionState.TERMINATED) {
            try {
                sipT.terminate();
                return;
            }
            catch (ObjectInUseException e) {
                log.error((Object)" TX WAS NOT TERMIATED BUT GOT ERROR, PROCEEDING WITH REMOVAL!!!", (Throwable)e);
            }
        }
        if (sipT instanceof SecretWrapperInterface) {
            ((SecretWrapperInterface)sipT).getRealTransaction().setApplicationData(null);
            ah = ((SecretWrapperInterface)sipT).getActivityHandle();
        } else {
            ah = ((SecretWrapperInterface)sipT.getApplicationData()).getActivityHandle();
            sipT.setApplicationData(null);
        }
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)ah);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendActivityEndEvent(Dialog dial) {
        SipActivityHandle ah = null;
        if ((dial.getState() == null || dial.getState() != DialogState.TERMINATED) && log.isDebugEnabled()) {
            log.debug((Object)(" sendActivityEndEvent for non terminated dialog, terminating now " + dial.getDialogId()));
        }
        if (dial instanceof DialogWrapper) {
            ((DialogWrapper)dial).getRealDialog().setApplicationData(null);
            ah = ((DialogWrapper)dial).getActivityHandle();
        } else {
            ah = ((DialogWrapper)dial.getApplicationData()).getActivityHandle();
        }
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)ah);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void eventProcessingSuccessful(ActivityHandle ah, Object event, int arg2, Address arg3, int arg4) {
        Object activity;
        if (log.isDebugEnabled()) {
            log.debug((Object)("==========================================\n| EVENT PROCESSING SUCC: |\n==========================\n===========\n| HANDLE: |\n===========\n" + ah + "\n" + "==========\n| EVENT: |\n==========\n" + event + "\n" + "============\n| ADDRESS: |\n============\n" + arg3 + "\n" + "=========================================="));
        }
        if ((activity = this.activities.get(ah)) instanceof ServerTransactionWrapper) {
            if (((SipActivityHandle)ah).transactionId.endsWith("INVITE")) {
                ((ServerTransactionWrapper)activity).processCancelOnEventProcessingSucess();
            } else if (((SipActivityHandle)ah).transactionId.endsWith("ACK")) {
                this.activities.remove(ah);
            }
        }
    }

    public void eventProcessingFailed(ActivityHandle ah, Object event, int arg2, Address arg3, int arg4, FailureReason arg5) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("==========================================\n| EVENT PROCESSING FAIL: |\n==========================\n===========\n| HANDLE: |\n===========\n" + ah + "\n" + "==========\n| EVENT: |\n==========\n" + event + "\n" + "============\n| ADDRESS: |\n============\n" + arg3 + "\n" + "===========\n| REASON: |\n===========\n" + arg5 + "\n" + "=========================================="));
        }
        String id = ((SipActivityHandle)ah).transactionId;
        Object activity = this.activities.get(ah);
        if (activity instanceof ServerTransactionWrapper) {
            if (id.endsWith("INVITE")) {
                ((ServerTransactionWrapper)activity).processCancelOnEventProcessingSucess();
            } else if (id.endsWith("ACK")) {
                this.activities.remove(ah);
            }
        }
        if (!id.endsWith("CANCEL") || !(event instanceof RequestEventWrapper)) {
            return;
        }
        try {
            Response txDoesNotExistsResponse = this.sipFactoryProvider.getMessageFactory().createResponse(481, ((RequestEventWrapper)((Object)event)).getRequest());
            this.provider.sendResponse(txDoesNotExistsResponse);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (SipException e) {
            e.printStackTrace();
        }
    }

    public void activityEnded(ActivityHandle ah) {
        Object activity = this.activities.remove(ah);
        if (log.isDebugEnabled()) {
            if (activity instanceof Dialog) {
                log.debug((Object)("Removed terminated dialog [dialog id =  " + ((Dialog)activity).getDialogId() + "]"));
            } else if (activity instanceof Transaction) {
                Transaction t = (Transaction)activity;
                log.debug((Object)("Removed terminated transaction [transaction id =  " + t.getBranchId() + "_" + t.getRequest().getMethod() + "]"));
            }
            log.debug((Object)("activities map size=" + this.activities.size()));
        }
        activity = null;
    }

    public void activityUnreferenced(ActivityHandle ah) {
    }

    public void queryLiveness(ActivityHandle ah) {
        if (!(ah instanceof SipActivityHandle)) {
            return;
        }
        if (this.activities.containsKey(ah)) {
            // empty if block
        }
    }

    public Object getActivity(ActivityHandle handle) {
        return this.activities.get(handle);
    }

    public ActivityHandle getActivityHandle(Object obj) {
        return null;
    }

    public void serviceInstalled(String serviceID, int[] eventIDs, String[] resourceOptions) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("service installed: service = " + serviceID + ", eventIDs = " + Arrays.toString(eventIDs) + ", resourceOptions  = " + Arrays.toString(resourceOptions)));
        }
        this.eventIDsOfServicesInstalled.put(serviceID, eventIDs);
        this.eventResourceOptionsOfServicesInstalled.put(serviceID, resourceOptions);
    }

    public void serviceUninstalled(String serviceID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("service uninstalled: service = " + serviceID));
        }
        this.eventIDsOfServicesInstalled.remove(serviceID);
        this.eventResourceOptionsOfServicesInstalled.remove(serviceID);
    }

    public void serviceActivated(String serviceID) {
        int[] eventIDs;
        if (log.isDebugEnabled()) {
            log.debug((Object)("service activated: service = " + serviceID));
        }
        if ((eventIDs = (int[])this.eventIDsOfServicesInstalled.get(serviceID)) != null) {
            for (int i = 0; i < eventIDs.length; ++i) {
                EventTypeIDImpl eventTypeID = this.serviceContainer.getEventTypeID(eventIDs[i]);
                ComponentKey eventKey = this.serviceContainer.getEventKey((EventTypeID)eventTypeID);
                Set servicesActivatedList = (Set)this.myComponentKeys.get(eventKey);
                if (servicesActivatedList == null) continue;
                servicesActivatedList.add(serviceID);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Service " + serviceID + " is activated and registred to event with key " + eventKey));
            }
        }
    }

    public void serviceDeactivated(String serviceID) {
        int[] eventIDs;
        if (log.isDebugEnabled()) {
            log.debug((Object)("service deactivated: service = " + serviceID));
        }
        if ((eventIDs = (int[])this.eventIDsOfServicesInstalled.get(serviceID)) != null) {
            for (int i = 0; i < eventIDs.length; ++i) {
                EventTypeIDImpl eventTypeID = this.serviceContainer.getEventTypeID(eventIDs[i]);
                ComponentKey eventKey = this.serviceContainer.getEventKey((EventTypeID)eventTypeID);
                Set servicesActivatedList = (Set)this.myComponentKeys.get(eventKey);
                if (servicesActivatedList == null) continue;
                servicesActivatedList.remove(serviceID);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Service " + serviceID + " was deactivated and unregistred to event with key " + eventKey));
            }
        }
    }

    public void processIOException(IOExceptionEvent arg0) {
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        DialogWrapper dialogWrapper = null;
        dialogWrapper = dialogTerminatedEvent.getDialog() instanceof DialogWrapper ? (DialogWrapper)dialogTerminatedEvent.getDialog() : (DialogWrapper)dialogTerminatedEvent.getDialog().getApplicationData();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing dialog termination: " + dialogWrapper.getDialogId()));
        }
        ComponentKey key = null;
        dialogWrapper.cancel();
        boolean c = dialogWrapper.hasBeenCanceled();
        boolean t1 = dialogWrapper.getHasTimedOut();
        key = !c || t1 ? new ComponentKey(EVENT_TIMEOUT_DIALOG, VENDOR_1_2, VERSION_1_2) : new ComponentKey("javax.sip.dialog.Terminated", VENDOR_1_2, VERSION_1_2);
        if (!this.isEventGoingToBereceived(key)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("------------------ DIALOG[" + key + "] " + dialogWrapper.getDialogId() + " TERMINATED EVENT IS FILTERED ----------------"));
            }
            this.sendActivityEndEvent(dialogWrapper);
        } else {
            int eventID = -1;
            try {
                eventID = this.eventLookup.getEventID(key.getName(), key.getVendor(), key.getVersion());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (eventID == -1) {
                SipToSLEEUtility.displayMessage("Resource adaptor", "- Event is not a a registared event type", key);
                if (dialogWrapper.isInStateEventFireSequence()) {
                    DTERemoveTask drt = new DTERemoveTask(dialogWrapper, eventID, key);
                    this.timer.schedule((TimerTask)drt, 150L);
                    return;
                }
            } else if (!dialogWrapper.isInStateEventFireSequence()) {
                SipToSLEEUtility.displayDeliveryMessage("SipResourceAdaptor", eventID, key, dialogWrapper.getActivityHandle().transactionId);
                try {
                    DialogTerminatedEventWrapper event = new DialogTerminatedEventWrapper(this.sipFactoryProvider.getSipProvider(), dialogWrapper);
                    this.sleeEndpoint.fireEvent((ActivityHandle)dialogWrapper.getActivityHandle(), (Object)event, eventID, new Address(AddressPlan.SIP, dialogWrapper.getLocalParty().toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.sendActivityEndEvent(dialogWrapper);
            } else {
                DTERemoveTask drt = new DTERemoveTask(dialogWrapper, eventID, key);
                this.timer.schedule((TimerTask)drt, 150L);
                return;
            }
        }
    }

    private void processNotCancelRequests(RequestEventWrapper req) {
        ServerTransaction stw = req.getServerTransaction();
        DialogWrapper dw = (DialogWrapper)stw.getDialog();
        if (log.isDebugEnabled()) {
            log.debug((Object)("processNotCancelRequests() Server Transaction: " + stw));
        }
        Address address = new Address(AddressPlan.SIP, ((FromHeader)req.getRequest().getHeader("From")).getAddress().toString());
        SipActivityHandle txAH = ((SecretWrapperInterface)stw).getActivityHandle();
        ComponentKey txEventKey = this.getKeyFor1_1(req.getRequest().getMethod());
        SipActivityHandle dialogAH = null;
        ComponentKey dialogEventKey = null;
        if (dw != null) {
            dialogAH = dw.getActivityHandle();
            dialogEventKey = this.getKeyFor1_2(req.getRequest().getMethod(), dw);
        } else if (this.createDialogAutomaticly) {
            ComponentKey key = new ComponentKey("javax.sip.dialog.Request.INVITE", VENDOR_1_2, VERSION_1_2);
            if (req.getRequest().getMethod().compareTo("INVITE") == 0 && this.isEventGoingToBereceived(key) && stw instanceof ServerTransactionWrapper) {
                try {
                    dw = (DialogWrapper)((SipProviderProxy)this.sipFactoryProvider.getSipProvider()).getNewDialog((Transaction)stw, true);
                    ((ServerTransactionWrapper)stw).setDialogWrapper(dw);
                    dialogAH = dw.getActivityHandle();
                    dialogEventKey = key;
                    this.activities.put(dialogAH, dw);
                }
                catch (SipException e) {
                    e.printStackTrace();
                }
            }
        }
        boolean removeACK = false;
        if (this.isEventGoingToBereceived(txEventKey)) {
            SipToSLEEUtility.displayMessage("Resource adaptor", "looking up transaction event", txEventKey);
            int eventID = -1;
            try {
                eventID = this.eventLookup.getEventID(txEventKey.getName(), txEventKey.getVendor(), txEventKey.getVersion());
            }
            catch (Exception e) {
                this.sendErrorResponse(req.getRequest(), 500, e.getMessage());
                e.printStackTrace();
            }
            if (eventID == -1) {
                SipToSLEEUtility.displayMessage("Resource adaptor", "- Event is not a a registared event type", txEventKey);
                return;
            }
            SipToSLEEUtility.displayDeliveryMessage("Resource adaptor", eventID, txEventKey, txAH.transactionId);
            try {
                this.sleeEndpoint.fireEvent((ActivityHandle)txAH, (Object)req, eventID, address);
            }
            catch (Exception e) {
                this.sendErrorResponse(req.getRequest(), 500, e.getMessage());
                e.printStackTrace();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n======== EVENT[1][" + txEventKey + "] IS NOT GOING TO BE RECEIVED, DROPING ========"));
            }
            if (txEventKey != null && txEventKey.getName().endsWith("ACK")) {
                removeACK = true;
            }
        }
        if (dialogAH != null && this.isEventGoingToBereceived(dialogEventKey)) {
            int eventID;
            SipToSLEEUtility.displayMessage("Resource adaptor", "looking up dialog event", dialogEventKey);
            try {
                eventID = this.eventLookup.getEventID(dialogEventKey.getName(), dialogEventKey.getVendor(), dialogEventKey.getVersion());
            }
            catch (FacilityException e2) {
                throw new RuntimeException("Failed to lookup\t\t  event!", e2);
            }
            catch (UnrecognizedEventException e2) {
                throw new RuntimeException("Failed to lookup  event!", e2);
            }
            if (eventID == -1) {
                SipToSLEEUtility.displayMessage("Resource adaptor", "- Event is not a a registared event type", dialogEventKey);
                return;
            }
            SipToSLEEUtility.displayDeliveryMessage("Resource adaptor", eventID, dialogEventKey, dialogAH.transactionId);
            try {
                this.sleeEndpoint.fireEvent((ActivityHandle)dialogAH, (Object)req, eventID, address);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.sendErrorResponse(req.getRequest(), 500, e.getMessage());
            }
        } else {
            if (dialogEventKey != null && log.isDebugEnabled()) {
                log.debug((Object)("\n======== EVENT[2][" + dialogEventKey + "] IS NOT GOING TO BE RECEIVED, DROPING ========"));
            }
            if (dialogEventKey != null && dialogEventKey.getName().endsWith("ACK")) {
                removeACK = true;
            }
        }
        if (removeACK) {
            this.activities.remove(((SecretWrapperInterface)req.getServerTransaction()).getActivityHandle());
        }
    }

    private void processCancelRequest(RequestEventWrapper req) {
        ServerTransactionWrapper cancel_stw = (ServerTransactionWrapper)req.getServerTransaction();
        String cancelTransactionID = cancel_stw.getBranchId() + "_" + "CANCEL";
        String inviteTransactionID = cancel_stw.getBranchId() + "_" + "INVITE";
        SipActivityHandle activityHandle = null;
        Object inviteTx = this.activities.get(new SipActivityHandle(inviteTransactionID));
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n+++++++++++++++++++++++++++\nINVITE TX:" + inviteTx + "\ninviteTx instanceof ServerTransaction:" + (inviteTx instanceof ServerTransaction) + "\n"));
        }
        if (inviteTx != null && inviteTx instanceof ServerTransaction) {
            Response cancelOkResponse = null;
            activityHandle = ((SecretWrapperInterface)inviteTx).getActivityHandle();
            ServerTransactionWrapper invite_stw = (ServerTransactionWrapper)inviteTx;
            if (invite_stw.getState() == TransactionState.TERMINATED || invite_stw.getState() == TransactionState.COMPLETED || invite_stw.getState() == TransactionState.CONFIRMED) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("================================================== \nFINAL RESPONSE HAS BEEN SENT FOR TX, DROPPING CANCEL: \n" + invite_stw + "\n=================================================="));
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"----------- SENDING AUTOAMTIC OK TO CANCEL -----------");
            }
            try {
                cancelOkResponse = this.sipFactoryProvider.getMessageFactory().createResponse(200, req.getRequest());
                cancel_stw.sendResponse(cancelOkResponse);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
                this.sendErrorResponse(req.getRequest(), 406, e1.getMessage());
            }
            catch (SipException e) {
                e.printStackTrace();
                this.sendErrorResponse(req.getRequest(), 406, e.getMessage());
            }
            catch (InvalidArgumentException e) {
                e.printStackTrace();
                this.sendErrorResponse(req.getRequest(), 500, e.getMessage());
            }
            DialogWrapper invite_dw = (DialogWrapper)invite_stw.getDialog();
            if (invite_dw != null) {
                invite_dw.cancel();
                if (invite_dw.getState().getValue() != DialogState.TERMINATED.getValue() && log.isDebugEnabled()) {
                    log.debug((Object)("TERMINATING DIALOG EXPLICITLY --> " + invite_dw));
                }
                try {
                    invite_stw.sendResponse(this.sipFactoryProvider.getMessageFactory().createResponse(487, invite_stw.getRequest()));
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                    this.sendErrorResponse(req.getRequest(), 406, e1.getMessage());
                }
                catch (SipException e) {
                    e.printStackTrace();
                    this.sendErrorResponse(req.getRequest(), 406, e.getMessage());
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                    this.sendErrorResponse(req.getRequest(), 500, e.getMessage());
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"============= POSTPONING CANCEL ===========");
                }
                invite_stw.setCancel(req);
                activityHandle = null;
            }
        } else {
            activityHandle = ((SecretWrapperInterface)req.getServerTransaction()).getActivityHandle();
        }
        if (activityHandle == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"============= CANCEL POSTPONED - RETURNING ====================");
            }
            return;
        }
        ComponentKey key = new ComponentKey(EVENT_REQUEST_CANCEL_1_1, VENDOR_1_1, VERSION_1_1);
        SipToSLEEUtility.displayMessage("Resource adaptor", "looking up", key);
        if (!this.isEventGoingToBereceived(key)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n======== EVENT[3]" + key + " IS NOT GOING TO BE RECEIVED, DROPING ========"));
            }
            return;
        }
        int eventID = -1;
        try {
            eventID = this.eventLookup.getEventID(key.getName(), key.getVendor(), key.getVersion());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendErrorResponse(req.getRequest(), 500, e.getMessage());
        }
        if (eventID == -1) {
            SipToSLEEUtility.displayMessage("Resource adaptor", "- Event is not a a registared event type", key);
            return;
        }
        SipToSLEEUtility.displayDeliveryMessage("Resource adaptor", eventID, key, activityHandle.transactionId);
        try {
            this.sleeEndpoint.fireEvent((ActivityHandle)activityHandle, (Object)req, eventID, new Address(AddressPlan.SIP, ((ToHeader)req.getRequest().getHeader("To")).getAddress().toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendErrorResponse(req.getRequest(), 500, e.getMessage());
        }
    }

    private ServerTransaction proccessACKReqeust(RequestEvent req) {
        Dialog d = req.getDialog();
        if (d != null) {
            if (d.getApplicationData() != null) {
                DialogWrapper dw = (DialogWrapper)d.getApplicationData();
                d = dw;
            } else {
                log.error((Object)"GOT NULL DialogWrapper when dialog is not null!!!!");
            }
        }
        return new ServerTransactionWrapper((ServerTransaction)((SIPRequest)req.getRequest()).getTransaction(), (DialogWrapper)d, this);
    }

    private void sendErrorResponse(Request request, int code, String msg) {
        try {
            ContentTypeHeader contentType = this.sipFactoryProvider.getHeaderFactory().createContentTypeHeader("text", "plain");
            Response response = this.sipFactoryProvider.getMessageFactory().createResponse(code, request, contentType, msg.getBytes());
            this.sipFactoryProvider.getSipProvider().sendResponse(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processRequest(RequestEvent req) {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("\n-------------------------\nREQUEST:\n-------------------------\n" + req.getRequest() + "\n-------------------------"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Server Transaction: " + req.getServerTransaction()));
            }
            ServerTransaction st = null;
            Dialog dialog = null;
            if (req.getRequest().getMethod().equals("ACK")) {
                st = this.proccessACKReqeust(req);
                dialog = st.getDialog();
            } else {
                ServerTransactionWrapper stw;
                st = req.getServerTransaction();
                if (st == null) {
                    try {
                        st = this.provider.getNewServerTransaction(req.getRequest());
                    }
                    catch (TransactionAlreadyExistsException e) {
                        e.printStackTrace();
                        this.sendErrorResponse(req.getRequest(), 500, e.getMessage());
                    }
                    catch (TransactionUnavailableException e) {
                        e.printStackTrace();
                        this.sendErrorResponse(req.getRequest(), 406, e.getMessage());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\n----------------- CREATED NEW STx ---------------------\nBRANCH: " + st.getBranchId() + "\n-------------------------------------------------------"));
                    }
                }
                dialog = st.getDialog();
                DialogWrapper DW = null;
                if (dialog != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("======= DIALOG NOT NULL IN STx: " + dialog + " ========"));
                    }
                    if ((DW = (DialogWrapper)dialog.getApplicationData()) == null) {
                        DW = new DialogWrapper(dialog, this);
                        if (DW.getState() == null || !DW.getState().equals((Object)DialogState.TERMINATED)) {
                            this.activities.put(DW.getActivityHandle(), DW);
                        }
                    } else {
                        DW.renew();
                    }
                    dialog = DW;
                }
                if ((stw = (ServerTransactionWrapper)st.getApplicationData()) == null) {
                    stw = new ServerTransactionWrapper(st, DW, this);
                }
                st = stw;
            }
            this.activities.put(((SecretWrapperInterface)st).getActivityHandle(), st);
            RequestEventWrapper REW = new RequestEventWrapper(this.sipFactoryProvider.getSipProvider(), st, dialog, req.getRequest());
            if (req.getRequest().getMethod().compareTo("CANCEL") != 0) {
                this.processNotCancelRequests(REW);
            } else {
                this.processCancelRequest(REW);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendErrorResponse(req.getRequest(), 500, e.getMessage());
        }
    }

    public void processResponse(ResponseEvent resp) {
        ClientTransactionWrapper ctw;
        int statusCode = resp.getResponse().getStatusCode();
        if (log.isInfoEnabled()) {
            log.info((Object)("\n-------------------------\nRESPONSE:\n-------------------------\n" + resp.getResponse() + "\n-------------------------"));
        }
        ComponentKey key = null;
        key = statusCode == 100 ? new ComponentKey(EVENT_RESPONSE_TRYING_1_1, VENDOR_1_1, VERSION_1_1) : (100 < statusCode && statusCode < 200 ? new ComponentKey(EVENT_RESPONSE_INFORMATIONAL_1_1, VENDOR_1_1, VERSION_1_1) : (statusCode < 300 ? new ComponentKey(EVENT_RESPONSE_SUCCESS_1_1, VENDOR_1_1, VERSION_1_1) : (statusCode < 400 ? new ComponentKey(EVENT_RESPONSE_REDIRECTION_1_1, VENDOR_1_1, VERSION_1_1) : (statusCode < 500 ? new ComponentKey(EVENT_RESPONSE_CLIENT_ERROR_1_1, VENDOR_1_1, VERSION_1_1) : (statusCode < 600 ? new ComponentKey(EVENT_RESPONSE_SERVER_ERROR_1_1, VENDOR_1_1, VERSION_1_1) : new ComponentKey(EVENT_RESPONSE_GLOBAL_FAILURE_1_1, VENDOR_1_1, VERSION_1_1))))));
        ClientTransaction ct = resp.getClientTransaction();
        if (ct == null) {
            log.error((Object)("===> CT is NULL - RTR ? CALLID[" + ((CallID)resp.getResponse().getHeader("Call-ID")).getCallId() + "] BRANCH[" + ((Via)resp.getResponse().getHeaders("Via").next()).getBranch() + "] METHOD[" + ((CSeq)resp.getResponse().getHeader("CSeq")).getMethod() + "] CODE[" + resp.getResponse().getStatusCode() + "]"));
            return;
        }
        SipActivityHandle txAH = null;
        Dialog dialog = ct.getDialog();
        DialogWrapper DW = null;
        if (dialog != null) {
            DW = (DialogWrapper)dialog.getApplicationData();
            if (DW == null) {
                DW = new DialogWrapper(dialog, this);
                this.activities.put(DW.getActivityHandle(), DW);
            } else {
                DW.renew();
            }
            dialog = DW;
            DW.startStateEventFireSequence();
            if (DW.fireDialogStateEvent(resp.getResponse())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" == FIRED STATE EVENT, not firing response event ==");
                }
                return;
            }
        }
        if ((ctw = (ClientTransactionWrapper)ct.getApplicationData()) == null) {
            ctw = new ClientTransactionWrapper(ct, DW);
        }
        txAH = ctw.getActivityHandle();
        ct = ctw;
        SipToSLEEUtility.displayMessage("Resource adaptor", "looking up", key);
        int eventID = -1;
        if (!this.isEventGoingToBereceived(key)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n======== EVENT[4] " + key + " IS NOT GOING TO BE RECEIVED, DROPING ========"));
            }
            return;
        }
        try {
            eventID = this.eventLookup.getEventID(key.getName(), key.getVendor(), key.getVersion());
        }
        catch (Exception e1) {
            log.error((Object)e1);
        }
        if (eventID == -1) {
            SipToSLEEUtility.displayMessage("Resource adaptor", "- Event is not a a registared event type", key);
            return;
        }
        try {
            SipToSLEEUtility.displayDeliveryMessage("Resource adaptor", eventID, key, txAH.toString());
            this.sleeEndpoint.fireEvent((ActivityHandle)txAH, (Object)new ResponseEventWrapper(this.sipFactoryProvider.getSipProvider(), ct, dialog, resp.getResponse()), eventID, new Address(AddressPlan.SIP, ((ToHeader)resp.getResponse().getHeader("To")).getAddress().toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processTimeout(TimeoutEvent timeout) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n==========================\nProcessing timeout:\n--------------------------\n" + timeout.getTimeout().getValue() + "\n=========================="));
        }
        ComponentKey key = new ComponentKey(EVENT_TIMEOUT_TRANSACTION, VENDOR_1_1, VERSION_1_1);
        ComponentKey dialogKey = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n------------------------ \nTIMEOUT:\n" + timeout.getSource() + "\n" + timeout.getClientTransaction() + "\n" + timeout.getServerTransaction() + "\n-------------------------------"));
        }
        ServerTransaction t = null;
        TimeoutEventWrapper TEW = null;
        boolean isInvite = false;
        if (timeout.getServerTransaction() != null) {
            t = timeout.getServerTransaction();
            TEW = new TimeoutEventWrapper((Object)this.sipFactoryProvider.getSipProvider(), t, timeout.getTimeout());
        } else {
            t = timeout.getClientTransaction();
            TEW = new TimeoutEventWrapper((Object)this.sipFactoryProvider.getSipProvider(), (ClientTransaction)t, timeout.getTimeout());
        }
        SipActivityHandle activityHandle = ((SecretWrapperInterface)t.getApplicationData()).getActivityHandle();
        if (t.getRequest().getMethod().equals("INVITE")) {
            isInvite = true;
        }
        Dialog dial = t.getDialog();
        if (isInvite && dial != null && dial.getState() != DialogState.CONFIRMED) {
            dialogKey = new ComponentKey(EVENT_DIALOG_STATE_SetupTimedOut, VENDOR_1_2, VERSION_1_2);
            DialogWrapper DW = (DialogWrapper)dial.getApplicationData();
            if (DW != null) {
                DW.cancel();
            }
        }
        SipToSLEEUtility.displayMessage("Resource adaptor", "looking up", key);
        if (dialogKey != null) {
            SipToSLEEUtility.displayMessage("Resource adaptor", "looking up", dialogKey);
        }
        int eventID = -1;
        int dialogEventID = -1;
        try {
            eventID = this.eventLookup.getEventID(key.getName(), key.getVendor(), key.getVersion());
            if (dialogKey != null) {
                dialogEventID = this.eventLookup.getEventID(dialogKey.getName(), dialogKey.getVendor(), dialogKey.getVersion());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (eventID == -1) {
            SipToSLEEUtility.displayMessage("Resource adaptor", "- Event is not a a registared event type", key);
            return;
        }
        try {
            SipToSLEEUtility.displayDeliveryMessage("Resource adaptor", eventID, key, t.getBranchId() + "_" + t.getRequest().getMethod());
            this.sleeEndpoint.fireEvent((ActivityHandle)activityHandle, (Object)TEW, eventID, this.address);
            if (dialogKey != null && dialogEventID != -1) {
                SipToSLEEUtility.displayDeliveryMessage("Resource adaptor", eventID, dialogKey, dial.getDialogId());
                this.sleeEndpoint.fireEvent((ActivityHandle)((DialogWrapper)dial.getApplicationData()).getActivityHandle(), (Object)TEW, dialogEventID, this.address);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processTransactionTerminated(TransactionTerminatedEvent txTerminatedEvent) {
        ComponentKey key;
        ServerTransaction t = null;
        TransactionTerminatedEventWrapper TTEW = null;
        if (txTerminatedEvent.isServerTransaction()) {
            t = txTerminatedEvent.getServerTransaction();
            TTEW = new TransactionTerminatedEventWrapper((Object)this.sipFactoryProvider.getSipProvider(), t);
        } else {
            t = txTerminatedEvent.getClientTransaction();
            TTEW = new TransactionTerminatedEventWrapper((Object)this.sipFactoryProvider.getSipProvider(), (ClientTransaction)t);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("==== processTransactionTerminatedEvent() ID:" + t.getBranchId() + "_" + t.getRequest().getMethod() + " ====="));
        }
        if (!this.isEventGoingToBereceived(key = new ComponentKey("javax.sip.transaction.Terminated", VENDOR_1_2, VERSION_1_2))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n======== EVENT[" + key + "] IS NOT GOING TO BE RECEIVED, DROPING ========"));
            }
        } else {
            SipToSLEEUtility.displayMessage("Resource adaptor", "looking up", key);
            int eventID = -1;
            try {
                eventID = this.eventLookup.getEventID("javax.sip.transaction.Terminated", VENDOR_1_2, VERSION_1_2);
            }
            catch (Exception e2) {
                log.error((Object)e2);
            }
            if (eventID == -1) {
                SipToSLEEUtility.displayMessage("Resource adaptor", "- Event is not a a registared event type", key);
            } else {
                try {
                    SipToSLEEUtility.displayDeliveryMessage("Resource adaptor", eventID, key, t.getBranchId() + "_" + t.getRequest().getMethod());
                    this.sleeEndpoint.fireEvent((ActivityHandle)((SecretWrapperInterface)t.getApplicationData()).getActivityHandle(), (Object)TTEW, eventID, new Address(AddressPlan.SIP, ((ToHeader)t.getRequest().getHeader("To")).getAddress().toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.sendActivityEndEvent((Transaction)t);
    }

    private ComponentKey getKeyFor1_1(String method) {
        ComponentKey key;
        String localMethod = null;
        localMethod = !this.isRFC3261Method(method) ? "EXTENSION" : method;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n=============== LOOKING COMPONENTKEY FOR METHOD ==================\nPASSED: " + method + "\nLOCAL: " + localMethod + "\n==================================="));
        }
        if ((key = (ComponentKey)this.sipToSleeEvent.get(localMethod + "_TX")) == null) {
            key = new ComponentKey("javax.sip.message.Request." + localMethod, VENDOR_1_1, VERSION_1_1);
            this.sipToSleeEvent.put(localMethod + "_TX", key);
        }
        return key;
    }

    private ComponentKey getKeyFor1_2(String method, DialogWrapper dw) {
        ComponentKey key;
        String localMethod = null;
        localMethod = !this.isRFC3261Method(method) ? "EXTENSION" : method;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n=============== LOOKING COMPONENTKEY FOR METHOD ==================\nPASSED: " + method + "\nLOCAL: " + localMethod + "\n==================================="));
        }
        if ((key = (ComponentKey)this.sipToSleeEvent.get(localMethod + "_DIALOG")) == null) {
            key = new ComponentKey("javax.sip.dialog.Request." + localMethod, VENDOR_1_2, VERSION_1_2);
            this.sipToSleeEvent.put(localMethod + "_DIALOG", key);
        }
        if (key.getName().equals("javax.sip.dialog.Request.BYE") && dw.getTerminateOnBye() && (key = (ComponentKey)this.sipToSleeEvent.get(EVENT_REQUEST_DIALOG_TERMINATION_EVENT_NAME_1_2)) == null) {
            key = new ComponentKey(EVENT_REQUEST_DIALOG_TERMINATION_EVENT_NAME_1_2, VENDOR_1_2, VERSION_1_2);
            this.sipToSleeEvent.put(EVENT_REQUEST_DIALOG_TERMINATION_EVENT_NAME_1_2, key);
        }
        return key;
    }

    private boolean isRFC3261Method(String method) {
        return rfc3261Methods.contains(method);
    }

    protected void printActivities(String where) {
        if (log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            Iterator itKeys = this.activities.keySet().iterator();
            Object keyA = null;
            while (itKeys.hasNext()) {
                keyA = itKeys.next();
                sb.append(keyA + " == " + this.activities.get(keyA) + "\n");
            }
            log.debug((Object)("================ ACTIVITIES[" + where + "] ================\n" + sb.toString() + "\n============================================="));
        }
    }

    public boolean isEventGoingToBereceived(ComponentKey eventKey) {
        Set serviceIDSet = (Set)this.myComponentKeys.get(eventKey);
        return serviceIDSet != null && serviceIDSet.size() > 0;
    }

    private void initDebug() {
        this.debugTimer.scheduleAtFixedRate((TimerTask)new EventTimerTask(), 5000L, 5000L);
    }

    private void tearDownDebug() {
        this.debugTimer.cancel();
    }

    static {
        String[] tmp = new String[]{"ACK", "BYE", "CANCEL", "INFO", "INVITE", "MESSAGE", "NOTIFY", "OPTIONS", "PRACK", "PUBLISH", "REFER", "REGISTER", "SUBSCRIBE", "UPDATE"};
        for (int i = 0; i < tmp.length; ++i) {
            rfc3261Methods.add(tmp[i]);
        }
        log.info((Object)("\n================SIP METHODS====================\n" + rfc3261Methods + "\n==============================================="));
    }

    private class DTERemoveTask
    extends TimerTask {
        private DialogWrapper dw = null;
        private int eventID = -1;
        private ComponentKey key = null;
        private int runCount = 0;
        private int runLimit = 10;

        public DTERemoveTask(DialogWrapper dw, int eventID, ComponentKey key) {
            this.dw = dw;
            this.eventID = eventID;
            this.key = key;
        }

        public DialogWrapper getDw() {
            return this.dw;
        }

        public int getEventID() {
            return this.eventID;
        }

        public ComponentKey getKey() {
            return this.key;
        }

        public void run() {
            if (this.dw.isInStateEventFireSequence() && this.runCount < this.runLimit) {
                ++this.runCount;
                DTERemoveTask drt = new DTERemoveTask(this.dw, this.eventID, this.key);
                drt.runCount = this.runCount;
                SipResourceAdaptor.this.timer.schedule((TimerTask)drt, 150L);
                return;
            }
            SipToSLEEUtility.displayDeliveryMessage("DTERemoveRunnable", this.eventID, this.key, this.dw.getActivityHandle().transactionId);
            try {
                DialogTerminatedEventWrapper event = new DialogTerminatedEventWrapper(SipResourceAdaptor.this.sipFactoryProvider.getSipProvider(), this.dw);
                SipResourceAdaptor.this.sleeEndpoint.fireEvent((ActivityHandle)this.dw.getActivityHandle(), (Object)event, this.eventID, new Address(AddressPlan.SIP, this.dw.getLocalParty().toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SipResourceAdaptor.this.sendActivityEndEvent(this.dw);
        }
    }

    private class EventTimerTask
    extends TimerTask {
        int runCount = 0;

        private EventTimerTask() {
        }

        public void run() {
            SipResourceAdaptor.this.debugLogger.info((Object)("-------------------- DEUMP RUN[" + this.runCount + "]-----------------"));
            SipResourceAdaptor.this.debugLogger.info((Object)("[" + this.runCount + "] ACTIVITIES DUMP"));
            TreeMap ac = new TreeMap(SipResourceAdaptor.this.activities);
            int count = 0;
            for (Object key : ac.keySet()) {
                SipResourceAdaptor.this.debugLogger.info((Object)("[" + this.runCount + "] AC[" + count++ + "] KEY[" + key + "] A[" + ac.get(key) + "]"));
            }
            SipResourceAdaptor.this.debugLogger.info((Object)("[" + this.runCount + "] --- EVENTS RECEVIED"));
            ArrayList orderCopy = new ArrayList(SipResourceAdaptor.this.orderOfEvent);
            count = 0;
            for (Object event : orderCopy) {
                SipResourceAdaptor.this.debugLogger.info((Object)("[" + this.runCount + "] EVENT[" + count++ + "] E[" + event + "] STAMP[" + SipResourceAdaptor.this.timeStamps.get(event) + "] A[" + SipResourceAdaptor.this.receivedEvents.get(event) + "]"));
            }
            SipResourceAdaptor.this.debugLogger.info((Object)("[" + this.runCount + "] ================================================"));
            ++this.runCount;
        }
    }
}

