/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip.wrappers;

import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.address.Address;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.AddressPlan;
import javax.slee.resource.ActivityHandle;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.resource.sip.SipActivityHandle;
import org.mobicents.slee.resource.sip.SipResourceAdaptor;
import org.mobicents.slee.resource.sip.SipToSLEEUtility;
import org.mobicents.slee.resource.sip.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip.wrappers.DialogTimeoutTimerTask;
import org.mobicents.slee.resource.sip.wrappers.ResponseEventWrapper;

public class DialogWrapper
implements Dialog {
    private static Logger logger = Logger.getLogger(DialogWrapper.class);
    private Object applicationData = null;
    private String localID = null;
    protected Dialog realDialog = null;
    private DialogState lastState = null;
    private boolean termianteOnBye = false;
    private SipResourceAdaptor sipResourceAdaptor;
    private static long dialogTimeout = 0x6DDD00L;
    private boolean hasTimedOut = false;
    private static Timer dialogTimer = new Timer();
    private DialogTimeoutTimerTask timerTask;
    private SipActivityHandle activityHandle;
    private boolean bothTagsPresent = false;
    private int pendingStateEvents = 0;
    private boolean hasBeenCanceled = false;

    public DialogWrapper(Dialog realDialog, SipResourceAdaptor sipResourceAdaptor) {
        this.realDialog = realDialog;
        try {
            realDialog.setApplicationData((Object)this);
            this.localID = (realDialog.getLocalParty().toString() + ":" + realDialog.getLocalTag() + ":" + realDialog.getRemoteParty().toString() + ":" + realDialog.getRemoteTag() + ":" + realDialog.getCallId()).trim();
            this.bothTagsPresent = realDialog.getLocalTag() != null && realDialog.getRemoteTag() != null;
            this.lastState = realDialog.getState();
            if (dialogTimeout > 0L) {
                this.timerTask = new DialogTimeoutTimerTask(this, sipResourceAdaptor);
                dialogTimer.schedule((TimerTask)this.timerTask, dialogTimeout);
            }
            this.sipResourceAdaptor = sipResourceAdaptor;
            this.activityHandle = new SipActivityHandle(this.getDialogId(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Dialog getRealDialog() {
        return this.realDialog;
    }

    public Address getLocalParty() {
        return this.realDialog.getLocalParty();
    }

    public Address getRemoteParty() {
        return this.realDialog.getRemoteParty();
    }

    public Address getRemoteTarget() {
        return this.realDialog.getRemoteTarget();
    }

    public String getDialogId() {
        return this.localID;
    }

    public CallIdHeader getCallId() {
        return this.realDialog.getCallId();
    }

    public int getLocalSequenceNumber() {
        return this.realDialog.getLocalSequenceNumber();
    }

    public int getRemoteSequenceNumber() {
        return this.realDialog.getRemoteSequenceNumber();
    }

    public long getLocalSeqNumber() {
        return this.realDialog.getLocalSeqNumber();
    }

    public long getRemoteSeqNumber() {
        return this.realDialog.getRemoteSeqNumber();
    }

    public Iterator getRouteSet() {
        return this.realDialog.getRouteSet();
    }

    public boolean isSecure() {
        return this.realDialog.isSecure();
    }

    public boolean isServer() {
        return this.realDialog.isServer();
    }

    public void incrementLocalSequenceNumber() {
        this.realDialog.incrementLocalSequenceNumber();
    }

    public Request createRequest(String arg0) throws SipException {
        return this.realDialog.createRequest(arg0);
    }

    public Response createReliableProvisionalResponse(int arg0) throws InvalidArgumentException, SipException {
        return this.realDialog.createReliableProvisionalResponse(arg0);
    }

    public void sendRequest(ClientTransaction clientTransaction) throws TransactionDoesNotExistException, SipException {
        this.realDialog.sendRequest((ClientTransaction)((ClientTransactionWrapper)clientTransaction).getRealTransaction());
        this.renew();
    }

    public void sendReliableProvisionalResponse(Response arg0) throws SipException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("------- SENDING ReliableProvisionalResponse ------\n" + arg0 + "-------------------------------"));
        }
        this.realDialog.sendReliableProvisionalResponse(arg0);
        this.renew();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n-----------------------------------------\nOld State: " + this.lastState + "\nNew State: " + this.getState() + "\n--------------------------------------"));
        }
        this.fireDialogStateEvent(arg0);
    }

    public Request createPrack(Response arg0) throws DialogDoesNotExistException, SipException {
        return this.realDialog.createPrack(arg0);
    }

    public Request createAck(long arg0) throws InvalidArgumentException, SipException {
        return this.realDialog.createAck(arg0);
    }

    public void sendAck(Request arg0) throws SipException {
        this.realDialog.sendAck(arg0);
        this.renew();
    }

    public DialogState getState() {
        return this.realDialog.getState();
    }

    public void delete() {
        this.realDialog.delete();
        this.cancel();
    }

    public Transaction getFirstTransaction() {
        return this.realDialog.getFirstTransaction();
    }

    public String getLocalTag() {
        return this.realDialog.getLocalTag();
    }

    public String getRemoteTag() {
        return this.realDialog.getRemoteTag();
    }

    public void setApplicationData(Object applicaionData) {
        this.applicationData = applicaionData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public void terminateOnBye(boolean terminate) throws SipException {
        this.termianteOnBye = terminate;
        this.realDialog.terminateOnBye(terminate);
    }

    public boolean getTerminateOnBye() {
        return this.termianteOnBye;
    }

    public DialogState getLastState() {
        return this.lastState;
    }

    public void setLastState(DialogState lastState) {
        this.lastState = lastState;
    }

    public String toString() {
        return "[DialogW   Handler[" + this.activityHandle + "] LOCALID[" + this.localID + "] DESC[" + super.toString() + "] WRAPPED[" + this.realDialog + "] STATE[" + this.realDialog.getState() + "] REALID[" + this.realDialog.getDialogId() + "]]";
    }

    public void renew() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Renewing timeout task for dialog " + this.getDialogId()));
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
            if (dialogTimeout > 0L) {
                DialogTimeoutTimerTask newTimerTask = new DialogTimeoutTimerTask(this, this.sipResourceAdaptor);
                dialogTimer.schedule((TimerTask)newTimerTask, dialogTimeout);
                this.timerTask = newTimerTask;
            }
        }
    }

    public boolean cancel() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[CANCEL TIMER]Cancelling timeout task for dialog " + this.getDialogId()));
        }
        boolean returnValue = false;
        if (this.timerTask != null) {
            returnValue = this.timerTask.cancel();
            if (returnValue && !this.hasBeenCanceled) {
                this.hasBeenCanceled = true;
            }
            return returnValue;
        }
        return false;
    }

    public boolean hasBeenCanceled() {
        return this.hasBeenCanceled;
    }

    public void setHasTimedOut() {
        this.hasTimedOut = true;
    }

    public boolean getHasTimedOut() {
        return this.hasTimedOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireDialogStateEvent(Response response) {
        try {
            String sipMethod;
            ComponentKey key;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\n---------------------------------------------\nSTATE:" + this.getState() + "\nOLD:" + this.getLastState() + "\n---------------------------------------------"));
            }
            if ((key = this.getKeyFor1_2DialogState(sipMethod = ((CSeqHeader)response.getHeader("CSeq")).getMethod(), response)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"------------------ NO STATE EVENT HAS TO BE FIRED ----------------");
                }
                boolean bl = false;
                return bl;
            }
            boolean result = false;
            if (!this.sipResourceAdaptor.isEventGoingToBereceived(key)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("------------------ STATE EVENT[" + key + "] FOR DIALOG[" + this.getDialogId() + "] WONT BE RECEIVED, DROPING ----------------"));
                }
            } else {
                SipToSLEEUtility.displayMessage("Wrapper[" + this.getClass() + "]", "Looking up event", key);
                int eventID = -1;
                try {
                    eventID = this.sipResourceAdaptor.getBootstrapContext().getEventLookupFacility().getEventID(key.getName(), key.getVendor(), key.getVersion());
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                if (eventID == -1) {
                    SipToSLEEUtility.displayMessage("Wrapper[" + this.getClass() + "]", "Event is not a a registared event type", key);
                } else {
                    SipToSLEEUtility.displayDeliveryMessage("Wrapper[" + this.getClass() + "]", eventID, key, this.getDialogId());
                    if (!this.bothTagsPresent && (key.getName().endsWith("SetupEarly") || key.getName().endsWith("SetupConfirmed"))) {
                        boolean bl = this.bothTagsPresent = this.realDialog.getLocalTag() != null && this.realDialog.getRemoteTag() != null;
                        if (this.bothTagsPresent) {
                            this.localID = (this.realDialog.getLocalParty().toString() + ":" + this.realDialog.getLocalTag() + ":" + this.realDialog.getRemoteParty().toString() + ":" + this.realDialog.getRemoteTag() + ":" + this.realDialog.getCallId()).trim();
                            this.activityHandle.update(this.localID);
                        }
                    }
                    try {
                        this.sipResourceAdaptor.getBootstrapContext().getSleeEndpoint().fireEvent((ActivityHandle)this.getActivityHandle(), (Object)new ResponseEventWrapper(this.sipResourceAdaptor.getSipFactoryProvider(), null, this, response), eventID, new javax.slee.Address(AddressPlan.SIP, ((ToHeader)response.getHeader("To")).getAddress().toString()));
                        result = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.endStateEventFireSequence();
        }
    }

    public static void setDialogTimeout(long timeout) {
        dialogTimeout = timeout;
    }

    private boolean fireDTE(String method, int statusCode) {
        return false;
    }

    public ComponentKey getKeyFor1_2DialogState(String method, Response response) {
        int statusCode = response.getStatusCode();
        ComponentKey key = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" == METHOD:" + method + "  StatusCODE:" + statusCode + " =="));
        }
        DialogState localLastState = this.getLastState();
        if (this.getLastState() != this.getState()) {
            int stateToSwitch = -1;
            if (statusCode < 200 && statusCode > 99) {
                if (this.getState().getValue() == 1 || this.getState().getValue() == 3) {
                    if (((ToHeader)response.getHeader("To")).getTag() != null && ((FromHeader)response.getHeader("From")).getTag() != null) {
                        stateToSwitch = 0;
                    } else {
                        this.setLastState(this.getState());
                        stateToSwitch = this.getState().getValue();
                    }
                } else {
                    this.setLastState(this.getState());
                    stateToSwitch = this.getState().getValue();
                }
            } else {
                this.setLastState(this.getState());
                stateToSwitch = this.getState().getValue();
            }
            switch (stateToSwitch) {
                case 0: {
                    key = new ComponentKey("javax.sip.dialog.SetupEarly", "net.java", "1.2");
                    break;
                }
                case 1: {
                    key = new ComponentKey("javax.sip.dialog.SetupConfirmed", "net.java", "1.2");
                    break;
                }
                case 3: {
                    if (localLastState != null && this.lastState != null && localLastState.getValue() != 0 && this.lastState.getValue() != 0 || !method.equals("CANCEL") && !method.equals("INVITE")) break;
                    key = new ComponentKey("javax.sip.dialog.SetupFailed", "net.java", "1.2");
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n===================\nSTATE KEY:" + key + "\n==================="));
            logger.debug((Object)("COND:STATE[" + this.getState() + "] Last state[" + localLastState + "] (" + (localLastState == null || localLastState.getValue() == 0) + ")(" + (this.getState() == null || this.getState().getValue() == 0) + ") Method[" + method + "] Status[" + statusCode + "]"));
        }
        if (!(key != null || localLastState != null && localLastState.getValue() != 0 || this.getState() != null && this.getState().getValue() != 0 || !method.equals("CANCEL") || statusCode != 200)) {
            key = new ComponentKey("javax.sip.dialog.SetupFailed", "net.java", "1.2");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n===================\nRETURNING STATE KEY:" + key + "\nFOR:" + method + "\nSTATUS:" + statusCode + "\n==================="));
        }
        return key;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.realDialog.setApplicationData(null);
            this.realDialog = null;
            this.timerTask.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SipActivityHandle getActivityHandle() {
        return this.activityHandle;
    }

    public synchronized void startStateEventFireSequence() {
        ++this.pendingStateEvents;
    }

    public synchronized void endStateEventFireSequence() {
        --this.pendingStateEvents;
        if (this.pendingStateEvents < 0) {
            this.pendingStateEvents = 0;
        }
    }

    public synchronized boolean isInStateEventFireSequence() {
        return this.pendingStateEvents != 0;
    }
}

