/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip;

import java.io.Serializable;
import java.util.HashSet;
import javax.sip.ListeningPoint;
import javax.sip.SipProvider;
import javax.sip.address.AddressFactory;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;
import org.mobicents.slee.resource.sip.SipProviderProxy;
import org.mobicents.slee.resource.sip.SipResourceAdaptor;
import org.mobicents.slee.resource.sip.SipResourceAdaptorSbbInterface;

public class SipFactoryProvider
implements SipResourceAdaptorSbbInterface,
Serializable {
    private transient AddressFactory addressFactory;
    private transient MessageFactory messageFactory;
    private transient HeaderFactory headerFactory;
    private transient SipProviderProxy sipProvider;
    private transient String hostAddress = null;
    private transient String[] transports = null;
    private transient int port = -1;

    private void check() {
        if (this.sipProvider == null) {
            throw new IllegalStateException("The resource adaptor has already been stopped");
        }
    }

    public void release() {
        if (this.sipProvider != null) {
            this.sipProvider.release();
        }
        this.addressFactory = null;
        this.messageFactory = null;
        this.headerFactory = null;
        this.sipProvider = null;
    }

    public SipFactoryProvider(AddressFactory addressFactory, MessageFactory messageFactory, HeaderFactory headerFactory, SipProvider sipProvider, SipResourceAdaptor sipResourceAdaptor) {
        this.addressFactory = addressFactory;
        this.messageFactory = messageFactory;
        this.headerFactory = headerFactory;
        this.sipProvider = new SipProviderProxy(sipProvider, sipResourceAdaptor);
        HashSet<String> transports = new HashSet<String>();
        ListeningPoint[] lps = sipProvider.getListeningPoints();
        for (int i = 0; i < lps.length; ++i) {
            transports.add(lps[i].getTransport());
        }
        this.transports = new String[transports.size()];
        this.transports = transports.toArray(this.transports);
        this.hostAddress = lps[0].getIPAddress();
        this.port = lps[0].getPort();
    }

    public AddressFactory getAddressFactory() {
        this.check();
        return this.addressFactory;
    }

    public HeaderFactory getHeaderFactory() {
        this.check();
        return this.headerFactory;
    }

    public MessageFactory getMessageFactory() {
        this.check();
        return this.messageFactory;
    }

    public SipProvider getSipProvider() {
        this.check();
        return this.sipProvider;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public int getHostPort() {
        return this.port;
    }

    public String[] getTransports() {
        return this.transports;
    }
}

