/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import java.util.concurrent.ConcurrentHashMap;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.facilities.EventLookupFacility;

public class EventIDCache {
    private static final String EVENT_PREFIX_1_2 = "javax.sip.dialog.";
    private static final String EVENT_PREFIX_1_1 = "javax.sip.message.";
    private static final String VENDOR_1_2 = "net.java";
    private static final String VERSION_1_2 = "1.2";
    private static final String VENDOR_1_1 = "javax.sip";
    private static final String VERSION_1_1 = "1.1";
    private static final String RESPONSE_MIDIX = "Response.";
    private static final String REQUEST_MIDIX = "Request.";
    private static final String TIMEOUT_EVENTNAME = "javax.sip.timeout.TRANSACTION";
    private ConcurrentHashMap<String, Integer> eventIds = new ConcurrentHashMap();

    public int getEventId(EventLookupFacility eventLookupFacility, Request request, boolean inDialog) {
        if (inDialog) {
            return this.getEventId(eventLookupFacility, "javax.sip.dialog.Request." + request.getMethod(), VENDOR_1_2, VERSION_1_2);
        }
        return this.getEventId(eventLookupFacility, "javax.sip.message.Request." + request.getMethod(), VENDOR_1_1, VERSION_1_1);
    }

    public int getEventId(EventLookupFacility eventLookupFacility, Response response, boolean inDialog) {
        int statusCode = response.getStatusCode();
        String statusCodeName = null;
        statusCodeName = statusCode == 100 ? "TRYING" : (100 < statusCode && statusCode < 200 ? "INFORMATIONAL" : (statusCode < 300 ? "SUCCESS" : (statusCode < 400 ? "REDIRECT" : (statusCode < 500 ? "CLIENT_ERROR" : (statusCode < 600 ? "SERVER_ERROR" : "GLOBAL_FAILURE")))));
        if (inDialog) {
            return this.getEventId(eventLookupFacility, "javax.sip.message.Response." + statusCodeName, VENDOR_1_2, VERSION_1_2);
        }
        return this.getEventId(eventLookupFacility, "javax.sip.message.Response." + statusCodeName, VENDOR_1_1, VERSION_1_1);
    }

    public int getTimeoutEventId(EventLookupFacility eventLookupFacility, boolean inDialog) {
        if (inDialog) {
            return this.getEventId(eventLookupFacility, TIMEOUT_EVENTNAME, VENDOR_1_2, VERSION_1_2);
        }
        return this.getEventId(eventLookupFacility, TIMEOUT_EVENTNAME, VENDOR_1_1, VERSION_1_1);
    }

    private int getEventId(EventLookupFacility eventLookupFacility, String eventName, String eventVendor, String eventVersion) {
        String key = eventName + eventVersion;
        Integer integer = this.eventIds.get(key);
        if (integer == null) {
            try {
                integer = eventLookupFacility.getEventID(eventName, eventVendor, eventVersion);
            }
            catch (Exception e) {
                integer = -1;
            }
            this.eventIds.put(key, integer);
        }
        return integer;
    }
}

